/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.nattable.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.IAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.PasteEObjectConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.IMasterAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablecelleditor.ICellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StyledElement;
import org.eclipse.papyrus.infra.nattable.utils.StyleUtils;

public class TableToTableConfigurationConverter {
    private final Table table;
    private final String type;
    private final String name;
    private final String iconPath;
    private final String description;

    public TableToTableConfigurationConverter(Table table, String name, String type, String iconPath, String description) {
        Assert.isNotNull((Object)table);
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)name);
        Assert.isTrue((type.length() > 0 ? 1 : 0) != 0, (String)"The type of the TableConfiguration can't be an empty string");
        Assert.isTrue((name.length() > 0 ? 1 : 0) != 0, (String)"The name of the TableConfiguration can't be an empty string");
        this.table = table;
        this.type = type;
        this.name = name;
        this.iconPath = iconPath;
        this.description = description;
    }

    public final TableConfiguration convertTable() {
        HashSet conf;
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        TableConfiguration ancestorTableConfiguration = this.table.getTableConfiguration();
        TableConfiguration newConfiguration = NattableconfigurationFactory.eINSTANCE.createTableConfiguration();
        newConfiguration.setName(this.name);
        newConfiguration.setDescription(this.description);
        newConfiguration.setType(this.type);
        newConfiguration.setIconPath(this.iconPath);
        newConfiguration.setCellEditorDeclaration(ancestorTableConfiguration.getCellEditorDeclaration());
        newConfiguration.getStyles().addAll(StyleUtils.getCombinedStyles((StyledElement)this.table, (StyledElement)ancestorTableConfiguration));
        ICellEditorConfiguration ownedCellEditorConfiguration = null;
        ownedCellEditorConfiguration = this.table.getOwnedCellEditorConfigurations() == null ? ancestorTableConfiguration.getOwnedCellEditorConfigurations() : this.table.getOwnedCellEditorConfigurations();
        if (ownedCellEditorConfiguration != null) {
            ownedCellEditorConfiguration = (ICellEditorConfiguration)copier.copy((EObject)ownedCellEditorConfiguration);
            newConfiguration.setOwnedCellEditorConfigurations(ownedCellEditorConfiguration);
        }
        TableHeaderAxisConfiguration newRowTableHeaderAxisConfiguration = this.createTableHeaderAxisConfiguration(this.table.getTableConfiguration().getRowHeaderAxisConfiguration(), this.table.getLocalRowHeaderAxisConfiguration(), copier);
        newConfiguration.setRowHeaderAxisConfiguration(newRowTableHeaderAxisConfiguration);
        TableHeaderAxisConfiguration newColulmnTableHeaderAxisConfiguration = this.createTableHeaderAxisConfiguration(this.table.getTableConfiguration().getColumnHeaderAxisConfiguration(), this.table.getLocalColumnHeaderAxisConfiguration(), copier);
        newConfiguration.setColumnHeaderAxisConfiguration(newColulmnTableHeaderAxisConfiguration);
        AbstractAxisProvider columnAxisProvider = this.table.getCurrentColumnAxisProvider();
        AbstractAxisProvider newColumnAxisProvider = (AbstractAxisProvider)copier.copy((EObject)columnAxisProvider);
        copier.copyReferences();
        this.removeCurrentModelAxis(newColumnAxisProvider);
        newConfiguration.getColumnAxisProviders().add((Object)newColumnAxisProvider);
        newConfiguration.setDefaultColumnAxisProvider(newColumnAxisProvider);
        AbstractAxisProvider rowAxisProvider = this.table.getCurrentRowAxisProvider();
        AbstractAxisProvider newRowAxisProvider = (AbstractAxisProvider)copier.copy((EObject)rowAxisProvider);
        copier.copyReferences();
        this.removeCurrentModelAxis(newRowAxisProvider);
        newConfiguration.getRowAxisProviders().add((Object)newRowAxisProvider);
        newConfiguration.setDefaultRowAxisProvider(newRowAxisProvider);
        for (AxisManagerRepresentation currentRep : newConfiguration.getRowHeaderAxisConfiguration().getAxisManagers()) {
            conf = new HashSet();
            conf.addAll(currentRep.getSpecificAxisConfigurations());
            currentRep.getSpecificAxisConfigurations().clear();
            currentRep.getSpecificAxisConfigurations().addAll(conf);
        }
        for (AxisManagerRepresentation currentRep : newConfiguration.getColumnHeaderAxisConfiguration().getAxisManagers()) {
            conf = new HashSet();
            conf.addAll(currentRep.getSpecificAxisConfigurations());
            currentRep.getSpecificAxisConfigurations().clear();
            currentRep.getSpecificAxisConfigurations().addAll(conf);
        }
        return newConfiguration;
    }

    private void removeCurrentModelAxis(AbstractAxisProvider axisProvider) {
        ArrayList<IAxis> axisToRemove = new ArrayList<IAxis>();
        if (axisProvider instanceof IMasterAxisProvider) {
            axisProvider.getAxis().clear();
            ((IMasterAxisProvider)axisProvider).getSources().clear();
            return;
        }
        for (IAxis current : axisProvider.getAxis()) {
            if (!(current.getElement() instanceof EObject)) continue;
            EObject element = (EObject)current.getElement();
            if (element.eResource() != null && element.eResource().getURI() != null && element.eResource().getURI().isPlatformResource()) {
                axisToRemove.add(current);
            }
            if (!(element instanceof TreeFillingConfiguration)) continue;
            axisToRemove.add(current);
        }
        axisProvider.getAxis().removeAll(axisToRemove);
    }

    private final TableHeaderAxisConfiguration createTableHeaderAxisConfiguration(TableHeaderAxisConfiguration ancestorTableHeaderAxisConfiguration, LocalTableHeaderAxisConfiguration localRow, EcoreUtil.Copier copier) {
        TableHeaderAxisConfiguration newRowHeaderAxisConfiguration;
        if (localRow == null) {
            newRowHeaderAxisConfiguration = (TableHeaderAxisConfiguration)copier.copy((EObject)ancestorTableHeaderAxisConfiguration);
        } else {
            newRowHeaderAxisConfiguration = NattableaxisconfigurationFactory.eINSTANCE.createTableHeaderAxisConfiguration();
            copier.put((Object)ancestorTableHeaderAxisConfiguration, (Object)newRowHeaderAxisConfiguration);
            newRowHeaderAxisConfiguration.setDisplayFilter(localRow.isDisplayFilter());
            newRowHeaderAxisConfiguration.setDisplayIndex(localRow.isDisplayIndex());
            newRowHeaderAxisConfiguration.setDisplayLabel(localRow.isDisplayLabel());
            newRowHeaderAxisConfiguration.setIndexStyle(localRow.getIndexStyle());
            newRowHeaderAxisConfiguration.getStyles().addAll(StyleUtils.getCombinedStyles((StyledElement)localRow, (StyledElement)ancestorTableHeaderAxisConfiguration));
            EList axisManagerConfigurations = localRow.getAxisManagerConfigurations();
            if (axisManagerConfigurations.size() == 0) {
                TableHeaderAxisConfiguration tmpCopy = (TableHeaderAxisConfiguration)EcoreUtil.copy((EObject)ancestorTableHeaderAxisConfiguration);
                newRowHeaderAxisConfiguration.getAxisManagers().addAll((Collection)tmpCopy.getAxisManagers());
                newRowHeaderAxisConfiguration.getOwnedLabelConfigurations().addAll((Collection)tmpCopy.getOwnedLabelConfigurations());
                newRowHeaderAxisConfiguration.getOwnedAxisConfigurations().addAll((Collection)tmpCopy.getOwnedAxisConfigurations());
            } else {
                for (AxisManagerConfiguration currentAxisManagerConfiguration : axisManagerConfigurations) {
                    AxisManagerRepresentation newAxisManagerRepresentation = NattableaxisconfigurationFactory.eINSTANCE.createAxisManagerRepresentation();
                    newAxisManagerRepresentation.setAxisManagerId(currentAxisManagerConfiguration.getAxisManager().getAxisManagerId());
                    newAxisManagerRepresentation.setLabelProviderContext(currentAxisManagerConfiguration.getAxisManager().getLabelProviderContext());
                    newAxisManagerRepresentation.getStyles().addAll(StyleUtils.getCombinedStyles((StyledElement)currentAxisManagerConfiguration, (StyledElement)currentAxisManagerConfiguration.getAxisManager()));
                    newRowHeaderAxisConfiguration.getAxisManagers().add((Object)newAxisManagerRepresentation);
                    if (currentAxisManagerConfiguration.getLocalHeaderLabelConfiguration() != null) {
                        newAxisManagerRepresentation.setHeaderLabelConfiguration((ILabelProviderConfiguration)copier.copy((EObject)currentAxisManagerConfiguration.getLocalHeaderLabelConfiguration()));
                    } else {
                        newAxisManagerRepresentation.setHeaderLabelConfiguration((ILabelProviderConfiguration)copier.copy((EObject)currentAxisManagerConfiguration.getAxisManager().getHeaderLabelConfiguration()));
                    }
                    newRowHeaderAxisConfiguration.getOwnedLabelConfigurations().add((Object)newAxisManagerRepresentation.getHeaderLabelConfiguration());
                    if (currentAxisManagerConfiguration.getLocalSpecificConfigurations().size() != 0) {
                        List copiedAxisConfig = (List)copier.copyAll((Collection)currentAxisManagerConfiguration.getLocalSpecificConfigurations());
                        copier.copyReferences();
                        for (IAxisConfiguration current : copiedAxisConfig) {
                            EObject copiedValue;
                            PasteEObjectConfiguration pasteConf;
                            EObject copiedValue2;
                            if (!(current instanceof TreeFillingConfiguration)) continue;
                            ILabelProviderConfiguration provider = ((TreeFillingConfiguration)current).getLabelProvider();
                            if (provider != null && (copiedValue2 = (EObject)copier.get((Object)provider)) == null) {
                                copiedValue2 = copier.copy((EObject)provider);
                                ((TreeFillingConfiguration)current).setLabelProvider((ILabelProviderConfiguration)copiedValue2);
                                newRowHeaderAxisConfiguration.getOwnedLabelConfigurations().add((Object)((ILabelProviderConfiguration)copiedValue2));
                            }
                            if ((pasteConf = ((TreeFillingConfiguration)current).getPasteConfiguration()) == null || (copiedValue = (EObject)copier.get((Object)pasteConf)) != null) continue;
                            copiedValue = copier.copy((EObject)pasteConf);
                            ((TreeFillingConfiguration)current).setPasteConfiguration((PasteEObjectConfiguration)copiedValue);
                            newRowHeaderAxisConfiguration.getOwnedAxisConfigurations().add((Object)((IAxisConfiguration)copiedValue));
                        }
                        newRowHeaderAxisConfiguration.getOwnedAxisConfigurations().addAll((Collection)copiedAxisConfig);
                        newAxisManagerRepresentation.getSpecificAxisConfigurations().addAll((Collection)copiedAxisConfig);
                    }
                    copier.copyReferences();
                    newRowHeaderAxisConfiguration.getAxisManagers().add((Object)newAxisManagerRepresentation);
                }
            }
        }
        return newRowHeaderAxisConfiguration;
    }
}

