/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.codegen.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.papyrus.eclipse.project.editors.file.BuildEditor;

public abstract class AbstractBuild {
    private Collection<String> existingBinaryIncludes = new HashSet<String>();
    private Collection<String> existingSourceIncludes = new HashSet<String>();
    private Collection<String> existingSourceFolders = new HashSet<String>();
    private static final String SOURCE_INCLUDES_DECLARATION = "src.includes = ";
    private static final String BINARY_INCLUDES_DECLARATION = "bin.includes = ";
    private static final String SOURCE_DECLARATION = "source.. = ";
    private static final String LICENCE_TAG = "#################################################################################";
    private IProject project;

    protected void init(String projectName) {
        if (projectName != null && !projectName.isEmpty()) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.initFields();
        }
    }

    private void initFields() {
        try {
            String current;
            BuildEditor buildEditor = new BuildEditor(this.project);
            buildEditor.init();
            String[] stringArray = buildEditor.getElementsInBuild();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                current = stringArray[n2];
                this.existingBinaryIncludes.add(current);
                ++n2;
            }
            stringArray = buildEditor.getSourceFolders();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                current = stringArray[n2];
                this.existingSourceFolders.add(current);
                ++n2;
            }
            stringArray = buildEditor.getSourceIncludes();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                current = stringArray[n2];
                this.existingSourceIncludes.add(current);
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final String buildBinaryIncludes() {
        Collection<String> includes = this.getGMFBinIncludes();
        includes.addAll(this.existingBinaryIncludes);
        return this.buildEntry(BINARY_INCLUDES_DECLARATION, includes);
    }

    public final String buildSourceFolder() {
        Collection<String> includes = this.getGMFSourceFolder();
        includes.addAll(this.existingSourceFolders);
        return this.buildEntry(SOURCE_DECLARATION, includes);
    }

    private final String buildEntry(String key, Collection<String> values) {
        StringBuilder builder = new StringBuilder();
        if (values.size() > 0) {
            Iterator<String> iter = values.iterator();
            String spaces = AbstractBuild.getAlignmentSpacesFor(key);
            builder.append(key);
            if (iter.hasNext()) {
                builder.append(iter.next());
                if (iter.hasNext()) {
                    builder.append(",\\\n");
                }
            }
            while (iter.hasNext()) {
                builder.append(spaces);
                builder.append(iter.next());
                if (!iter.hasNext()) continue;
                builder.append(",\\\n");
            }
        }
        return builder.toString();
    }

    public final String buildSourceIncludes() {
        return this.buildEntry(SOURCE_INCLUDES_DECLARATION, this.existingSourceIncludes);
    }

    private static final String getAlignmentSpacesFor(String entryDeclaration) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < entryDeclaration.length()) {
            builder.append(" ");
            ++i;
        }
        return builder.toString();
    }

    private final Collection<String> getGMFSourceFolder() {
        TreeSet<String> sources = new TreeSet<String>();
        sources.add("src-gen/");
        return sources;
    }

    private final Collection<String> getGMFBinIncludes() {
        TreeSet<String> includes = new TreeSet<String>();
        includes.add(".");
        includes.add("icons/");
        includes.add("META-INF/");
        includes.add("plugin.xml");
        includes.add("plugin.properties");
        includes.add("messages.properties");
        includes.add(".options");
        return includes;
    }

    public final String buildLicense(String license) {
        StringBuilder builder = new StringBuilder(LICENCE_TAG);
        builder.append("\n");
        String[] stringArray = license.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            builder.append("# ");
            builder.append(line);
            builder.append("\n");
            ++n2;
        }
        builder.append(LICENCE_TAG);
        return builder.toString();
    }
}

