/**
 * Copyright (c) 2014, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * 	Svyatoslav Kovalsky (Montages) - initial API and implementation
 * 	Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 */
package xpt;

import com.google.inject.Singleton;
import org.eclipse.emf.ecore.ETypedElement;

/**
 * XXX: [MG] not needed anymore, all ocl-related problems are gone with xtend, merge it with GenModelUtils_qvto
 */
@Singleton
@SuppressWarnings("all")
public class OclMigrationProblems_qvto {
  public boolean isUnbounded(final ETypedElement typedElement) {
    int _upperBound = typedElement.getUpperBound();
    return (_upperBound == ETypedElement.UNBOUNDED_MULTIPLICITY);
  }

  public boolean isSingleValued(final ETypedElement typedElement) {
    return ((typedElement.getUpperBound() == 1) || (typedElement.getUpperBound() == ETypedElement.UNSPECIFIED_MULTIPLICITY));
  }
}
