/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.validation.internal.providers;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.validation.IValidationMarkerListener;
import org.eclipse.papyrus.infra.services.validation.IValidationMarkersService;

public class ProblemsContentProvider
implements IStructuredContentProvider {
    private static final Object[] NONE = new Object[0];
    private AbstractTableViewer viewer;
    private IValidationMarkersService service;
    private IValidationMarkerListener listener;
    private ResourceSetListener resourceSetListener;

    public void dispose() {
        this.viewer = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IValidationMarkersService service;
        this.viewer = (AbstractTableViewer)viewer;
        if (oldInput instanceof IValidationMarkersService) {
            service = (IValidationMarkersService)oldInput;
            this.unhookMarkers(service);
            if (service.getModelSet() != null) {
                this.unhookResourceSet(service.getModelSet().getTransactionalEditingDomain());
            }
            this.service = null;
        }
        if (newInput instanceof IValidationMarkersService) {
            this.service = service = (IValidationMarkersService)newInput;
            this.hookMarkers(service);
            this.hookResourceSet(service.getModelSet().getTransactionalEditingDomain());
        }
    }

    public Object[] getElements(Object inputElement) {
        return inputElement instanceof IValidationMarkersService ? Iterables.toArray((Iterable)((IValidationMarkersService)inputElement).getMarkers(), IPapyrusMarker.class) : NONE;
    }

    protected void hookMarkers(IValidationMarkersService service) {
        service.addValidationMarkerListener(this.getValidationMarkerListener());
    }

    protected void unhookMarkers(IValidationMarkersService service) {
        service.removeValidationMarkerListener(this.getValidationMarkerListener());
    }

    private IValidationMarkerListener getValidationMarkerListener() {
        if (this.listener == null) {
            this.listener = new IValidationMarkerListener(){

                public void notifyMarkerChange(IPapyrusMarker marker, IValidationMarkerListener.MarkerChangeKind kind) {
                    if (ProblemsContentProvider.this.viewer != null) {
                        switch (kind) {
                            case ADDED: {
                                ProblemsContentProvider.this.viewer.add((Object)marker);
                                break;
                            }
                            case REMOVED: {
                                ProblemsContentProvider.this.viewer.remove((Object)marker);
                            }
                        }
                    }
                }
            };
        }
        return this.listener;
    }

    protected void hookResourceSet(TransactionalEditingDomain domain) {
        domain.addResourceSetListener(this.getResourceSetListener());
    }

    protected void unhookResourceSet(TransactionalEditingDomain domain) {
        domain.removeResourceSetListener(this.getResourceSetListener());
    }

    private ResourceSetListener getResourceSetListener() {
        if (this.resourceSetListener == null) {
            this.resourceSetListener = new DemultiplexingListener(){

                protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
                    Object feature = notification.getFeature();
                    if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                        switch (notification.getEventType()) {
                            case 3: {
                                this.handleContainment((EObject)notification.getNewValue());
                                break;
                            }
                            case 5: {
                                for (Object next : (Collection)notification.getNewValue()) {
                                    this.handleContainment((EObject)next);
                                }
                                break;
                            }
                            case 1: {
                                this.handleContainment((EObject)notification.getNewValue());
                            }
                        }
                    }
                }

                private void handleContainment(EObject object) {
                    Object[] markers = ProblemsContentProvider.this.service.getMarkers(object).toArray();
                    if (markers.length > 0) {
                        ProblemsContentProvider.this.viewer.update(markers, null);
                    }
                }
            };
        }
        return this.resourceSetListener;
    }
}

