/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.handler;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.Activator;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class UndeployCustomizationHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(currentSelection instanceof IStructuredSelection) || currentSelection.isEmpty()) {
            return null;
        }
        final IStructuredSelection selection = (IStructuredSelection)currentSelection;
        final Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Job undeploy = new Job("Disabling properties view configuration"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = UndeployCustomizationHandler.this.doExecute(selection, monitor);
                if (result.isOK()) {
                    monitor.subTask("Refreshing properties view configuration");
                    ConfigurationManager.getInstance().update();
                }
                return result;
            }
        };
        undeploy.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                activeShell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (event.getResult().isOK()) {
                            MessageDialog.openInformation((Shell)activeShell, (String)"Success", (String)event.getResult().getMessage());
                        } else {
                            MessageDialog.openWarning((Shell)activeShell, (String)"Error", (String)event.getResult().getMessage());
                        }
                    }
                });
            }
        });
        undeploy.setUser(true);
        undeploy.schedule();
        return null;
    }

    protected IStatus doExecute(IStructuredSelection selection, IProgressMonitor monitor) {
        Iterator selectionIterator = selection.iterator();
        boolean needsUpdate = false;
        monitor.beginTask("Disabling configurations", selection.size());
        while (selectionIterator.hasNext()) {
            Object selectedElement = selectionIterator.next();
            if (!(selectedElement instanceof IAdaptable)) continue;
            IFile selectedFile = (IFile)((IAdaptable)selectedElement).getAdapter(IFile.class);
            if (selectedFile == null) {
                monitor.worked(1);
                continue;
            }
            monitor.subTask("Disable " + selectedFile.getFullPath().removeFileExtension().lastSegment());
            URI emfURI = null;
            if (selectedFile.getFullPath() != null) {
                emfURI = URI.createPlatformResourceURI((String)selectedFile.getFullPath().toString(), (boolean)true);
            } else if (selectedFile.getRawLocation() != null) {
                emfURI = URI.createFileURI((String)selectedFile.getRawLocation().toString());
            }
            if (emfURI == null) {
                monitor.worked(1);
                continue;
            }
            try {
                for (Context deployedContext : ConfigurationManager.getInstance().getContexts()) {
                    if (!ConfigurationManager.getInstance().isCustomizable(deployedContext) || !EcoreUtil.getURI((EObject)deployedContext).trimFragment().equals(emfURI)) continue;
                    ConfigurationManager.getInstance().deleteContext(deployedContext, false);
                    needsUpdate = true;
                    break;
                }
                monitor.worked(1);
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        if (needsUpdate) {
            return new Status(0, "org.eclipse.papyrus.views.properties", "The selected properties view configuration has been successfully disabled");
        }
        return new Status(2, "org.eclipse.papyrus.views.properties", "The selected properties view configuration is not deployed");
    }
}

