/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.model.xwt.format;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.views.properties.model.xwt.Activator;

public class XMLFormatter {
    public static void format(IFile file) {
        try {
            InputStream input = file.getContents();
            StreamSource xmlInput = new StreamSource(input);
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 12);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            ByteArrayInputStream in = new ByteArrayInputStream(stringWriter.toString().getBytes());
            file.setContents((InputStream)in, 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            Activator.log.error(NLS.bind((String)"Exception during the formatting of {0}", (Object)file.getFullPath()), (Throwable)ex);
        }
        catch (TransformerConfigurationException e) {
            Activator.log.error(NLS.bind((String)"Exception during the formatting of {0}", (Object)file.getFullPath()), (Throwable)e);
        }
        catch (TransformerException e) {
            Activator.log.error(NLS.bind((String)"Exception during the formatting of {0}", (Object)file.getFullPath()), (Throwable)e);
        }
    }
}

