/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.databinding;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.tools.databinding.AbstractUMLValidator;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;

public class NamedElementValidator
extends AbstractUMLValidator {
    private EObject source;

    public NamedElementValidator() {
    }

    public NamedElementValidator(EObject source) {
        this.source = source != null ? source : null;
    }

    public IStatus validate(Object value) {
        boolean status = true;
        String string = null;
        if (value instanceof String) {
            string = (String)value;
        }
        if (string == null) {
            return Status.OK_STATUS;
        }
        if (this.source instanceof NamedElement) {
            NamedElement self = (NamedElement)this.source;
            Namespace ns = self.getNamespace();
            if (ns != null) {
                boolean deliver = self.eDeliver();
                boolean wasSet = self.isSetName();
                String oldName = self.getName();
                try {
                    self.eSetDeliver(false);
                    self.setName(string);
                    EList listElement = ns.getMembers();
                    for (NamedElement namedElement : listElement) {
                        if (self == namedElement || self.isDistinguishableFrom(namedElement, ns)) continue;
                        IStatus iStatus = this.warning("Name is indistinguishable from another element in the Namespace");
                        return iStatus;
                    }
                }
                finally {
                    if (wasSet) {
                        self.setName(oldName);
                    } else {
                        self.unsetName();
                    }
                    self.eSetDeliver(deliver);
                }
            }
            if (status) {
                return Status.OK_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }
}

