/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.editors;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.widgets.editors.StyledTextStringEditor;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.infra.widgets.util.PlatformUIUtils;
import org.eclipse.papyrus.infra.widgets.validator.AbstractValidator;
import org.eclipse.papyrus.uml.properties.editors.UMLReferenceContentAssistProcessor;
import org.eclipse.papyrus.uml.tools.utils.NameResolutionHelper;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class AutoCompleteStyledTextStringEditor
extends StyledTextStringEditor {
    private static final String CONTENT_ASSIST_COMMAND_ID = "org.eclipse.ui.edit.text.contentAssist.proposals";
    private TextViewer wrapper;
    protected INameResolutionHelper nameResolutionHelper;
    private ContentAssistant assistant;
    private UMLReferenceContentAssistProcessor processor;

    public INameResolutionHelper getNameResolutionHelper() {
        return this.nameResolutionHelper;
    }

    public void setValue(Object value) {
        if (value instanceof NamedElement) {
            super.setValue((Object)((NamedElement)value).getName());
        }
        super.setValue(value);
    }

    public AutoCompleteStyledTextStringEditor(Composite parent, int style) {
        super(parent, style);
        this.createReferenceTargetValidator();
    }

    protected void notifyChange() {
        this.text.notifyListeners(16, new Event());
        if (this.targetValidator != null) {
            IStatus status = this.targetValidator.validate((Object)this.text.getText());
            this.updateStatus(status);
        }
        this.commit();
        this.changeColorField();
    }

    protected void createReferenceTargetValidator() {
        this.targetValidator = new AbstractValidator(){

            public IStatus validate(Object value) {
                return Status.OK_STATUS;
            }
        };
    }

    public StyledText createStyledText(Composite parent, String value, int style) {
        this.wrapper = this.buildControls(parent, style);
        return this.wrapper.getTextWidget();
    }

    private TextViewer buildControls(Composite parent, int style) {
        TextViewer textViewer = new TextViewer(parent, 0x204 | style);
        textViewer.setDocument((IDocument)new Document());
        this.assistant = new ContentAssistant();
        this.processor = new UMLReferenceContentAssistProcessor(UMLPackage.eINSTANCE.getTypedElement_Type(), (NameResolutionHelper)this.nameResolutionHelper, this);
        this.assistant.setContentAssistProcessor((IContentAssistProcessor)this.processor, "__dftl_partition_content_type");
        this.assistant.setSorter(new ICompletionProposalSorter(){

            public int compare(ICompletionProposal p1, ICompletionProposal p2) {
                return p1.getDisplayString().compareTo(p2.getDisplayString());
            }
        });
        this.assistant.install((ITextViewer)textViewer);
        this.assistant.addCompletionListener(new ICompletionListener(){
            private boolean delayedIsOpen = false;

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        delayedIsOpen = true;
                    }
                });
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        delayedIsOpen = false;
                    }
                });
            }
        });
        PlatformUIUtils.handleCommand((Control)textViewer.getControl(), (String)CONTENT_ASSIST_COMMAND_ID, (String)"CTRL+SPACE", () -> ((ContentAssistant)this.assistant).showPossibleCompletions());
        return textViewer;
    }

    public void setNameResolutionHelper(INameResolutionHelper nameResolutionHelper) {
        this.nameResolutionHelper = nameResolutionHelper;
        if (nameResolutionHelper instanceof NameResolutionHelper) {
            this.processor.setNameResolutionHelper((NameResolutionHelper)nameResolutionHelper);
        }
    }

    public Object getContextElement() {
        return super.getContextElement();
    }
}

