/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.dialog;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.uml.profile.drafter.ui.contentassist.TypeContentProposalBase;
import org.eclipse.papyrus.uml.profile.drafter.ui.contentassist.TypeContentProposalProvider;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.ITypeCatalog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Type;

public class TypeSelectorLabel
extends Text {
    protected ITypeCatalog typeProvider;
    protected ILabelProvider typeLabelProvider;
    protected Type type;

    public TypeSelectorLabel(Composite parent, int style, ITypeCatalog typeProvider, ILabelProvider typeLabelProvider, Type defaultType) {
        super(parent, style);
        this.typeProvider = typeProvider;
        this.typeLabelProvider = typeLabelProvider;
        this.setType(defaultType);
        this.installContentAssist();
    }

    private void installContentAssist() {
        this.installContentAssistantProvider(new TypeContentProposalProvider(this.typeProvider));
    }

    protected void installContentAssistantProvider(IContentProposalProvider contentProposalProvider) {
        KeyStroke keyStroke = null;
        char[] autoActivationCharacters = null;
        int autoActivationDelay = 500;
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this, (IControlContentAdapter)new TextContentAdapter(), contentProposalProvider, keyStroke, autoActivationCharacters);
        adapter.setAutoActivationDelay(autoActivationDelay);
        adapter.setFilterStyle(1);
        adapter.setProposalAcceptanceStyle(2);
        adapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                if (proposal instanceof TypeContentProposalBase) {
                    TypeContentProposalBase typeProposal = (TypeContentProposalBase)proposal;
                    TypeSelectorLabel.this.setType(typeProposal.getType());
                }
            }
        });
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        String label = this.typeLabelProvider.getText((Object)type);
        this.setText(label);
        this.setTypeInternal(type);
    }

    public void setTypeInternal(Type type) {
        this.type = type;
    }
}

