/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.uml2.uml.Interaction;

public class InteractionUseUtil {
    public static Diagram findDiagram(View view, Interaction refInteraction) {
        Diagram diagram = view.getDiagram();
        EList list = diagram.eResource().getContents();
        for (EObject o : list) {
            Diagram ref;
            if (!(o instanceof Diagram) || !refInteraction.equals((ref = (Diagram)o).getElement())) continue;
            return ref;
        }
        return null;
    }

    public static void openDiagram(final Diagram diagram) {
        TransactionalEditingDomain editingDomain;
        IPageManager pageManager;
        try {
            pageManager = (IPageManager)ServiceUtilsForEObject.getInstance().getService(IPageManager.class, (Object)diagram);
            editingDomain = ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)diagram);
        }
        catch (Exception e) {
            return;
        }
        if (pageManager != null && pageManager.allPages().contains(diagram)) {
            if (pageManager.isOpen((Object)diagram)) {
                pageManager.selectPage((Object)diagram);
            } else {
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, "Open diagram"){

                    protected void doExecute() {
                        pageManager.openPage((Object)diagram);
                    }
                });
            }
        }
    }
}

