/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.interactionoverview.edit.part.CallBehaviorActionAsInteractionEditPart;
import org.eclipse.papyrus.uml.diagram.interactionoverview.edit.part.CustomInteractionUseEditPartCN;
import org.eclipse.papyrus.uml.diagram.interactionoverview.utils.DiagramUtils;
import org.eclipse.uml2.uml.CallBehaviorAction;

public class CallBehaviorUtil {
    private static final String CALL_BEHAVIOR_ACTION_ANNOTATION = "org.eclipse.papyrus.uml.diagram.interactionoverview.callbehavioraction";
    private static final String CALL_BEHAVIOR_ACTION_TYPE = "type";
    public static final String DIAGRAM_UUID_AS_INTERACTION_SNAPSHOT = "diagramUUIDForSnapshot";
    public static final String LIFELINE_QUALIFIED_NAME = "lifelineQualifiedNames";
    public static final String IS_BEHAVIOR_NEW = "isBehaviorNew";

    private CallBehaviorUtil() {
    }

    public static CallBehaviorActionType getCallBehaviorType(CallBehaviorAction callBehaviorAction) {
        String type;
        EAnnotation eAnnotation = callBehaviorAction.getEAnnotation(CALL_BEHAVIOR_ACTION_ANNOTATION);
        if (eAnnotation != null && (type = (String)eAnnotation.getDetails().get((Object)CALL_BEHAVIOR_ACTION_TYPE)) != null) {
            return CallBehaviorActionType.valueOf(type);
        }
        return CallBehaviorActionType.snapshot;
    }

    public static void setCallBehaviorActionType(CallBehaviorAction callBehaviorAction, CallBehaviorActionType callBehaviorActionType) {
        EAnnotation eAnnotation = callBehaviorAction.getEAnnotation(CALL_BEHAVIOR_ACTION_ANNOTATION);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(CALL_BEHAVIOR_ACTION_ANNOTATION);
            callBehaviorAction.getEAnnotations().add((Object)eAnnotation);
        }
        eAnnotation.getDetails().put((Object)CALL_BEHAVIOR_ACTION_TYPE, (Object)callBehaviorActionType.name());
    }

    public static boolean isCallBehaviorActionEditPart(String visualID) {
        return "CallBehaviorAction_Shape".equals(visualID) || "CallBehaviorAction_InteractionShape".equals(visualID);
    }

    public static boolean isCallBehaviorActionEditPart(EditPart editPart) {
        return editPart instanceof CustomInteractionUseEditPartCN || editPart instanceof CallBehaviorActionAsInteractionEditPart;
    }

    public static boolean isCallBehaviorActionView(View view) {
        String visualID = UMLVisualIDRegistry.getVisualID((View)view);
        if (visualID == null) {
            visualID = UMLVisualIDRegistry.getVisualID((View)view);
        }
        return CallBehaviorUtil.isCallBehaviorActionEditPart(visualID);
    }

    public static String getDiagramLinked(View callBehaviorActionView) {
        EAnnotation annotation = callBehaviorActionView.getEAnnotation(CALL_BEHAVIOR_ACTION_ANNOTATION);
        if (annotation != null) {
            return (String)annotation.getDetails().get((Object)DIAGRAM_UUID_AS_INTERACTION_SNAPSHOT);
        }
        return "";
    }

    public static void setDiagramLinked(View callBehaviorActionView, View diagramView) {
        String uuidDiagram;
        EAnnotation annotation = callBehaviorActionView.getEAnnotation(CALL_BEHAVIOR_ACTION_ANNOTATION);
        if (annotation == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource(CALL_BEHAVIOR_ACTION_ANNOTATION);
            callBehaviorActionView.getEAnnotations().add((Object)annotation);
        }
        if (annotation.getDetails().get((Object)DIAGRAM_UUID_AS_INTERACTION_SNAPSHOT) != null) {
            annotation.getDetails().clear();
        }
        if ((uuidDiagram = DiagramUtils.getUUIDForSnapshot(diagramView)) == null || uuidDiagram.equals("")) {
            uuidDiagram = EcoreUtil.generateUUID();
            DiagramUtils.setUUID(diagramView, uuidDiagram);
        }
        annotation.getDetails().put((Object)DIAGRAM_UUID_AS_INTERACTION_SNAPSHOT, (Object)uuidDiagram);
    }

    public static List<String> getRemovedLifelinesQualifiedNames(View callBehaviorActionView) {
        EAnnotation eAnnotation = callBehaviorActionView.getEAnnotation(LIFELINE_QUALIFIED_NAME);
        if (eAnnotation != null) {
            return new ArrayList<String>(eAnnotation.getDetails().keySet());
        }
        return new ArrayList<String>();
    }

    public static void addLifelineQualifiedNames(View callBehaviorActionView, String qualifiedName) {
        EAnnotation eAnnotation = callBehaviorActionView.getEAnnotation(LIFELINE_QUALIFIED_NAME);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(LIFELINE_QUALIFIED_NAME);
            callBehaviorActionView.getEAnnotations().add((Object)eAnnotation);
        }
        eAnnotation.getDetails().put((Object)qualifiedName, (Object)"");
    }

    public static boolean isBehaviorNew(View callBehaviorActionView) {
        return callBehaviorActionView.getEAnnotation(IS_BEHAVIOR_NEW) == null;
    }

    public static void setBehaviorAsNonNew(View callBehaviorActionView) {
        EAnnotation eAnnotation = callBehaviorActionView.getEAnnotation(IS_BEHAVIOR_NEW);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(IS_BEHAVIOR_NEW);
            callBehaviorActionView.getEAnnotations().add((Object)eAnnotation);
        }
    }

    public static void resetSnapshotEannotation(View callBehaviorActionView) {
        EAnnotation eAnnotationIsNew;
        EAnnotation eAnnotationLifelines;
        EAnnotation annotationDiagramUUID = callBehaviorActionView.getEAnnotation(CALL_BEHAVIOR_ACTION_ANNOTATION);
        if (annotationDiagramUUID != null) {
            EcoreUtil.delete((EObject)annotationDiagramUUID);
        }
        if ((eAnnotationLifelines = callBehaviorActionView.getEAnnotation(LIFELINE_QUALIFIED_NAME)) != null) {
            EcoreUtil.delete((EObject)eAnnotationLifelines);
        }
        if ((eAnnotationIsNew = callBehaviorActionView.getEAnnotation(IS_BEHAVIOR_NEW)) != null) {
            EcoreUtil.delete((EObject)eAnnotationIsNew);
        }
    }

    public static enum CallBehaviorActionType {
        use,
        snapshot;

    }
}

