/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.interactionoverview.migration;

import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;
import org.eclipse.papyrus.uml.diagram.activity.migration.ActivityReconciler_1_2_0;

public class InteractionOverviewReconciler_1_2_0
extends DiagramReconciler {
    public ICommand getReconcileCommand(Diagram diagram) {
        CompositeCommand cc = new CompositeCommand("Migrate diagram from 1.1.0 to 1.2.0");
        cc.add((IUndoableOperation)new DeleteObsoleteViewCommand(diagram));
        cc.add((IUndoableOperation)new ChangeVisualIDsCommand(diagram));
        return cc;
    }

    public static String getNewVisualID(String oldVisualID) {
        switch (oldVisualID) {
            case "1000": {
                return "Package_InteractionOverviewDiagram";
            }
            case "5000": {
                return "CallBehaviorAction_InteractionShape";
            }
            case "5005": {
                return "CallBehaviorAction_InteractionUseShape";
            }
        }
        return InteractionOverviewReconciler_1_2_0.defaultGetNewVisualID(oldVisualID);
    }

    private static String defaultGetNewVisualID(String oldVisualID) {
        return ActivityReconciler_1_2_0.getNewVisualID((String)oldVisualID);
    }

    protected class ChangeVisualIDsCommand
    extends AbstractCommand {
        protected final Diagram diagram;

        public ChangeVisualIDsCommand(Diagram diagram) {
            super("Change the diagram's visual ids from 1.1.0 to 1.2.0");
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            TreeIterator allContentIterator = this.diagram.eAllContents();
            while (allContentIterator.hasNext()) {
                EObject eObject = (EObject)allContentIterator.next();
                if (!(eObject instanceof View)) continue;
                View view = (View)eObject;
                view.setType(InteractionOverviewReconciler_1_2_0.getNewVisualID(view.getType()));
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }

    protected class DeleteObsoleteViewCommand
    extends AbstractCommand {
        protected final Diagram diagram;

        public DeleteObsoleteViewCommand(Diagram diagram) {
            super("Deleting obselete views in 1.1.0");
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            TreeIterator allContentIterator = this.diagram.eAllContents();
            HashSet<View> toDelete = new HashSet<View>();
            while (allContentIterator.hasNext()) {
                View view;
                EObject eObject = (EObject)allContentIterator.next();
                if (!(eObject instanceof View) || !(view = (View)eObject).getType().equals("5173")) continue;
                toDelete.add(view);
            }
            for (View v : toDelete) {
                View container = (View)v.eContainer();
                container.getPersistedChildren().remove((Object)v);
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

