/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.hyperlink;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.hyperlink.object.HyperLinkEditor;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.service.HyperlinkContributor;
import org.eclipse.papyrus.infra.services.viewersearch.impl.ViewerSearchService;
import org.eclipse.uml2.uml.Package;

public class NestingPackageHyperlinkContributor
implements HyperlinkContributor {
    public List<HyperLinkObject> getHyperlinks(Object fromElement) {
        ArrayList<HyperLinkObject> hyperlinks = new ArrayList<HyperLinkObject>();
        if (fromElement instanceof Package) {
            Package nestingPackage = ((Package)fromElement).getNestingPackage();
            ArrayList pages = new ArrayList();
            if (nestingPackage != null) {
                ViewerSearchService viewerSearchService;
                block14: {
                    viewerSearchService = null;
                    try {
                        viewerSearchService = (ViewerSearchService)ServiceUtilsForEObject.getInstance().getService(ViewerSearchService.class, (Object)((EObject)fromElement));
                    }
                    catch (ServiceException e) {
                        if (e instanceof ServiceNotFoundException) {
                            viewerSearchService = new ViewerSearchService();
                            try {
                                viewerSearchService.startService();
                                ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)fromElement).add(ViewerSearchService.class, 1, (IService)viewerSearchService);
                            }
                            catch (ServiceException e1) {
                                Activator.log.error((Throwable)e1);
                            }
                        }
                        if (!(e instanceof BadStateException)) break block14;
                        try {
                            ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)fromElement).startRegistry();
                            viewerSearchService = (ViewerSearchService)ServiceUtilsForEObject.getInstance().getService(ViewerSearchService.class, (Object)((EObject)fromElement));
                        }
                        catch (Exception e1) {
                            Activator.log.error((Throwable)e1);
                        }
                    }
                }
                if (viewerSearchService != null) {
                    List viewerSearchResults = viewerSearchService.getViewersInCurrentModel(null, (EObject)nestingPackage, true, false);
                    pages.addAll(viewerSearchResults);
                }
            }
            for (Object page : pages) {
                if (!(page instanceof Diagram) || !((Diagram)page).getType().equals("CompositeStructure")) continue;
                try {
                    EObject emfPageId;
                    Object pageId;
                    IPage activeSashPage = ((ISashWindowsContainer)ServiceUtilsForEObject.getInstance().getService(ISashWindowsContainer.class, (Object)((Package)fromElement))).getActiveSashWindowsPage();
                    Object activePage = null;
                    if (activeSashPage != null && (pageId = activeSashPage.getRawModel()) instanceof PageRef && (emfPageId = ((PageRef)pageId).getEmfPageIdentifier()) instanceof View) {
                        activePage = emfPageId;
                    }
                    if (activePage != null && activePage.equals(page)) continue;
                    HyperLinkEditor hyperlink = new HyperLinkEditor();
                    hyperlink.setObject(page);
                    hyperlinks.add((HyperLinkObject)hyperlink);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
        return hyperlinks;
    }
}

