/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.edit.policies;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.uml.diagram.composite.custom.helper.CollaborationUseLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.ICustomAppearance;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.CollaborationUse;

public class CollaborationUseLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    public void addAdditionalListeners() {
        super.addAdditionalListeners();
        CollaborationUse collaborationUse = this.getUMLElement();
        if (collaborationUse == null) {
            return;
        }
        if (collaborationUse.getType() != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)this.getUMLElement().getType(), (NotificationListener)this);
        }
    }

    public Collection<String> getDefaultDisplayValue() {
        return ICustomAppearance.DEFAULT_UML_PROPERTY;
    }

    public String getMaskLabel(String value) {
        return CollaborationUseLabelHelper.getInstance().getMaskLabel(value);
    }

    public Collection<String> getMaskLabels() {
        return CollaborationUseLabelHelper.getInstance().getMaskLabels();
    }

    public Map<String, String> getMasks() {
        return CollaborationUseLabelHelper.getInstance().getMasks();
    }

    public CollaborationUse getUMLElement() {
        return (CollaborationUse)super.getUMLElement();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        CollaborationUse collaborationUse = (CollaborationUse)this.hostSemanticElement;
        if (object == null || this.hostSemanticElement == null) {
            return;
        }
        if (object.equals(collaborationUse)) {
            this.notifyCollaborationUseChanged(collaborationUse, notification);
        } else if (object.equals(collaborationUse.getType())) {
            this.notifyCollaborationUseTypeChanged(collaborationUse.getType(), notification);
        }
        if (this.isMaskManagedAnnotation(object)) {
            this.refreshDisplay();
        }
        if (this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        }
    }

    protected void notifyCollaborationUseChanged(CollaborationUse collaborationUse, Notification notification) {
        switch (notification.getFeatureID(CollaborationUse.class)) {
            case 5: 
            case 9: {
                this.refreshDisplay();
                break;
            }
            case 11: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 5: {
                        if (notification.getNewValue() instanceof List) {
                            List addedElements = (List)notification.getNewValue();
                            for (Object addedElement : addedElements) {
                                if (!(addedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().addNotificationListener((EObject)addedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 4: {
                        this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        this.refreshDisplay();
                        break;
                    }
                    case 6: {
                        if (notification.getOldValue() instanceof List) {
                            List removedElements = (List)notification.getOldValue();
                            for (Object removedElement : removedElements) {
                                if (!(removedElement instanceof EObject)) continue;
                                this.getDiagramEventBroker().removeNotificationListener((EObject)removedElement, (NotificationListener)this);
                            }
                        }
                        this.refreshDisplay();
                        break;
                    }
                    case 1: {
                        if (notification.getNewValue() != null) {
                            this.getDiagramEventBroker().addNotificationListener((EObject)notification.getNewValue(), (NotificationListener)this);
                        }
                        if (notification.getOldValue() != null) {
                            this.getDiagramEventBroker().removeNotificationListener((EObject)notification.getOldValue(), (NotificationListener)this);
                        }
                        this.refreshDisplay();
                    }
                }
                break;
            }
        }
    }

    protected void notifyCollaborationUseTypeChanged(Collaboration type, Notification notification) {
        switch (notification.getFeatureID(CollaborationUse.class)) {
            case 5: {
                this.refreshDisplay();
                break;
            }
        }
    }

    public void refreshDisplay() {
        CollaborationUseLabelHelper.getInstance().refreshEditPartDisplay(this.getHost());
    }

    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        CollaborationUse collaborationUse = this.getUMLElement();
        if (collaborationUse == null) {
            return;
        }
        if (collaborationUse.getType() != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)collaborationUse.getType(), (NotificationListener)this);
        }
    }
}

