/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.custom.edit.command;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public class CreateBehaviorPortCommand
extends RecordingCommand {
    protected View owner = null;
    protected View portView;
    protected Rectangle position = null;

    public CreateBehaviorPortCommand(TransactionalEditingDomain domain, View owner, View portView, Rectangle position) {
        super(domain, "Create Behavior Port");
        this.owner = owner;
        this.portView = portView;
        this.position = position;
    }

    protected void doExecute() {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setVisible(true);
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        bounds.setX(this.position.x);
        bounds.setY(this.position.y);
        bounds.setWidth(30);
        bounds.setHeight(15);
        node.setLayoutConstraint((LayoutConstraint)bounds);
        TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
        ts.setShowTitle(true);
        node.getStyles().add((Object)ts);
        node.setType("Port_BehaviorShape");
        node.setElement(this.portView.getElement());
        ViewUtil.insertChildView((View)this.owner, (View)node, (int)-1, (boolean)true);
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)this.owner.getDiagram(), (View)edge, (int)-1, (boolean)true);
        edge.setType("Port_BehaviorEdge");
        IdentityAnchor anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        edge.setSourceAnchor((Anchor)anchor);
        anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        edge.setTargetAnchor((Anchor)anchor);
        edge.setSource(this.portView);
        edge.setTarget((View)node);
        edge.setElement(this.portView.getElement());
    }
}

