/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.helper.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.UMLPackage;

public class EnumerationHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeSetCommand(SetRequest request) {
        ICommand moveCommand = super.getBeforeSetCommand(request);
        EObject elementToEdit = request.getElementToEdit();
        if (elementToEdit != null && elementToEdit instanceof Enumeration) {
            EList ownedLiterals;
            List<EObject> elementsToMove;
            Object value;
            EStructuralFeature feature = request.getFeature();
            if (UMLPackage.eINSTANCE.getEnumeration_OwnedLiteral().equals(feature) && (value = request.getValue()) instanceof ArrayList && (elementsToMove = this.substractLists(new ArrayList<EObject>((Collection<EObject>)(ownedLiterals = ((Enumeration)elementToEdit).getOwnedLiterals())), (ArrayList)value)) != null) {
                HashSet<View> viewsToDestroy = new HashSet<View>();
                for (EObject eObject : elementsToMove) {
                    viewsToDestroy.addAll(this.getMemberViewsToDestroy(eObject));
                }
                for (View view : viewsToDestroy) {
                    DeleteCommand destroyViewsCommand = new DeleteCommand(request.getEditingDomain(), view);
                    moveCommand = CompositeCommand.compose((ICommand)moveCommand, (ICommand)destroyViewsCommand);
                }
            }
        }
        return moveCommand;
    }

    protected ICommand getAfterMoveCommand(MoveRequest request) {
        ICommand moveCommand = super.getAfterMoveCommand(request);
        HashSet<View> viewsToDestroy = new HashSet<View>();
        Object parameter = request.getParameter("TYPE_MOVING");
        if (parameter == null || !"TYPE_MOVING_DIAGRAM".equals(parameter)) {
            for (EObject eObject : request.getElementsToMove().keySet()) {
                viewsToDestroy.addAll(this.getMemberViewsToDestroy(eObject));
            }
            for (View view : viewsToDestroy) {
                DeleteCommand destroyViewsCommand = new DeleteCommand(request.getEditingDomain(), view);
                moveCommand = CompositeCommand.compose((ICommand)moveCommand, (ICommand)destroyViewsCommand);
            }
        }
        return moveCommand;
    }

    protected Set<View> getMemberViewsToDestroy(EObject object) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        for (View view : CrossReferencerUtil.getCrossReferencingViews((EObject)object, (String)"PapyrusUMLClassDiagram")) {
            String containerType;
            View viewContainer = ViewUtil.getViewContainer((EObject)view);
            String string = containerType = viewContainer != null ? viewContainer.getType() : null;
            if (containerType == null || "PapyrusUMLClassDiagram".equals(containerType)) continue;
            viewsToDestroy.add(view);
        }
        return viewsToDestroy;
    }

    protected List<EObject> substractLists(List<EObject> listOne, List<EObject> listTwo) {
        ArrayList<EObject> sourceList = new ArrayList<EObject>(listOne);
        ArrayList<EObject> destinationList = new ArrayList<EObject>(listTwo);
        sourceList.removeAll(listTwo);
        destinationList.removeAll(listOne);
        if (!sourceList.isEmpty()) {
            return sourceList;
        }
        if (!destinationList.isEmpty()) {
            return destinationList;
        }
        return null;
    }
}

