/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui;

import java.util.Hashtable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.services.spi.IContextualServiceRegistryTracker;
import org.eclipse.papyrus.infra.tools.spi.IExecutorServiceFactory;
import org.eclipse.papyrus.infra.tools.spi.INotificationBuilderFactory;
import org.eclipse.papyrus.infra.ui.api.services.IStatusService;
import org.eclipse.papyrus.infra.ui.editor.PapyrusEditorPropertySheetPageViewProvider;
import org.eclipse.papyrus.infra.ui.internal.services.status.StatusService;
import org.eclipse.papyrus.infra.ui.util.UIUtil;
import org.eclipse.papyrus.infra.ui.util.WorkbenchPartHelper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.views.properties.services.IPropertySheetPageProvider;
import org.eclipse.papyrus.views.properties.services.IPropertySheetPageProviderService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.ui";
    private static Activator plugin;
    public static LogHelper log;
    private ServiceRegistration<IExecutorServiceFactory> executorFactoryReg;
    private ServiceRegistration<IContextualServiceRegistryTracker> serviceRegistryTrackerReg;
    private ServiceRegistration<INotificationBuilderFactory> notificationBuilderReg;

    public void start(BundleContext context) throws Exception {
        IPropertySheetPageProviderService provider;
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)this);
        BundleContext bc = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference servreg = bc.getServiceReference(IPropertySheetPageProviderService.class);
        if (servreg != null && (provider = (IPropertySheetPageProviderService)bc.getService(servreg)) != null) {
            provider.registerPropertySheetPageProvider((IPropertySheetPageProvider)new PapyrusEditorPropertySheetPageViewProvider());
        }
        IExecutorServiceFactory executorFactory = () -> UIUtil.createUIExecutor(Display.getDefault());
        this.executorFactoryReg = context.registerService(IExecutorServiceFactory.class, (Object)executorFactory, null);
        IContextualServiceRegistryTracker serviceRegistryTracker = () -> {
            ServicesRegistry result = null;
            IEditorPart editor = WorkbenchPartHelper.getCurrentActiveEditorPart();
            if (editor != null) {
                result = (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
            }
            return result;
        };
        this.serviceRegistryTrackerReg = context.registerService(IContextualServiceRegistryTracker.class, (Object)serviceRegistryTracker, null);
        this.notificationBuilderReg = context.registerService(INotificationBuilderFactory.class, NotificationBuilder::new, null);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("description", "This service is used to display loading status.");
        context.registerService(IStatusService.class, (Object)new StatusService(), props);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.notificationBuilderReg != null) {
            this.notificationBuilderReg.unregister();
            this.notificationBuilderReg = null;
        }
        if (this.serviceRegistryTrackerReg != null) {
            this.serviceRegistryTrackerReg.unregister();
            this.serviceRegistryTrackerReg = null;
        }
        if (this.executorFactoryReg != null) {
            this.executorFactoryReg.unregister();
            this.executorFactoryReg = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

