/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.widgets;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.providers.XWTCompliantMaskProvider;
import org.eclipse.papyrus.infra.properties.ui.providers.XWTCompliantMaskProviderListener;
import org.eclipse.papyrus.infra.properties.ui.providers.XWTCompliantMaskProviderUpdater;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.swt.widgets.Composite;

public class StringMask
extends AbstractPropertyEditor
implements XWTCompliantMaskProviderListener {
    private org.eclipse.papyrus.infra.widgets.editors.StringMask editor;
    private XWTCompliantMaskProvider maskProvider;
    private boolean maskProviderReady = false;
    private IChangeListener changeListener;

    public StringMask(Composite parent, int style) {
        this.editor = this.createStringMask(parent, style);
        this.setEditor((AbstractListEditor)this.editor);
    }

    protected org.eclipse.papyrus.infra.widgets.editors.StringMask createStringMask(Composite parent, int style) {
        return new org.eclipse.papyrus.infra.widgets.editors.StringMask(parent, style);
    }

    @Override
    protected void checkInput() {
        if (this.maskProvider != null && this.maskProviderReady) {
            super.checkInput();
        }
    }

    public int getNumColumns() {
        return this.editor.getNumColumns();
    }

    public void setNumColumns(int numColumns) {
        this.editor.setNumColumns(numColumns);
    }

    public void setMaskProvider(XWTCompliantMaskProvider provider) {
        if (this.maskProvider != null) {
            this.maskProvider.removeMaskProviderListener(this);
        }
        this.maskProviderReady = false;
        this.maskProvider = provider;
        provider.addMaskProviderListener(this);
        this.checkInput();
    }

    public XWTCompliantMaskProvider getMaskProvider() {
        return this.maskProvider;
    }

    @Override
    public void notifyReady(XWTCompliantMaskProvider provider) {
        this.maskProviderReady = true;
        this.editor.setMasks(this.maskProvider.getMasks());
        provider.removeMaskProviderListener(this);
        this.checkInput();
    }

    @Override
    public void setInput(DataSource input) {
        DataSource oldInput = this.input;
        super.setInput(input);
        if (input != oldInput) {
            if (oldInput != null) {
                oldInput.removeChangeListener(this.getChangeListener());
            }
            if (input != null) {
                input.addChangeListener(this.getChangeListener());
            }
        }
    }

    protected IChangeListener getChangeListener() {
        if (this.changeListener == null) {
            this.changeListener = new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    if (StringMask.this.maskProvider != null) {
                        if (StringMask.this.maskProvider instanceof XWTCompliantMaskProviderUpdater) {
                            ((XWTCompliantMaskProviderUpdater)((Object)StringMask.this.maskProvider)).setInput(StringMask.this.getInput());
                        }
                        if (StringMask.this.editor != null) {
                            StringMask.this.editor.setMasks(StringMask.this.maskProvider.getMasks());
                        }
                    }
                }
            };
        }
        return this.changeListener;
    }
}

