/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter.configuration;

import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.filter.PapyrusTextMatchingMode;
import org.eclipse.papyrus.infra.nattable.filter.StringMatcherEditorFactory;
import org.eclipse.papyrus.infra.nattable.filter.configuration.AbstractFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.filter.configuration.AbstractFilterValueToMatchManager;
import org.eclipse.papyrus.infra.nattable.filter.configuration.IFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.filter.validator.StringFilterDataValidator;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringValueStyle;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class TextEditorFilterConfiguration
extends AbstractFilterConfiguration
implements IFilterConfiguration {
    private static final String ID = "org.eclipse.papyrus.infra.nattable.string.filter.configuration";
    public static final String DESCRIPTION = NLS.bind((String)"This editor allows to edit string value. It is used to do a string comparison when there is no other editor declared to manage filter. By default, this editor tests if the string is contains by the cells, but it allows to filter with others strategy doing starting the text in the fiter cell by {0}, {1}, {2}, {3}, {4}: ", (Object[])new Object[]{PapyrusTextMatchingMode.EXACT, PapyrusTextMatchingMode.NUM, PapyrusTextMatchingMode.REGEX_FIND, PapyrusTextMatchingMode.REGEX_MATCH, PapyrusTextMatchingMode.START});

    @Override
    public void configureFilter(IConfigRegistry configRegistry, Object columnElement, String configLabel) {
        TextCellEditor editor = new TextCellEditor();
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)editor, "NORMAL", configLabel);
        StringMatcherEditorFactory creator = new StringMatcherEditorFactory();
        configRegistry.registerConfigAttribute(NattableConfigAttributes.MATCHER_EDITOR_FACTORY, creator, "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)this.getDataValidator(configRegistry), "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(NattableConfigAttributes.STRING_FILTER_MATCHING_MODE, (Object)this.getFilterMatchingMode(), "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(NattableConfigAttributes.FILTER_VALUE_TO_MATCH_MANAGER, (Object)new TextFilterValueToMatchManager(this.getConfigurationId()), "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, (Object)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (TypeUtils.isNumericValue((Object)o2) && !TypeUtils.isNumericValue((Object)o1)) {
                    return Integer.MIN_VALUE;
                }
                return DefaultComparator.getInstance().compare(o1, o2);
            }
        }, "NORMAL", configLabel);
    }

    protected PapyrusTextMatchingMode getFilterMatchingMode() {
        return PapyrusTextMatchingMode.CONTAINS;
    }

    protected IDataValidator getDataValidator(IConfigRegistry configRegistry) {
        return new StringFilterDataValidator();
    }

    @Override
    public boolean handles(IConfigRegistry registry, Object columnElement) {
        return columnElement != null;
    }

    @Override
    public String getConfigurationId() {
        return ID;
    }

    @Override
    public String getConfigurationDescription() {
        return DESCRIPTION;
    }

    private class TextFilterValueToMatchManager
    extends AbstractFilterValueToMatchManager {
        public TextFilterValueToMatchManager(String filterEditorId) {
            super(filterEditorId);
        }

        @Override
        protected Command getSaveValueToMatchCommand(TransactionalEditingDomain domain, IConfigRegistry configRegistry, Object axis, Object newValue) {
            if (!(axis instanceof IAxis) || newValue == null) {
                return null;
            }
            Assert.isTrue((boolean)(newValue instanceof String));
            String str = (String)newValue;
            IAxis iaxis = (IAxis)axis;
            StringValueStyle style = (StringValueStyle)this.getValueToMatchStyle(iaxis);
            if (style != null) {
                return SetCommand.create((EditingDomain)domain, (Object)style, (Object)NattablestylePackage.eINSTANCE.getStringValueStyle_StringValue(), (Object)str);
            }
            style = NattablestyleFactory.eINSTANCE.createStringValueStyle();
            style.setName("filterValueToMatch");
            style.setStringValue(str);
            return AddCommand.create((EditingDomain)domain, (Object)iaxis, (Object)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)style);
        }

        @Override
        public Object getValueToMatch(IConfigRegistry configRegistry, Object axis) {
            if (!(axis instanceof IAxis)) {
                return null;
            }
            IAxis iaxis = (IAxis)axis;
            StringValueStyle style = (StringValueStyle)this.getValueToMatchStyle(iaxis);
            if (style != null) {
                return style.getStringValue();
            }
            return null;
        }
    }
}

