/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.configuration;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.grid.layer.config.DefaultGridLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.grid.layer.config.DefaultRowStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.papyrus.infra.nattable.applynamedstyle.PapyrusApplyNamedStyleBindings;
import org.eclipse.papyrus.infra.nattable.configuration.EditConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.PapyrusAlternateRowConfigLabelAccumulatorForRegion;
import org.eclipse.papyrus.infra.nattable.configuration.PapyrusDefaultEditBindings;
import org.eclipse.papyrus.infra.nattable.export.PapyrusExportBindings;
import org.eclipse.papyrus.infra.nattable.export.file.PapyrusFileExportBindings;
import org.eclipse.papyrus.infra.nattable.internal.export.image.PapyrusImageExportBindings;

public class PapyrusGridLayerConfiguration
extends DefaultGridLayerConfiguration {
    private PapyrusAlternateRowConfigLabelAccumulatorForRegion alternateRowConfiguration;

    public PapyrusGridLayerConfiguration(CompositeLayer gridLayer) {
        super(gridLayer);
        this.addFileExportUIBindings();
        this.addImageExportUIBindings();
        this.addApplyNamedStyleBindings();
    }

    protected void addEditingHandlerConfig() {
        this.addConfiguration((IConfiguration)new EditConfiguration());
    }

    protected void addEditingUIConfig() {
        this.addConfiguration((IConfiguration)new PapyrusDefaultEditBindings());
    }

    protected void addExcelExportUIBindings() {
        this.addConfiguration((IConfiguration)new PapyrusExportBindings());
    }

    protected void addFileExportUIBindings() {
        this.addConfiguration((IConfiguration)new PapyrusFileExportBindings());
    }

    protected void addImageExportUIBindings() {
        this.addConfiguration((IConfiguration)new PapyrusImageExportBindings());
    }

    protected void addApplyNamedStyleBindings() {
        this.addConfiguration(new PapyrusApplyNamedStyleBindings());
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        if (this.alternateRowConfiguration != null) {
            this.alternateRowConfiguration.setConfigRegistry(configRegistry);
        }
        super.configureRegistry(configRegistry);
    }

    protected void addAlternateRowColoringConfig(CompositeLayer layer) {
        this.addConfiguration((IConfiguration)new DefaultRowStyleConfiguration());
        this.alternateRowConfiguration = new PapyrusAlternateRowConfigLabelAccumulatorForRegion(layer.getChildLayerByRegionName("BODY"));
        layer.setConfigLabelAccumulatorForRegion("BODY", (IConfigLabelAccumulator)this.alternateRowConfiguration);
    }
}

