/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.properties.observable;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractConfigurationElementObservableValue
extends AbstractObservableValue
implements Listener {
    private Table table;
    private EStructuralFeature managedFeature;
    protected Object oldValue;

    public AbstractConfigurationElementObservableValue(Table table, EStructuralFeature managedFeature) {
        this.table = table;
        this.managedFeature = managedFeature;
        this.oldValue = this.doGetValue();
    }

    protected Object doGetValue() {
        EObject editedObject = this.getEditedEObject();
        if (editedObject != null) {
            return editedObject.eGet(this.getManagedFeature());
        }
        return null;
    }

    public EStructuralFeature getManagedFeature() {
        return this.managedFeature;
    }

    protected abstract EObject getEditedEObject();

    public void handleEvent(Event event) {
        final Object newValue = this.doGetValue();
        if (newValue != this.oldValue && (newValue != null && this.oldValue == null || newValue == null && this.oldValue != null || this.oldValue != null && !this.oldValue.equals(newValue))) {
            final Object localOldValue = this.oldValue;
            this.oldValue = newValue;
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return localOldValue;
                }

                public Object getNewValue() {
                    return newValue;
                }
            });
        }
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }
}

