/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.common.command;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;

public class LocaleInternationalizationPreferenceCommand
extends AbstractCommand {
    protected URI resourceURI;
    protected String newLanguageValue;
    protected String oldLanguageValue;

    public LocaleInternationalizationPreferenceCommand(URI resourceURI, String newLanguageValue) {
        super("Modify locale internationalization preference");
        this.resourceURI = resourceURI;
        this.newLanguageValue = newLanguageValue;
    }

    public void execute() {
        this.oldLanguageValue = InternationalizationPreferencesUtils.getLocalePreference(this.resourceURI).toString();
        InternationalizationPreferencesUtils.setLanguagePreference(this.resourceURI, this.newLanguageValue);
    }

    public void undo() {
        InternationalizationPreferencesUtils.setLanguagePreference(this.resourceURI, this.oldLanguageValue);
    }

    public void redo() {
        InternationalizationPreferencesUtils.setLanguagePreference(this.resourceURI, this.newLanguageValue);
    }

    protected boolean prepare() {
        return this.resourceURI != null;
    }
}

