/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.widgets.editors;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorPalettePopup;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.RGBColor;

public class StringColorPickerEditor
extends AbstractValueEditor
implements IChangeListener {
    protected Button colorPicker = new Button((Composite)this, 8);
    protected ColorPalettePopup colorPickerPopup;
    protected RGB color;
    protected Rectangle colorBounds;
    protected Image backgroundImage;
    protected String defaultColor = "-1";
    public static final Rectangle defaultColorBoundsWithoutImage = new Rectangle(0, 0, 15, 15);
    public static final Rectangle defaultColorBoundsWithImage = new Rectangle(0, 12, 16, 4);

    public StringColorPickerEditor(Composite parent, int style) {
        super(parent, style);
        this.doSetColor("0");
        this.colorPicker.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColorPalettePopup colorPickerPopup = new ColorPalettePopup(StringColorPickerEditor.this.getShell(), 25);
                colorPickerPopup.setPreviousColor(Integer.valueOf(StringColorPickerEditor.this.getValue()).intValue());
                Rectangle r = StringColorPickerEditor.this.colorPicker.getBounds();
                Point location = StringColorPickerEditor.this.colorPicker.getParent().toDisplay(r.x, r.y);
                colorPickerPopup.open(new Point(location.x, location.y + r.height));
                if (colorPickerPopup.getSelectedColor() != null || colorPickerPopup.useDefaultColor()) {
                    StringColorPickerEditor.this.setColor(colorPickerPopup.getSelectedColor());
                    StringColorPickerEditor.this.commit();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public StringColorPickerEditor(Composite parent, int style, String defaultColor) {
        this(parent, style);
        this.defaultColor = defaultColor;
        this.doSetColor(defaultColor);
    }

    protected void doBinding() {
        if (this.modelProperty != null) {
            this.getParent().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    StringColorPickerEditor.this.dispose();
                }
            });
            this.modelProperty.addChangeListener((IChangeListener)this);
            this.handleChange(null);
        }
    }

    public void dispose() {
        if (this.modelProperty != null) {
            this.modelProperty.removeChangeListener((IChangeListener)this);
        }
        super.dispose();
    }

    private void setColor(RGB color) {
        String colorValue = color == null ? this.defaultColor : String.valueOf(FigureUtilities.RGBToInteger((RGB)color));
        this.doSetColor(colorValue);
        if (this.modelProperty != null) {
            this.modelProperty.setValue((Object)colorValue);
        }
    }

    private void doSetColor(String color) {
        this.color = this.StringToRGB(color);
        this.updateButton();
    }

    RGB StringToRGB(String color) {
        RGB rgb = null;
        if (color != null && !"-1".equals(color)) {
            RGBColor rgbColor = CSS2ColorHelper.getRGBColor((String)color);
            if (rgbColor != null) {
                int red = Integer.parseInt(rgbColor.getRed().toString());
                int green = Integer.parseInt(rgbColor.getGreen().toString());
                int blue = Integer.parseInt(rgbColor.getBlue().toString());
                rgb = new RGB(red, green, blue);
            } else {
                try {
                    rgb = FigureUtilities.integerToRGB((Integer)Integer.valueOf(color));
                }
                catch (NumberFormatException e) {
                    rgb = new RGB(0, 0, 0);
                }
            }
        } else {
            rgb = new RGB(0, 0, 0);
        }
        return rgb;
    }

    private void updateButton() {
        Image image = this.colorPicker.getImage();
        if (image != null) {
            image.dispose();
        }
        Display display = this.colorPicker.getDisplay();
        Color color = new Color((Device)display, this.color);
        image = this.backgroundImage == null ? new Image((Device)display, 16, 16) : new Image((Device)display, this.backgroundImage.getBounds());
        GC gc = new GC((Drawable)image);
        gc.fillRectangle(image.getBounds());
        gc.setBackground(this.colorPicker.getBackground());
        gc.fillRectangle(image.getBounds());
        gc.setBackground(color);
        gc.setForeground(color);
        if (this.backgroundImage != null) {
            gc.fillRectangle(defaultColorBoundsWithImage);
            gc.drawImage(this.backgroundImage, 0, 0);
        } else {
            gc.fillRectangle(defaultColorBoundsWithoutImage);
            gc.setForeground(display.getSystemColor(2));
            gc.drawRectangle(defaultColorBoundsWithoutImage);
        }
        gc.dispose();
        color.dispose();
        this.colorPicker.setImage(image);
    }

    public void setImage(Image image) {
        this.backgroundImage = image;
    }

    public void setColorBounds(Rectangle rectangle) {
        this.colorBounds = rectangle;
    }

    public String getValue() {
        if (this.color == null) {
            return this.defaultColor;
        }
        return String.valueOf(FigureUtilities.RGBToInteger((RGB)this.color));
    }

    public Object getEditableType() {
        return Integer.class;
    }

    public void setReadOnly(boolean readOnly) {
        this.colorPicker.setEnabled(!readOnly);
    }

    public boolean isReadOnly() {
        return !this.colorPicker.isEnabled();
    }

    public void setToolTipText(String text) {
        this.setLabelToolTipText(text);
    }

    public void handleChange(ChangeEvent event) {
        if (this.modelProperty != null) {
            String value = (String)this.modelProperty.getValue();
            if (value == null) {
                value = "-1";
            }
            this.doSetColor(value);
        }
    }

    public void refreshValue() {
        this.handleChange(null);
    }

    public void setDefaultColor(String color) {
        this.defaultColor = color;
    }
}

