/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.draw2d;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class CenterLayout
extends StackLayout {
    private static final Rectangle RECTANGLE = new Rectangle();
    private boolean myLayoutAgainstGrandParent;

    public void layout(IFigure parent) {
        Rectangle r = this.findFigureToCenter(parent).getClientArea();
        int centerX = r.x + r.width / 2;
        int centerY = r.y + r.height / 2;
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension prefSize = child.getPreferredSize(r.width, r.height);
            CenterLayout.RECTANGLE.x = centerX - prefSize.width / 2;
            CenterLayout.RECTANGLE.y = centerY - prefSize.height / 2;
            CenterLayout.RECTANGLE.width = prefSize.width;
            CenterLayout.RECTANGLE.height = prefSize.height;
            child.setBounds(RECTANGLE);
            ++i;
        }
    }

    protected IFigure findFigureToCenter(IFigure parent) {
        return this.myLayoutAgainstGrandParent && parent.getParent() != null ? parent.getParent() : parent;
    }

    public void setLayoutAgainstGrandParent(boolean layoutAgainstGrandParent) {
        this.myLayoutAgainstGrandParent = true;
    }
}

