/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.dnd.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.dnd.Activator;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.AbstractRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.Representation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.ChildrenListRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.DiagramExpansionSingleton;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.DiagramExpansionsRegistry;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.swt.graphics.Image;

public class ExpansionElementDropStrategy
extends TransactionalDropStrategy {
    private DiagramExpansionsRegistry diagramExpansionRegistry = DiagramExpansionSingleton.getInstance().getDiagramExpansionRegistry();

    @Override
    public String getLabel() {
        return "Expansion element drag and drop";
    }

    @Override
    public String getID() {
        return "org.eclipse.papyrus.infra.gmfdiag.dnd.expansiondropsteategy";
    }

    @Override
    public String getDescription() {
        return "This strategy is used to allow dropping of expansion of elements in extended diagrams.";
    }

    public String getCategoryID() {
        return "org.eclipse.papyrus.infra.gmfdiag.dnd.expansiondropsteategy";
    }

    public String getCategoryLabel() {
        return "Expansion element drag and drop";
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public void setOptions(Map<String, Object> options) {
    }

    protected String getDiagramType(View currentView) {
        Diagram diagram = currentView.getDiagram();
        String currentDiagramType = null;
        ViewPrototype viewPrototype = DiagramUtils.getPrototype((Diagram)diagram);
        currentDiagramType = viewPrototype != null ? viewPrototype.getLabel() : diagram.getType();
        return currentDiagramType;
    }

    @Override
    public Command doGetCommand(Request request, EditPart targetEditPart) {
        if ("move children".equals(request.getType())) {
            return null;
        }
        CompositeCommand cc = new CompositeCommand(this.getLabel());
        if (targetEditPart instanceof GraphicalEditPart) {
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)targetEditPart;
            String diagramType = this.getDiagramType(graphicalEditPart.getNotationView());
            ChildrenListRepresentation listRepresentation = (ChildrenListRepresentation)this.diagramExpansionRegistry.mapChildreen.get(diagramType);
            if (listRepresentation == null) {
                return null;
            }
            List childrenList = null;
            childrenList = graphicalEditPart instanceof DiagramEditPart ? (List)listRepresentation.parentChildrenRelation.get(diagramType) : (List)listRepresentation.parentChildrenRelation.get(graphicalEditPart.getNotationView().getType());
            if (childrenList == null) {
                return null;
            }
            List<EObject> sourceElements = this.getSourceEObjects(request);
            if (sourceElements.isEmpty()) {
                return null;
            }
            ArrayList<EObject> valuesToAdd = new ArrayList<EObject>(sourceElements.size());
            ArrayList<ISpecializationType> acceptedElementTypes = new ArrayList<ISpecializationType>();
            for (String posibleID : childrenList) {
                IElementType elementType;
                String elementTypeID;
                ElementTypeConfiguration graphicalElementTypeRef;
                AbstractRepresentation abstractRepresentation = (AbstractRepresentation)listRepresentation.IDMap.get(posibleID);
                if (!(abstractRepresentation instanceof Representation) || (graphicalElementTypeRef = ((Representation)abstractRepresentation).getGraphicalElementTypeRef()) == null || (elementTypeID = graphicalElementTypeRef.getIdentifier()) == null || elementTypeID.isEmpty() || !((elementType = ElementTypeRegistry.getInstance().getType(elementTypeID)) instanceof ISpecializationType)) continue;
                acceptedElementTypes.add((ISpecializationType)elementType);
            }
            Activator.log.trace("org.eclipse.papyrus.infra.gmfdiag.common/debug/expansion", "try to drop " + String.valueOf(sourceElements) + " inside " + graphicalEditPart.getNotationView().getType() + " accepts " + String.valueOf(childrenList));
            for (EObject sourceElement : sourceElements) {
                if (sourceElement.eContainer() != graphicalEditPart.resolveSemanticElement()) continue;
                Command cmd = null;
                int acceptedElementTypesIndex = 0;
                while (cmd == null && acceptedElementTypesIndex < acceptedElementTypes.size()) {
                    ISpecializationType iSpecializationType = (ISpecializationType)acceptedElementTypes.get(acceptedElementTypesIndex);
                    IElementMatcher matcher = iSpecializationType.getMatcher();
                    IElementType[] superElementTypes = iSpecializationType.getSpecializedTypes();
                    if (matcher == null) {
                        int index = superElementTypes.length - 1;
                        while (matcher == null && index > 0) {
                            if (superElementTypes[index] instanceof ISpecializationType) {
                                matcher = ((ISpecializationType)superElementTypes[index]).getMatcher();
                            }
                            --index;
                        }
                    }
                    if (matcher != null && matcher.matches(sourceElement)) {
                        cmd = this.addCommandDrop(targetEditPart, cc, valuesToAdd, sourceElement, iSpecializationType);
                        continue;
                    }
                    if (matcher == null) {
                        EClass eclass = iSpecializationType.getEClass();
                        if (eclass.isSuperTypeOf(sourceElement.eClass())) {
                            cmd = this.addCommandDrop(targetEditPart, cc, valuesToAdd, sourceElement, iSpecializationType);
                            continue;
                        }
                        ++acceptedElementTypesIndex;
                        continue;
                    }
                    ++acceptedElementTypesIndex;
                }
            }
        }
        return cc.canExecute() ? new ICommandProxy(cc.reduce()) : null;
    }

    protected Command addCommandDrop(final EditPart targetEditPart, CompositeCommand cc, List<EObject> valuesToAdd, final EObject sourceElement, final ISpecializationType iSpecializationType) {
        valuesToAdd.add(sourceElement);
        Activator.log.trace("org.eclipse.papyrus.infra.gmfdiag.common/debug/expansion", "try to drop command created for " + String.valueOf(sourceElement) + " " + String.valueOf(iSpecializationType));
        Command cmd = new Command(){

            public void execute() {
                if (iSpecializationType instanceof IHintedType) {
                    ViewService.createNode((View)((GraphicalEditPart)targetEditPart).getNotationView(), (EObject)sourceElement, (String)((IHintedType)iSpecializationType).getSemanticHint(), (PreferencesHint)((GraphicalEditPart)targetEditPart).getDiagramPreferencesHint());
                }
            }
        };
        cc.add((IUndoableOperation)new CommandProxy(cmd));
        return cmd;
    }
}

