/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.resource;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ModelCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ProjectCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.resource.CSSNotationModel;
import org.eclipse.papyrus.infra.gmfdiag.css.resource.CSSNotationResourceAdapter;

public class CSSNotationResource
extends GMFResource {
    private ExtendedCSSEngine modelEngine;
    private ExtendedCSSEngine projectEngine;
    private Adapter disposeListener;

    public CSSNotationResource(URI uri) {
        super(uri);
    }

    public ExtendedCSSEngine getModelEngine() {
        if (this.modelEngine == null) {
            this.modelEngine = new ModelCSSEngine((Resource)this);
            this.disposeListener = new ResourceDisposeListener();
            this.getResourceSet().eAdapters().add((Object)this.disposeListener);
        }
        return this.modelEngine;
    }

    public ExtendedCSSEngine getProjectEngine() {
        if (this.projectEngine == null) {
            this.projectEngine = ProjectCSSEngine.createEngine((Resource)this);
        }
        return this.projectEngine;
    }

    public static ExtendedCSSEngine getEngine(Resource resource) {
        ExtendedCSSEngine result = null;
        if (resource instanceof CSSNotationResource) {
            result = ((CSSNotationResource)resource).getModelEngine();
        } else if ("notation".equals(resource.getURI().fileExtension())) {
            ResourceSet resourceSet;
            CSSNotationResourceAdapter adapter = (CSSNotationResourceAdapter)EcoreUtil.getExistingAdapter((Notifier)resource, ExtendedCSSEngine.class);
            if (adapter == null && (resourceSet = resource.getResourceSet()) instanceof ModelSet && ((ModelSet)resourceSet).getModel("org.eclipse.papyrus.infra.core.resource.notation.NotationModel") instanceof CSSNotationModel) {
                adapter = new CSSNotationResourceAdapter();
                resource.eAdapters().add((Object)adapter);
            }
            if (adapter != null) {
                result = adapter.getEngine();
            }
        }
        return result;
    }

    public static boolean isCSSEnabled(Resource resource) {
        return resource != null && !((Resource.Internal)resource).isLoading() && CSSNotationResource.getEngine(resource) != null;
    }

    private void disposeEngine(Object notifier) {
        if (this.modelEngine != null) {
            this.modelEngine.dispose();
            this.modelEngine = null;
            ((ResourceSet)notifier).eAdapters().remove((Object)this.disposeListener);
        }
        if (this.projectEngine != null) {
            this.projectEngine.dispose();
            this.projectEngine = null;
        }
    }

    private class ResourceDisposeListener
    extends AdapterImpl {
        private ResourceDisposeListener() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 6: {
                    for (Object oldValue : (Collection)notification.getOldValue()) {
                        if (oldValue != CSSNotationResource.this) continue;
                        CSSNotationResource.this.disposeEngine(notification.getNotifier());
                    }
                    break;
                }
                case 4: {
                    if (notification.getOldValue() != CSSNotationResource.this) break;
                    CSSNotationResource.this.disposeEngine(notification.getNotifier());
                }
            }
        }
    }
}

