/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.providers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.AbstractShapeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ProviderNotificationManager;
import org.w3c.dom.svg.SVGDocument;

public class StyleBasedShapeProvider
extends AbstractShapeProvider {
    protected static final String STYLE_PROPERTY = "svgFile";
    protected static final String IMAGE_PATH_PROPERTY = "imagePath";
    private ProviderNotificationManager manager;
    private List<SVGDocument> listEmptySVG = new ArrayList<SVGDocument>(0);
    private List<RenderedImage> listEmptyRendered = new ArrayList<RenderedImage>(0);
    private List<SVGDocument> listSingletonSVG = new ArrayList<SVGDocument>(1);
    private List<RenderedImage> listRenderedImages;

    public StyleBasedShapeProvider() {
        this.listSingletonSVG.add(null);
        this.listRenderedImages = new ArrayList<RenderedImage>();
    }

    @Override
    public List<RenderedImage> getShapes(EObject view) {
        if (!(view instanceof View)) {
            return this.listEmptyRendered;
        }
        View v = (View)view;
        if (!this.isShapeStyleEnable(v)) {
            return this.listEmptyRendered;
        }
        return this.doGetShapes(v);
    }

    protected List<RenderedImage> doGetShapes(View view) {
        block10: {
            String path;
            List<SVGDocument> documents;
            if (this.listRenderedImages != null) {
                this.listRenderedImages.clear();
            }
            if ((documents = this.getSVGDocument((EObject)view)) != null && !documents.isEmpty()) {
                for (SVGDocument document : documents) {
                    if (document == null) continue;
                    try {
                        RenderedImage renderSVGDocument = this.renderSVGDocument((EObject)view, document);
                        if (renderSVGDocument == null) continue;
                        this.listRenderedImages.add(renderSVGDocument);
                    }
                    catch (IOException ex) {
                        Activator.log.error((Throwable)ex);
                    }
                }
            }
            if ((path = NotationUtils.getStringValue(view, IMAGE_PATH_PROPERTY, null)) != null && path.length() > 0) {
                URL url;
                try {
                    url = new URL(path);
                    this.listRenderedImages.add(RenderedImageFactory.getInstance((URL)url));
                }
                catch (MalformedURLException e) {
                    URI typeResourceURI = view.eResource().getURI();
                    if (typeResourceURI == null) break block10;
                    String workspaceRelativeFolderPath = typeResourceURI.trimSegments(1).toPlatformString(true);
                    try {
                        url = new URL("platform:/resource/" + workspaceRelativeFolderPath + File.separatorChar + path);
                        this.listRenderedImages.add(RenderedImageFactory.getInstance((URL)url));
                    }
                    catch (MalformedURLException e1) {
                        Activator.log.error((Throwable)e1);
                    }
                }
            }
        }
        return this.listRenderedImages;
    }

    @Override
    public List<RenderedImage> getShapesForDecoration(EObject view) {
        if (!(view instanceof View)) {
            return this.listEmptyRendered;
        }
        View v = (View)view;
        if (!this.isShapeDecorationStyleEnable(v)) {
            return this.listEmptyRendered;
        }
        return this.doGetShapesForDecoration(v);
    }

    protected List<RenderedImage> doGetShapesForDecoration(View view) {
        return this.doGetShapes(view);
    }

    @Override
    public List<SVGDocument> getSVGDocument(EObject view) {
        if (!(view instanceof View)) {
            return this.listEmptySVG;
        }
        View v = (View)view;
        if (!this.isShapeStyleEnable(v)) {
            return this.listEmptySVG;
        }
        String svgFile = this.extract((StringValueStyle)v.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), STYLE_PROPERTY));
        if (svgFile == null) {
            return this.listEmptySVG;
        }
        SVGDocument svg = this.getSVGDocument(view, svgFile);
        this.listSingletonSVG.set(0, svg);
        return this.listSingletonSVG;
    }

    @Override
    public boolean providesShapes(EObject view) {
        if (!(view instanceof View)) {
            return false;
        }
        View v = (View)view;
        if (!this.isShapeStyleEnable(v)) {
            return false;
        }
        String svgFile = this.extract((StringValueStyle)v.getNamedStyle(NotationPackage.eINSTANCE.getStringValueStyle(), STYLE_PROPERTY));
        String imagePath = NotationUtils.getStringValue(v, IMAGE_PATH_PROPERTY, null);
        return svgFile != null || imagePath != null;
    }

    private boolean isShapeStyleEnable(View view) {
        return NotationUtils.getBooleanValue(view, "shapeStyle", true);
    }

    private boolean isShapeDecorationStyleEnable(View view) {
        return NotationUtils.getBooleanValue(view, "shapeDecorationStyle", true);
    }

    private String extract(StringValueStyle style) {
        if (style == null || style.getStringValue() == null || style.getStringValue().isEmpty()) {
            return null;
        }
        return style.getStringValue();
    }

    @Override
    public ProviderNotificationManager createProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener notificationListener) {
        if (this.manager != null) {
            return this.manager;
        }
        this.manager = new ProviderNotificationManager(diagramEventBroker, view, notificationListener){

            @Override
            protected void registerListeners() {
            }
        };
        return this.manager;
    }
}

