/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomDoubleStyleWithStoreObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomIntStyleWithStoreObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.UnitsConverterUtils;

public class RulersUnitStyleObservableValue
extends CustomIntStyleWithStoreObservableValue {
    public RulersUnitStyleObservableValue(View source, EditingDomain domain, IPreferenceStore preferenceStore) {
        super(source, domain, "rulergrid.rulerunit", preferenceStore);
    }

    @Override
    protected void doSetValue(Object value) {
        if (value instanceof Integer) {
            Integer oldValue = (Integer)this.doGetValue();
            Double oldGridSpacing = this.preferenceStore.getDouble("rulergrid.gridspacing");
            String newValue = UnitsConverterUtils.convertUnits(oldValue, (Integer)value, NumberFormat.getInstance().format(oldGridSpacing));
            Number number = null;
            try {
                number = NumberFormat.getInstance().parse(newValue);
            }
            catch (ParseException e) {
                Activator.log.error((Throwable)e);
                number = null;
                return;
            }
            CustomDoubleStyleWithStoreObservableValue observable = new CustomDoubleStyleWithStoreObservableValue(this.source, this.domain, "rulergrid.gridspacing", this.preferenceStore);
            double newGridSpacing = number.doubleValue();
            observable.setValue(newGridSpacing);
        }
        super.doSetValue(value);
    }
}

