/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.internal.operations;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ElementTypeFilter;
import org.eclipse.papyrus.infra.gmfdiag.assistant.ModelingAssistantProvider;
import org.eclipse.papyrus.infra.gmfdiag.assistant.core.util.ModelingAssistantUtil;

public class ElementTypeFilterOperations {
    protected ElementTypeFilterOperations() {
    }

    public static boolean matches(ElementTypeFilter elementTypeFilter, Object input) {
        boolean result = false;
        IElementType type = elementTypeFilter.getElementType();
        if (type != null) {
            IElementType[] types = ModelingAssistantUtil.getElementTypes(elementTypeFilter.getProvider(), input);
            int i = 0;
            while (!result && i < types.length) {
                result = type.equals(types[i]) || ModelingAssistantUtil.isSubtype(types[i], type);
                ++i;
            }
        }
        return result;
    }

    public static IElementType getElementType(ElementTypeFilter elementTypeFilter) {
        IElementType result = null;
        String typeID = elementTypeFilter.getElementTypeID();
        if (typeID != null) {
            if (elementTypeFilter.getProvider() != null) {
                result = elementTypeFilter.getProvider().getElementType(typeID);
            }
            if (result == null) {
                result = ElementTypeRegistry.getInstance().getType(typeID);
            }
        }
        return result;
    }

    public static ModelingAssistantProvider getProvider(ElementTypeFilter elementTypeFilter) {
        ModelingAssistantProvider result = null;
        EObject container = elementTypeFilter.eContainer();
        while (container != null && result == null) {
            if (container instanceof ModelingAssistantProvider) {
                result = (ModelingAssistantProvider)container;
            }
            container = container.eContainer();
        }
        return result;
    }
}

