/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.ui.internal.widget.metaclass;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.emf.facet.util.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.widget.AbstractWidget;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class FilteredElementSelectionWidget
extends AbstractWidget {
    private static final String MATCH_PREFIX = "*";
    private static final int FILTER_WIDTH_HINT = 350;
    private Text filterText;
    private FilteredList fFilteredList;
    private final Object[] elements;
    private static final boolean MULTISELECTION = false;

    public FilteredElementSelectionWidget(Composite parent, Object[] elements) {
        super(parent);
        this.elements = (Object[])elements.clone();
        GridData gridData = new GridData(4);
        gridData.widthHint = 350;
        this.setLayoutData(gridData);
    }

    public void setElements(Object[] elements) {
        this.fFilteredList.setElements(elements);
    }

    private void createFilteredList(Composite parent) {
        int multi = 4;
        this.fFilteredList = new FilteredList(parent, 0xB00 | multi, (ILabelProvider)new LabelProvider(), true, false, true);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fFilteredList.setLayoutData((Object)data);
        this.fFilteredList.setFilter("");
        this.fFilteredList.setElements(this.elements);
    }

    private void createFilterText(Composite parent) {
        this.filterText = new Text(parent, 2048);
        this.filterText.setMessage(Messages.FilteredElementSelectionControl_type_filter_text);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this.filterText.setLayoutData((Object)data);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                FilteredElementSelectionWidget.this.getfFilteredList().setFilter(FilteredElementSelectionWidget.MATCH_PREFIX + FilteredElementSelectionWidget.this.getFilterText().getText());
            }
        });
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x1000002) {
                    FilteredElementSelectionWidget.this.getfFilteredList().setFocus();
                }
            }

            public void keyReleased(KeyEvent event) {
            }
        });
    }

    public Object getFirstSelectedElement() {
        Object result = null;
        Object[] selection = this.fFilteredList.getSelection();
        if (selection.length > 0) {
            result = selection[0];
        }
        return result;
    }

    public Object[] getSelectedElements() {
        Object[] result = null;
        Object[] selection = this.fFilteredList.getSelection();
        if (selection.length != 0) {
            result = selection;
        }
        return result;
    }

    public FilteredList getFilteredList() {
        return this.fFilteredList;
    }

    public Text getFilterText() {
        return this.filterText;
    }

    protected FilteredList getfFilteredList() {
        return this.fFilteredList;
    }

    @Override
    protected void addSubWidgets() {
        this.createFilterText(this);
        this.createFilteredList(this);
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    public void notifyChanged() {
    }
}

