/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.project;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.AbstractProjectEditor;

public class ProjectEditor
extends AbstractProjectEditor
implements IProjectEditor {
    public ProjectEditor(IProject project) throws CoreException {
        super(project);
    }

    ProjectEditor(AbstractProjectEditor master) {
        super(master);
    }

    @Override
    public void createFiles(Set<String> files) {
        IFile file;
        if (files.contains(".project") && !(file = this.getProject().getFile(".project")).exists()) {
            Object input = "";
            input = (String)input + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
            input = (String)input + "<name>";
            input = (String)input + this.getProject().getName();
            input = (String)input + "</name>";
            input = (String)input + "<comment>";
            input = (String)input + "</comment>";
            input = (String)input + "<buildSpec>";
            input = (String)input + "</buildSpec>";
            input = (String)input + "<nature>";
            input = (String)input + "</nature>";
            try {
                file.create(this.getInputStream((String)input), true, null);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> missingFile = super.getMissingFiles();
        IFile projectFile = this.getProject().getFile(".project");
        if (!projectFile.exists()) {
            missingFile.add(".project");
        }
        return missingFile;
    }

    @Override
    public void addFile(URL url, String fileDestinationPath, boolean eraseExitingFile) {
        IFile targetFile = this.getProject().getFile((IPath)new Path(fileDestinationPath));
        if (targetFile.exists()) {
            if (eraseExitingFile) {
                try {
                    targetFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            } else {
                return;
            }
        }
        try {
            InputStream is = url.openStream();
            targetFile.create(is, false, (IProgressMonitor)new NullProgressMonitor());
            is.close();
            targetFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

