/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.richtext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.ContextualDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.MarkupProcessor;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RegexMarkupValue;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;

public class MarkupDisplayConverter
extends ContextualDisplayConverter {
    protected IDisplayConverter wrappedConverter;
    protected Map<String, MarkupProcessor> markups = new LinkedHashMap<String, MarkupProcessor>();

    public MarkupDisplayConverter() {
        this((IDisplayConverter)new DefaultDisplayConverter());
    }

    public MarkupDisplayConverter(IDisplayConverter wrappedConverter) {
        this.wrappedConverter = wrappedConverter;
    }

    public Object canonicalToDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
        Object wrappedConverterResult = this.wrappedConverter.canonicalToDisplayValue(cell, configRegistry, canonicalValue);
        String result = null;
        if (wrappedConverterResult != null) {
            result = wrappedConverterResult.toString();
            for (MarkupProcessor markup : this.markups.values()) {
                result = markup.applyMarkup(result);
            }
        }
        return result;
    }

    public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
        if (displayValue != null) {
            String result = displayValue.toString();
            ArrayList<MarkupProcessor> mc = new ArrayList<MarkupProcessor>(this.markups.values());
            Collections.reverse(mc);
            for (MarkupProcessor markup : mc) {
                result = markup.removeMarkup(result);
            }
            return this.wrappedConverter.displayToCanonicalValue(cell, configRegistry, (Object)result);
        }
        return this.wrappedConverter.displayToCanonicalValue(cell, configRegistry, displayValue);
    }

    public void registerMarkup(String value, String markupPrefix, String markupSuffix) {
        MarkupValue markup = new MarkupValue();
        markup.originalValue = value;
        markup.markupValue = String.valueOf(markupPrefix) + value + markupSuffix;
        this.registerMarkup(value, markup);
    }

    public void registerRegexMarkup(String value, String markupPrefix, String markupSuffix) {
        RegexMarkupValue markup = new RegexMarkupValue(value, markupPrefix, markupSuffix);
        this.registerMarkup(value, markup);
    }

    public void registerMarkup(String id, MarkupProcessor processor) {
        this.markups.put(id, processor);
    }

    public void unregisterMarkup(String value) {
        this.markups.remove(value);
    }

    public void clearMarkups() {
        this.markups.clear();
    }

    protected class MarkupValue
    implements MarkupProcessor {
        String originalValue;
        String markupValue;

        protected MarkupValue() {
        }

        @Override
        public String applyMarkup(String input) {
            return input.replaceAll(this.originalValue, this.markupValue);
        }

        @Override
        public String removeMarkup(String input) {
            return input.replaceAll(this.markupValue, this.originalValue);
        }
    }
}

