/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.util;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.odt.Activator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LibreOfficeInstallationPathUtil {
    private static final String OS_NAME_PROPERTY = "os.name";
    private static final String ARCHITECTURE_PROPERTY = "sun.arch.data.model";
    private static final String LIBREOFFICE_PATH_PROPERTY = "libreoffice.path";
    private static final String WINDOWS_CONST = "windows";
    private static final String LINUX_CONST = "linux";
    private static final String MAC_CONST = "mac";
    private static final String LIBREOFFICE_LINUX_PATH = "/usr/bin/libreoffice";
    private static final String LIBREOFFICE_MAC_PATH = "/Applications/LibreOffice.app/Contents/MacOS/soffice";
    private static final String LIBREOFFICE_WINDOWS_32_PATH = "C:/Program Files (x86)/LibreOffice/program";
    private static final String LIBREOFFICE_WINDOWS_64_PATH = "C:/Program Files/LibreOffice/program";
    private static final String ARCH_64 = "64";

    private LibreOfficeInstallationPathUtil() {
    }

    public static final String getLibreOfficeInstallationPath() {
        String libreOfficePath = Activator.getDefault().getPreferenceStore().getString(LIBREOFFICE_PATH_PROPERTY);
        if (libreOfficePath == null || libreOfficePath.isEmpty()) {
            String osName = System.getProperty(OS_NAME_PROPERTY);
            String arch = System.getProperty(ARCHITECTURE_PROPERTY);
            if (osName.toLowerCase().contains(WINDOWS_CONST)) {
                libreOfficePath = ARCH_64.equals(arch) ? LIBREOFFICE_WINDOWS_64_PATH : LIBREOFFICE_WINDOWS_32_PATH;
            } else if (osName.toLowerCase().contains(LINUX_CONST)) {
                libreOfficePath = LIBREOFFICE_LINUX_PATH;
            } else if (osName.toLowerCase().contains(MAC_CONST)) {
                libreOfficePath = LIBREOFFICE_MAC_PATH;
            }
            if (!new File(libreOfficePath).exists()) {
                libreOfficePath = LibreOfficeInstallationPathUtil.dialogSetLibreOfficeInstallation(libreOfficePath);
            }
            Activator.getDefault().getPreferenceStore().setValue(LIBREOFFICE_PATH_PROPERTY, libreOfficePath);
        }
        return libreOfficePath;
    }

    public static final void eraseLibreOfficeInstallationPath() {
        Activator.getDefault().getPreferenceStore().setValue(LIBREOFFICE_PATH_PROPERTY, "");
    }

    private static String dialogSetLibreOfficeInstallation(String expectdLibreOfficePath) {
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"LibreOffice not found!", (String)NLS.bind((String)"We are looking for the LibreOffice installation folder and we didn't found it.\nPlease select LibreOffice installation path in the next dialog.\n Usually, it should be something like {0}.", (Object)expectdLibreOfficePath));
        String libreofficePath = null;
        DirectoryDialog dirDialog = new DirectoryDialog(Display.getDefault().getActiveShell());
        dirDialog.setFilterPath(null);
        dirDialog.setText("Select LibreOffice installation path.");
        dirDialog.setMessage("We are looking for your LibreOffice installation folder path and we can't found it.\n Please indicate us its installation path.");
        libreofficePath = dirDialog.open();
        return libreofficePath;
    }
}

