/**
 * Copyright (c) 2023 CEA LIST.
 *
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License 2.0
 *  which accompanies this distribution, and is available at
 *  https://www.eclipse.org/legal/epl-2.0/
 *
 *  SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 */
package org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.papyrus.model2doc.markup.emf.documentstructuretemplate.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 *
 * @generated
 */
public class MarkupEMFDocumentStructureTemplateFactoryImpl extends EFactoryImpl implements MarkupEMFDocumentStructureTemplateFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public static MarkupEMFDocumentStructureTemplateFactory init() {
		try {
			MarkupEMFDocumentStructureTemplateFactory theMarkupEMFDocumentStructureTemplateFactory = (MarkupEMFDocumentStructureTemplateFactory) EPackage.Registry.INSTANCE.getEFactory(MarkupEMFDocumentStructureTemplatePackage.eNS_URI);
			if (theMarkupEMFDocumentStructureTemplateFactory != null) {
				return theMarkupEMFDocumentStructureTemplateFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new MarkupEMFDocumentStructureTemplateFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public MarkupEMFDocumentStructureTemplateFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
		case MarkupEMFDocumentStructureTemplatePackage.EATTRIBUTE_IN_MARKUP_TO_FILE:
			return createEAttributeInMarkupToFile();
		default:
			throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EAttributeInMarkupToFile createEAttributeInMarkupToFile() {
		EAttributeInMarkupToFileImpl eAttributeInMarkupToFile = new EAttributeInMarkupToFileImpl();
		return eAttributeInMarkupToFile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public MarkupEMFDocumentStructureTemplatePackage getMarkupEMFDocumentStructureTemplatePackage() {
		return (MarkupEMFDocumentStructureTemplatePackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static MarkupEMFDocumentStructureTemplatePackage getPackage() {
		return MarkupEMFDocumentStructureTemplatePackage.eINSTANCE;
	}

} // MarkupEMFDocumentStructureTemplateFactoryImpl
