/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEnvironmentBase;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtTypeResolverImpl;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.HiddenElementAdapter;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.MappingsMapKey;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.resourcesetprovider.ResourceSetProviderRegistry;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.cst.adapters.ModelTypeMetamodelsAdapter;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelDesc;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveInExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.VariableInitExp;
import org.eclipse.ocl.AbstractEnvironment;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.AbstractProblemHandler;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalEnv
extends QvtEnvironmentBase {
    public static final String THIS = "this";
    public static final String MAIN = "main";
    public static final String MAPPING_OPERATION_STEREOTYPE = "mapping_operation";
    public static final String IMPERATIVE_OPERATION_STEREOTYPE = "imperative_operation";
    public static final String RENAMED_PROPERTY_STEREOTYPE = "renamed_property";
    public static final String INTERMEDIATE_PROPERTY_STEREOTYPE = "intermediate_property";
    public static final String METAMODEL_COMPLIANCE_KIND_STRICT = "strict";
    private List<QvtVariableEntry> myNamedElements = new ArrayList<QvtVariableEntry>();
    private final Set<String> myLookupOperationNames = new HashSet<String>(1);
    private final Set<String> myLookupPropertyNames = new HashSet<String>(1);
    private final Set<String> myLookupAssocClassNames = new HashSet<String>(1);
    private final List<QvtMessage> myWarningsList;
    private final List<QvtMessage> myErrorsList;
    private boolean myCheckForDuplicateErrors;
    private QvtCompilerOptions myCompilerOptions;
    private QvtTypeResolverImpl myTypeResolver;
    private Map<String, ModelType> myModelTypeRegistry;
    private List<Variable<EClassifier, EParameter>> myModelParameters = Collections.emptyList();
    private final EPackage.Registry ePackageRegistry;
    private final Map<MappingsMapKey, List<MappingOperation>> myMappingsMap = new HashMap<MappingsMapKey, List<MappingOperation>>();
    private final Map<ResolveInExp, MappingsMapKey> myResolveInExps = new HashMap<ResolveInExp, MappingsMapKey>();
    private static final QvtOperationalEnvFactory myFactory = new QvtOperationalEnvFactory();
    private final LookupPackageableElementDelegate<EClassifier> LOOKUP_CLASSIFIER_DELEGATE = new LookupPackageableElementDelegate<EClassifier>(){

        @Override
        public EClassifier lookupPackageableElement(List<String> names) {
            return QvtOperationalEnv.super.lookupClassifier(names);
        }
    };
    private final LookupPackageableElementDelegate<EPackage> LOOKUP_PACKAGE_DELEGATE = new LookupPackageableElementDelegate<EPackage>(){

        @Override
        public EPackage lookupPackageableElement(List<String> names) {
            return QvtOperationalEnv.super.lookupPackage(names);
        }
    };

    protected QvtOperationalEnv(QvtOperationalEnv parent, EPackage.Registry eRegistry) {
        super(eRegistry);
        this.setParent((AbstractEnvironment)parent);
        this.myWarningsList = new ArrayList<QvtMessage>(2);
        this.myErrorsList = new ArrayList<QvtMessage>(2);
        this.myCheckForDuplicateErrors = false;
        this.ePackageRegistry = eRegistry;
        LinkedHashMap linkedHashMap = this.myModelTypeRegistry = parent != null ? parent.myModelTypeRegistry : new LinkedHashMap(1);
        if (parent != null) {
            this.myCompilerOptions = parent.myCompilerOptions;
        }
    }

    protected QvtOperationalEnv(QvtOperationalEnv parent) {
        this(parent, (EPackage.Registry)(parent != null ? parent.getEPackageRegistry() : new EPackageRegistryImpl()));
    }

    public final TypeResolver<EClassifier, EOperation, EStructuralFeature> getTypeResolver() {
        if (this.myTypeResolver == null) {
            QvtOperationalEnv rootEnv = this.rootEnv();
            this.myTypeResolver = rootEnv != null ? rootEnv.getQVTTypeResolver() : new QvtTypeResolverImpl(this, (TypeResolver<EClassifier, EOperation, EStructuralFeature>)super.getTypeResolver());
        }
        return this.myTypeResolver;
    }

    public UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> getUMLReflection() {
        Environment.Internal parent = this.getInternalParent();
        if (parent != null) {
            return parent.getUMLReflection();
        }
        return super.getUMLReflection();
    }

    public List<Module> getNativeLibs() {
        if (this.getInternalParent() instanceof QvtOperationalEnv) {
            return ((QvtOperationalEnv)this.getInternalParent()).getNativeLibs();
        }
        return Collections.emptyList();
    }

    public EPackage.Registry getEPackageRegistry() {
        return this.ePackageRegistry;
    }

    public Map<String, ModelType> getModelTypeRegistry() {
        return this.myModelTypeRegistry;
    }

    public MetamodelRegistry getMetamodelRegistry() {
        if (this.getInternalParent() instanceof QvtOperationalEnv) {
            return ((QvtOperationalEnv)this.getInternalParent()).getMetamodelRegistry();
        }
        return MetamodelRegistry.getInstance();
    }

    public QvtOperationalStdLibrary getQVTStandardLibrary() {
        return QvtOperationalStdLibrary.INSTANCE;
    }

    public List<EPackage> registerMetamodel(String metamodelUri, List<String> path, ResourceSet resolutionRS) {
        ArrayList<EPackage> metamodels = new ArrayList<EPackage>(1);
        try {
            IMetamodelDesc[] desc = null;
            QvtOperationalEnv env = this;
            while (env != null) {
                if (env instanceof QvtOperationalFileEnv) {
                    URI mmURI;
                    ResourceSet providedResourceSet;
                    CFile cFile;
                    QvtOperationalFileEnv fileEnv = (QvtOperationalFileEnv)env;
                    ResourceSet resourceSet = fileEnv.getKernel().getMetamodelResourceSet();
                    ResourceSetProviderRegistry.ResourceSetResourceSetProviderPair pair = null;
                    if (resourceSet == null && (pair = ResourceSetProviderRegistry.getResourceSetResourceSetProviderPair((CFile)(cFile = fileEnv.getFile()))) != null && EmfUtil.isUriMapped((ResourceSet)(providedResourceSet = pair.getResourceSet()), (URI)(mmURI = URI.createURI((String)metamodelUri)))) {
                        resourceSet = providedResourceSet;
                    }
                    if (resourceSet == null) break;
                    IMetamodelDesc metamodelDesc = MetamodelRegistry.createUndeclaredMetamodel((String)metamodelUri, (ResourceSet)resourceSet);
                    if (metamodelDesc != null) {
                        desc = new IMetamodelDesc[]{metamodelDesc};
                    }
                    if (pair == null) break;
                    pair.getResourceSetProvider().dispose(resourceSet);
                    break;
                }
                env = env.getInternalParent();
            }
            if (desc == null) {
                MetamodelRegistry registry = this.getMetamodelRegistry();
                desc = path.isEmpty() ? new IMetamodelDesc[]{registry.getMetamodelDesc(metamodelUri, this.myCompilerOptions != null && this.myCompilerOptions.getMetamodelResourceSet() != null ? this.myCompilerOptions.getMetamodelResourceSet() : resolutionRS)} : registry.getMetamodelDesc(path);
            }
            IMetamodelDesc[] iMetamodelDescArray = desc;
            if (desc.length != 0) {
                IMetamodelDesc nextDesc = iMetamodelDescArray[0];
                EPackage model = nextDesc.getModel();
                if (model.getNsURI() == null) {
                    while (model.getESuperPackage() != null) {
                        model = model.getESuperPackage();
                    }
                }
                metamodels.add(model);
                this.getEPackageRegistry().put((Object)model.getNsURI(), (Object)model);
            }
        }
        catch (EmfException emfException) {}
        return metamodels;
    }

    public QvtOperationalEnvFactory getFactory() {
        return myFactory;
    }

    protected void setFactory(EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> factory) {
        super.setFactory(factory);
    }

    public EOperation lookupOperation(EClassifier owner, String name, List<? extends TypedElement<EClassifier>> args) {
        EOperation o = this.getQVTStandardLibrary().resolveGenericOperationsIfNeeded(this, owner, name, args);
        if (o != null) {
            return o;
        }
        UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> uml = this.getUMLReflection();
        List<EOperation> lookupMappingOperations = this.lookupMappingOperations(owner, name);
        block0: for (EOperation op : lookupMappingOperations) {
            EList params = op.getEParameters();
            if (params.size() != args.size()) continue;
            int i = 0;
            int n = params.size();
            while (i < n) {
                EClassifier popType;
                EClassifier argType;
                TypedElement<EClassifier> argVal = args.get(i);
                if (argVal != null && !QvtOperationalParserUtil.isTypeEquals(this, argType = (EClassifier)argVal.getType(), popType = (EClassifier)uml.getOCLType(params.get(i)))) continue block0;
                ++i;
            }
            return op;
        }
        return (EOperation)super.lookupOperation((Object)owner, name, args);
    }

    public List<EOperation> lookupMappingOperations(EClassifier owner, String name) {
        if (owner == null) {
            owner = this.getModuleContextType();
        }
        UMLReflection<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint> uml = this.getUMLReflection();
        List operations = TypeUtil.getOperations((Environment)this, (Object)owner);
        ArrayList<EOperation> result = new ArrayList<EOperation>();
        for (EOperation operation : operations) {
            if (!uml.getName((Object)operation).equals(name) || !QvtOperationalUtil.isMappingOperation(operation)) continue;
            result.add(operation);
        }
        return result;
    }

    protected void addedVariable(String name, Variable<EClassifier, EParameter> elem, boolean isExplicit) {
        super.addedVariable(name, elem, isExplicit);
        if (!((EClassifier)this.getOCLStandardLibrary().getOclVoid()).getName().equals(name)) {
            QvtVariableEntry newelem = new QvtVariableEntry(name, elem, isExplicit);
            this.myNamedElements.add(newelem);
        }
    }

    public void deleteElement(String name) {
        Iterator<QvtVariableEntry> iter = this.myNamedElements.iterator();
        while (iter.hasNext()) {
            QvtVariableEntry elem = iter.next();
            if (!elem.getName().equals(name)) continue;
            iter.remove();
        }
        super.deleteElement(name);
    }

    public Variable<EClassifier, EParameter> lookupAnyImplicitSource() {
        int i = this.myNamedElements.size() - 1;
        while (i >= 0) {
            QvtVariableEntry element = this.myNamedElements.get(i);
            Variable<EClassifier, EParameter> vdcl = element.getVariable();
            if (!element.isExplicit) {
                return vdcl;
            }
            --i;
        }
        if (this.getInternalParent() instanceof QvtOperationalEnv) {
            QvtOperationalEnv parentEnv = (QvtOperationalEnv)this.getInternalParent();
            return parentEnv.lookupAnyImplicitSource();
        }
        return null;
    }

    public Variable<EClassifier, EParameter> lookupImplicitSourceForResolveExp() {
        Variable<EClassifier, EParameter> implicitSource = this.lookupAnyImplicitSource();
        if (implicitSource != null && (implicitSource.getType() == this.getModuleContextType() || "self".equals(implicitSource.getName()))) {
            return null;
        }
        return implicitSource;
    }

    public void reportError(String message, int startOffset, int endOffset) {
        if (this.myCompilerOptions != null && !this.myCompilerOptions.isReportErrors()) {
            return;
        }
        QvtOperationalEnv parent = this;
        while (parent.getInternalParent() != null) {
            parent = (QvtOperationalEnv)parent.getInternalParent();
        }
        boolean foundSameLocation = false;
        int msgLength = endOffset - startOffset + 1;
        if (this.myCheckForDuplicateErrors) {
            for (QvtMessage msg : parent.myErrorsList) {
                if (msg.getOffset() != startOffset || msg.getLength() != msgLength) continue;
                foundSameLocation = true;
                break;
            }
        }
        if (!foundSameLocation) {
            parent.myErrorsList.add(new QvtMessage(message, 2, startOffset, msgLength, QvtOperationalEnv.getLineNum(parent, startOffset)));
        }
    }

    public void reportWarning(String message, int startOffset, int endOffset) {
        if (this.myCompilerOptions != null && !this.myCompilerOptions.isReportErrors()) {
            return;
        }
        QvtOperationalEnv parent = this;
        while (parent.getInternalParent() != null) {
            parent = (QvtOperationalEnv)parent.getInternalParent();
        }
        parent.myWarningsList.add(new QvtMessage(message, 1, startOffset, endOffset - startOffset + 1, QvtOperationalEnv.getLineNum(parent, startOffset)));
    }

    public void reportError(String message, CSTNode node) {
        int startOffset = node != null ? node.getStartOffset() : 0;
        int endOffset = node != null ? node.getEndOffset() : 0;
        this.reportError(message, startOffset, endOffset);
    }

    public void reportWarning(String message, CSTNode node) {
        int startOffset = node != null ? node.getStartOffset() : 0;
        int endOffset = node != null ? node.getEndOffset() : 0;
        this.reportWarning(message, startOffset, endOffset);
    }

    public boolean hasErrors() {
        return this.myErrorsList != null && !this.myErrorsList.isEmpty();
    }

    public boolean hasWarnings() {
        return this.myWarningsList != null && !this.myWarningsList.isEmpty();
    }

    public List<QvtMessage> getErrorsList() {
        return this.myErrorsList;
    }

    public List<QvtMessage> getWarningsList() {
        return this.myWarningsList;
    }

    public List<QvtMessage> getAllProblemMessages() {
        if (this.hasErrors() || this.hasWarnings()) {
            ArrayList<QvtMessage> result = new ArrayList<QvtMessage>();
            result.addAll(this.getErrorsList());
            result.addAll(this.getWarningsList());
            return result;
        }
        return Collections.emptyList();
    }

    public void registerModelParameters(Module module) {
        ArrayList<Variable<EClassifier, EParameter>> modelParameters = new ArrayList<Variable<EClassifier, EParameter>>(module.getModelParameter().size());
        for (ModelParameter modelParam : module.getModelParameter()) {
            if (this.lookupLocal(modelParam.getName()) != null) {
                this.reportError(NLS.bind((String)ValidationMessages.SemanticUtil_15, (Object[])new Object[]{modelParam.getName()}), modelParam.getStartPosition(), modelParam.getEndPosition());
                continue;
            }
            Variable var = ExpressionsFactory.eINSTANCE.createVariable();
            var.setName(modelParam.getName());
            var.setType((Object)modelParam.getEType());
            var.setRepresentedParameter((Object)modelParam);
            modelParameters.add((Variable<EClassifier, EParameter>)var);
        }
        this.registerModelParametersImpl(modelParameters);
    }

    private void registerModelParametersImpl(List<Variable<EClassifier, EParameter>> modelParameters) {
        this.myModelParameters = modelParameters;
        for (Variable<EClassifier, EParameter> var : modelParameters) {
            this.addElement(var.getName(), var, true);
        }
    }

    public ModelParameter lookupModelParameter(String name, DirectionKind directionKind) {
        if (name == null) {
            return null;
        }
        for (Variable<EClassifier, EParameter> var : this.myModelParameters) {
            String nextParamName;
            ModelParameter modelParam = (ModelParameter)var.getRepresentedParameter();
            if (directionKind == DirectionKind.OUT && modelParam.getKind() == DirectionKind.IN || (nextParamName = modelParam.getName()) == null || !nextParamName.equals(name)) continue;
            return modelParam;
        }
        return null;
    }

    public List<String> getAllExtentNames(DirectionKind directionKind) {
        ArrayList<String> result = new ArrayList<String>(this.myModelParameters.size());
        for (Variable<EClassifier, EParameter> var : this.myModelParameters) {
            String nextParam;
            ModelParameter modelParam = (ModelParameter)var.getRepresentedParameter();
            if (directionKind == DirectionKind.OUT && modelParam.getKind() == DirectionKind.IN || (nextParam = modelParam.getName()) == null || nextParam.length() <= 0) continue;
            result.add(nextParam);
        }
        return Collections.unmodifiableList(result);
    }

    public ModelParameter resolveModelParameter(EClassifier type, DirectionKind directionKind) {
        if (!this.isMayBelongToExtent(type)) {
            return null;
        }
        return QvtOperationalEnv.findModelParameter(type, directionKind, this.getModelParameters());
    }

    private List<ModelParameter> getModelParameters() {
        ArrayList<ModelParameter> result = new ArrayList<ModelParameter>(this.myModelParameters.size());
        for (Variable<EClassifier, EParameter> modelParamVar : this.myModelParameters) {
            result.add((ModelParameter)modelParamVar.getRepresentedParameter());
        }
        return result;
    }

    static ModelParameter findModelParameter(EClassifier type, DirectionKind directionKind, Collection<ModelParameter> modelParameters) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)type);
        for (ModelParameter modelParam : modelParameters) {
            List<EPackage> metamodels;
            if (directionKind == DirectionKind.OUT && modelParam.getKind() == DirectionKind.IN || (metamodels = ModelTypeMetamodelsAdapter.getMetamodels((EObject)modelParam.getEType())).isEmpty() || rootContainer != metamodels.get(0)) continue;
            return modelParam;
        }
        for (ModelParameter modelParam : modelParameters) {
            if (directionKind == DirectionKind.OUT && modelParam.getKind() == DirectionKind.IN) continue;
            return modelParam;
        }
        return null;
    }

    public void registerModelType(ModelType modelType, boolean isCheckDuplicates) {
        if (this.myModelTypeRegistry.containsKey(modelType.getName())) {
            if (isCheckDuplicates) {
                this.reportError(NLS.bind((String)ValidationMessages.QvtOperationalVisitorCS_modeltypeAlreadyDefined, (Object[])new Object[]{modelType.getName()}), modelType.getStartPosition(), modelType.getEndPosition());
            }
        } else {
            this.myModelTypeRegistry.put(modelType.getName(), modelType);
        }
    }

    public ModelType getModelType(List<String> path) {
        if (path.isEmpty()) {
            return null;
        }
        return this.myModelTypeRegistry.get(path.get(0));
    }

    @Override
    public Variable<EClassifier, EParameter> lookupImplicitSourceForOperation(String name, List<? extends TypedElement<EClassifier>> args) {
        if (this.myLookupOperationNames.contains(name)) {
            return null;
        }
        Variable result = null;
        try {
            this.myLookupOperationNames.add(name);
            Variable tentativeResult = result = super.lookupImplicitSourceForOperation(name, args);
            if ((result == null || "self".equals(result.getName())) && this.getInternalParent() != null) {
                result = this.getInternalParent().lookupImplicitSourceForOperation(name, args);
                if (tentativeResult != null && result == null) {
                    result = tentativeResult;
                }
            }
        }
        finally {
            this.myLookupOperationNames.remove(name);
        }
        return result;
    }

    @Override
    public Variable<EClassifier, EParameter> lookupImplicitSourceForProperty(String name) {
        if (this.myLookupPropertyNames.contains(name)) {
            return null;
        }
        Variable implicitSource = null;
        try {
            this.myLookupPropertyNames.add(name);
            Variable tentativeResult = implicitSource = super.lookupImplicitSourceForProperty(name);
            if ((implicitSource == null || "self".equals(implicitSource.getName())) && this.getInternalParent() != null) {
                implicitSource = this.getInternalParent().lookupImplicitSourceForProperty(name);
                if (tentativeResult != null && implicitSource == null) {
                    implicitSource = tentativeResult;
                }
            }
        }
        finally {
            this.myLookupPropertyNames.remove(name);
        }
        return implicitSource;
    }

    public Variable<EClassifier, EParameter> lookupImplicitSourceForAssociationClass(String name) {
        if (this.myLookupAssocClassNames.contains(name)) {
            return null;
        }
        Variable implicitSource = null;
        try {
            this.myLookupAssocClassNames.add(name);
            implicitSource = super.lookupImplicitSourceForAssociationClass(name);
        }
        finally {
            this.myLookupAssocClassNames.remove(name);
        }
        return implicitSource;
    }

    public EClassifier lookupClassifier(List<String> names) {
        EClassifier result;
        if (names.size() == 1) {
            if (this.myModelTypeRegistry.containsKey(names.get(0))) {
                return (EClassifier)this.myModelTypeRegistry.get(names.get(0));
            }
            for (ModelType modelType : this.myModelTypeRegistry.values()) {
                EClassifier lookupClassifier = this.doLookupModeltypeClassifier(modelType, names);
                if (lookupClassifier == null) continue;
                return lookupClassifier;
            }
        }
        if (names.size() > 1) {
            EClassifier lookupClassifier;
            EClassifier stdType;
            if (names.size() == 2 && (stdType = QvtOperationalStdLibrary.INSTANCE.lookupClassifier(names)) != null) {
                return stdType;
            }
            if (this.myModelTypeRegistry.containsKey(names.get(0)) && (lookupClassifier = this.doLookupModeltypeClassifier(this.myModelTypeRegistry.get(names.get(0)), names.subList(1, names.size()))) != null) {
                return lookupClassifier;
            }
        }
        return (result = super.lookupClassifier(names)) != null ? result : QvtOperationalStdLibrary.INSTANCE.lookupClassifier(names);
    }

    public EPackage lookupPackage(List<String> path) {
        Module stdPackage;
        if (path.size() > 1) {
            EPackage lookupPackage;
            if (this.myModelTypeRegistry.containsKey(path.get(0)) && (lookupPackage = this.doLookupModeltypePackage(this.myModelTypeRegistry.get(path.get(0)), path.subList(1, path.size()))) != null) {
                return lookupPackage;
            }
        } else if (path.size() == 1 && (stdPackage = QvtOperationalStdLibrary.INSTANCE.getStdLibModule()).getName().equals(path.get(0))) {
            return stdPackage;
        }
        return super.lookupPackage(path);
    }

    private EPackage doLookupModeltypePackage(ModelType modelType, List<String> path) {
        return this.lookupPackageableElement(modelType, path, this.LOOKUP_PACKAGE_DELEGATE);
    }

    private EClassifier doLookupModeltypeClassifier(ModelType modelType, List<String> path) {
        return this.lookupPackageableElement(modelType, path, this.LOOKUP_CLASSIFIER_DELEGATE);
    }

    private <T extends EObject> T lookupPackageableElement(ModelType modelType, List<String> path, LookupPackageableElementDelegate<T> lookupPackageableElementDelegate) {
        EPackage oldContext = (EPackage)super.getContextPackage();
        EObject result = null;
        List<EPackage> metamodels = ModelTypeMetamodelsAdapter.getMetamodels((EObject)modelType);
        for (EPackage pkg : metamodels) {
            super.setContextPackage((Object)pkg);
            EObject eContainer = result = (EObject)lookupPackageableElementDelegate.lookupPackageableElement(path);
            int i = 0;
            int n = path.size();
            while (i < n) {
                if (eContainer == null) break;
                eContainer = eContainer.eContainer();
                ++i;
            }
            if (eContainer != pkg) {
                result = null;
            }
            if (result != null) break;
        }
        super.setContextPackage((Object)oldContext);
        return (T)result;
    }

    public EOperation defineImperativeOperation(ImperativeOperation operation, boolean isMappingOperation, boolean isCheckDuplicates) {
        ImperativeOperation newOperation;
        QvtEnvironmentBase.CollisionStatus collidingOperStatus;
        Object ownerType = QvtOperationalParserUtil.getContextualType(operation);
        boolean isContextual = true;
        if (ownerType == null) {
            isContextual = false;
            ownerType = this.getModuleContextType();
        }
        if ((collidingOperStatus = this.findCollidingOperation((EClassifier)ownerType, newOperation = operation)) != null) {
            if (collidingOperStatus.getCollisionKind() == 1) {
                HiddenElementAdapter.markAsHidden((EObject)operation);
                this.reportError(NLS.bind((String)ValidationMessages.SemanticUtil_0, (Object[])new Object[]{operation.getName(), ownerType.getName()}), operation.getStartPosition(), operation.getEndPosition());
            } else if (collidingOperStatus.getCollisionKind() == 2) {
                HiddenElementAdapter.markAsHidden((EObject)operation);
                this.reportError(NLS.bind((String)ValidationMessages.ReturnTypeMismatch, (Object)operation.getName(), (Object)QvtOperationalTypesUtil.getTypeFullName(collidingOperStatus.getOperation().getEType())), operation.getStartPosition(), operation.getEndPosition());
            } else assert (false);
        } else if (isContextual) {
            this.getTypeResolver().resolveAdditionalOperation(ownerType, (Object)newOperation);
        }
        this.getModuleContextType().getEOperations().add((Object)newOperation);
        return newOperation;
    }

    @Override
    public Module getModuleContextType() {
        return this.getInternalParent() instanceof QvtOperationalEnv ? ((QvtOperationalEnv)this.getInternalParent()).getModuleContextType() : null;
    }

    private void defineParameterVar(EParameter parameter) {
        Variable var = ExpressionsFactory.eINSTANCE.createVariable();
        var.setName(parameter.getName());
        var.setType((Object)parameter.getEType());
        var.setRepresentedParameter((Object)parameter);
        this.addElement(parameter.getName(), var, true);
    }

    public void defineOperationParameters(ImperativeOperation operation) {
        for (EParameter parameter : operation.getEParameters()) {
            this.defineParameterVar(parameter);
        }
        boolean isMapping = operation instanceof MappingOperation;
        if (isMapping || operation.getResult().size() > 1) {
            for (VarParameter parameter : operation.getResult()) {
                this.defineParameterVar(parameter);
            }
        }
        if (operation.getResult().size() > 1 && isMapping) {
            Variable var = ExpressionsFactory.eINSTANCE.createVariable();
            var.setName("result");
            var.setType((Object)operation.getEType());
            this.addElement(var.getName(), var, true);
        }
    }

    public QvtOperationalEnv createOperationEnvironment(ImperativeOperation operation) {
        VarParameter context;
        QvtOperationalEnv newEnvironment = new QvtOperationalEnv(this);
        newEnvironment.setASTNodeToCSTNodeMap(this.getASTNodeToCSTNodeMap());
        if (QvtOperationalParserUtil.isContextual(operation) && (context = operation.getContext()).getEType() != this.getModuleContextType()) {
            Variable var = ExpressionsFactory.eINSTANCE.createVariable();
            var.setName("self");
            var.setType((Object)context.getEType());
            var.setRepresentedParameter((Object)context);
            newEnvironment.addElement(var.getName(), var, false);
        }
        newEnvironment.registerModelParametersImpl(this.myModelParameters);
        newEnvironment.setContextOperation(operation);
        return newEnvironment;
    }

    public void addInitVariable(VariableInitExp varInit) {
        if (varInit.getName() != null) {
            Variable var = ExpressionsFactory.eINSTANCE.createVariable();
            var.setName(varInit.getName());
            var.setType((Object)((EClassifier)varInit.getType()));
            this.addElement(varInit.getName(), var, true);
        }
    }

    public void setQvtCompilerOptions(QvtCompilerOptions options) {
        this.myCompilerOptions = options;
    }

    public void setCheckForDuplicateErrors(boolean checkForDuplicateErrors) {
        this.myCheckForDuplicateErrors = checkForDuplicateErrors;
    }

    public void registerMappingOperation(MappingOperation operation) {
        if (this.getInternalParent() != null) {
            ((QvtOperationalEnv)this.getInternalParent()).registerMappingOperation(operation);
        } else {
            MappingsMapKey key;
            List<MappingOperation> sameNameAndContextOperations;
            Object ownerType = QvtOperationalParserUtil.getContextualType(operation);
            if (ownerType == null) {
                ownerType = this.getModuleContextType();
            }
            if ((sameNameAndContextOperations = this.myMappingsMap.get(key = new MappingsMapKey((EClassifier)ownerType, operation.getName()))) == null) {
                sameNameAndContextOperations = new ArrayList<MappingOperation>();
                this.myMappingsMap.put(key, sameNameAndContextOperations);
            }
            sameNameAndContextOperations.add(operation);
        }
    }

    public void registerResolveInExp(ResolveInExp resolveInExp, EClassifier referredMappingContextType, String mappingName) {
        if (this.getInternalParent() != null) {
            ((QvtOperationalEnv)this.getInternalParent()).registerResolveInExp(resolveInExp, referredMappingContextType, mappingName);
        } else {
            this.myResolveInExps.put(resolveInExp, new MappingsMapKey(referredMappingContextType, mappingName));
        }
    }

    public void resolveResolveInExpInMappings() {
        if (this.getInternalParent() == null) {
            for (Map.Entry<ResolveInExp, MappingsMapKey> entry : this.myResolveInExps.entrySet()) {
                MappingsMapKey mappingsMapKey = entry.getValue();
                List<MappingOperation> sameNameAndContextOperations = this.myMappingsMap.get(mappingsMapKey);
                if (sameNameAndContextOperations == null) continue;
                for (MappingOperation mappingOperation : sameNameAndContextOperations) {
                    ResolveInExp resolveInExp = entry.getKey();
                    resolveInExp.getInMappings().add((Object)mappingOperation);
                }
            }
        } else {
            ((QvtOperationalEnv)this.getInternalParent()).resolveResolveInExpInMappings();
        }
    }

    protected ProblemHandler createDefaultProblemHandler(AbstractParser parser) {
        return new AbstractProblemHandler(parser){

            public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
                if (startOffset == -1 && endOffset == -1) {
                    return;
                }
                if (problemSeverity == ProblemHandler.Severity.INFO || problemSeverity == ProblemHandler.Severity.OK || problemSeverity == ProblemHandler.Severity.WARNING) {
                    QvtOperationalEnv.this.reportWarning(problemMessage, startOffset, endOffset);
                } else {
                    QvtOperationalEnv.this.reportError(problemMessage, startOffset, endOffset);
                }
            }
        };
    }

    private boolean isMayBelongToExtent(EClassifier myType) {
        return myType != null && this.getOCLStandardLibrary().getOclVoid() != myType && this.getOCLStandardLibrary().getOclInvalid() != myType;
    }

    public void analyzerError(String problemMessage, String problemContext, Object problemObject) {
        int endOffset;
        CSTNode cstNode = this.getASTMapping(problemObject);
        int startOffset = cstNode != null ? cstNode.getStartOffset() : -1;
        int n = endOffset = cstNode != null ? cstNode.getEndOffset() : -1;
        if (cstNode == null && problemObject instanceof ASTNode) {
            ASTNode astNode = (ASTNode)problemObject;
            startOffset = astNode.getStartPosition();
            endOffset = astNode.getEndPosition();
        }
        this.analyzerError(problemMessage, problemContext, startOffset, endOffset);
    }

    public void initASTMapping(Object astNode, CSTNode cstNode) {
        ASTNode castNode;
        if (astNode instanceof ASTNode && (castNode = (ASTNode)astNode).getEndPosition() < 0) {
            castNode.setStartPosition(cstNode.getStartOffset());
            castNode.setEndPosition(cstNode.getEndOffset());
        }
        super.initASTMapping(astNode, cstNode);
    }

    protected QvtOperationalEnv rootEnv() {
        QvtOperationalEnv base = this;
        while (base.getInternalParent() instanceof QvtOperationalEnv) {
            base = (QvtOperationalEnv)base.getInternalParent();
        }
        return base == this ? null : base;
    }

    private static int getLineNum(QvtOperationalEnv env, int startOffset) {
        AbstractLexer lexer;
        if (startOffset < 0) {
            return -1;
        }
        AbstractParser parser = env.getParser();
        if (parser != null && (lexer = parser.getLexer()) != null && startOffset <= lexer.getStreamLength()) {
            try {
                return lexer.getLineNumberOfCharAt(startOffset);
            }
            catch (RuntimeException runtimeException) {}
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LookupPackageableElementDelegate<T> {
        public T lookupPackageableElement(List<String> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class QvtVariableEntry {
        private final String myName;
        private final Variable<EClassifier, EParameter> myVariable;
        private final boolean isExplicit;

        public QvtVariableEntry(String name, Variable<EClassifier, EParameter> variable, boolean isExplicit) {
            this.myName = name;
            this.myVariable = variable;
            this.isExplicit = isExplicit;
        }

        public String getName() {
            return this.myName;
        }

        public Variable<EClassifier, EParameter> getVariable() {
            return this.myVariable;
        }

        public boolean isExplicit() {
            return this.isExplicit;
        }
    }
}

