/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtcore.utilities;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.Area;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcEnvironmentFactory;

public class QVTcoreUtil
extends QVTbaseUtil {
    public static @Nullable CoreDomain basicGetDomain(@NonNull Mapping rule, @NonNull TypedModel typedModel) {
        return (CoreDomain)QVTcoreUtil.basicGetDomain((Rule)rule, (TypedModel)typedModel);
    }

    public static @Nullable Mapping basicGetOverridden(@NonNull Mapping asMapping) {
        return (Mapping)asMapping.getOverridden();
    }

    public static @Nullable TypedModel basicGetTypedModel(@Nullable Area area) {
        if (area instanceof CoreDomain) {
            return ((CoreDomain)area).getTypedModel();
        }
        return null;
    }

    public static @NonNull Set<Mapping> getAllRefinedMappings(@NonNull Mapping mapping) {
        return QVTcoreUtil.getAllRefinedMappings(new HashSet<Mapping>(), mapping);
    }

    private static @NonNull Set<Mapping> getAllRefinedMappings(@NonNull Set<Mapping> allMappings, @NonNull Mapping mapping) {
        if (allMappings.add(mapping)) {
            for (Mapping refinedMapping : mapping.getSpecification()) {
                QVTcoreUtil.getAllRefinedMappings(allMappings, refinedMapping);
            }
        }
        return allMappings;
    }

    public static @NonNull Area getArea(@NonNull Mapping mapping, @NonNull TypedModel typedModel) {
        for (Domain domain : mapping.getDomain()) {
            if (domain.getTypedModel() != typedModel) continue;
            return (CoreDomain)domain;
        }
        return mapping;
    }

    public static @NonNull BottomPattern getBottomPattern(@NonNull Area area) {
        return (BottomPattern)ClassUtil.nonNullState((Object)area.getBottomPattern());
    }

    public static @Nullable Area getContainingArea(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Area) {
                return (Area)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Mapping getContainingMapping(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Mapping) {
                return (Mapping)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable CorePattern getContainingPattern(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof CorePattern) {
                return (CorePattern)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @NonNull CoreDomain getDomain(@NonNull Mapping rule, @NonNull TypedModel typedModel) {
        return (CoreDomain)QVTcoreUtil.getDomain((Rule)rule, (TypedModel)typedModel);
    }

    public static @NonNull GuardPattern getGuardPattern(@NonNull Area area) {
        return (GuardPattern)ClassUtil.nonNullState((Object)area.getGuardPattern());
    }

    public static @NonNull Iterable<@NonNull Assignment> getOwnedAssignments(@NonNull BottomPattern bottomPattern) {
        return ClassUtil.nullFree(bottomPattern.getAssignment());
    }

    public static @NonNull Iterable<@NonNull CoreDomain> getOwnedDomains(@NonNull Mapping mapping) {
        return Iterables.filter((Iterable)ClassUtil.nullFree((EList)mapping.getDomain()), CoreDomain.class);
    }

    public static @NonNull Iterable<@NonNull RealizedVariable> getOwnedRealizedVariables(@NonNull BottomPattern bottomPattern) {
        return ClassUtil.nullFree(bottomPattern.getRealizedVariable());
    }

    public static @NonNull Iterable<@NonNull Variable> getOwnedVariables(@NonNull CorePattern corePattern) {
        return ClassUtil.nullFree(corePattern.getVariable());
    }

    public static @NonNull OCLExpression getSlotExpression(@NonNull NavigationAssignment asNavigationAssignment) {
        return (OCLExpression)ClassUtil.nonNullState((Object)asNavigationAssignment.getSlotExpression());
    }

    public static @NonNull Property getTargetProperty(@NonNull NavigationAssignment asNavigationAssignment) {
        if (asNavigationAssignment instanceof PropertyAssignment) {
            return (Property)ClassUtil.nonNullState((Object)((PropertyAssignment)asNavigationAssignment).getTargetProperty());
        }
        if (asNavigationAssignment instanceof OppositePropertyAssignment) {
            Property referredProperty = (Property)ClassUtil.nonNullState((Object)((OppositePropertyAssignment)asNavigationAssignment).getTargetProperty());
            if (referredProperty.eIsProxy()) {
                throw new IllegalStateException("Unresolved target property proxy '" + EcoreUtil.getURI((EObject)referredProperty) + "' at '" + EcoreUtil.getURI((EObject)asNavigationAssignment) + "'");
            }
            return (Property)ClassUtil.nonNullState((Object)referredProperty.getOpposite());
        }
        throw new UnsupportedOperationException("Unsupported " + asNavigationAssignment.eClass().getName());
    }

    public static @NonNull Variable getTargetVariable(@NonNull VariableAssignment variableAssignment) {
        return (Variable)ClassUtil.nonNullState((Object)variableAssignment.getTargetVariable());
    }

    public static @NonNull OCLExpression getValue(@NonNull Assignment asAssignment) {
        return (OCLExpression)ClassUtil.nonNullState((Object)asAssignment.getValue());
    }

    public static @NonNull Transformation loadTransformation(@NonNull QVTbaseEnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = environmentFactory.setCreateStrategy(QVTcEnvironmentFactory.CREATE_STRATEGY);
        try {
            Transformation transformation = QVTcoreUtil.loadTransformation(CoreModel.class, (EnvironmentFactory)environmentFactory, (URI)transformationURI, (boolean)keepDebug);
            return transformation;
        }
        finally {
            environmentFactory.setCreateStrategy(savedStrategy);
        }
    }

    public static @NonNull ASResource loadTransformations(@NonNull QVTbaseEnvironmentFactory environmentFactory, @NonNull URI transformationURI, boolean keepDebug) throws IOException {
        QVTbaseEnvironmentFactory.CreateStrategy savedStrategy = environmentFactory.setCreateStrategy(QVTcEnvironmentFactory.CREATE_STRATEGY);
        try {
            ASResource asResource = QVTcoreUtil.loadTransformations(CoreModel.class, (EnvironmentFactory)environmentFactory, (URI)transformationURI, (boolean)keepDebug);
            List<@NonNull TypedModel> missingIsTraces = QVTcoreUtil.rewriteMissingTypedModelIsTrace((Resource)asResource);
            if (missingIsTraces != null) {
                System.err.println("TypedModel.isTrace fixed up for '" + transformationURI + "'");
            }
            ASResource aSResource = asResource;
            return aSResource;
        }
        finally {
            environmentFactory.setCreateStrategy(savedStrategy);
        }
    }

    public static @Nullable List<@NonNull TypedModel> rewriteMissingTypedModelIsTrace(@NonNull Resource asResource) {
        ArrayList<@NonNull TypedModel> missingImplicits = null;
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            TypedModel typedModel;
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof TypedModel) || (typedModel = (TypedModel)eObject).getName() != null || typedModel.isIsTrace()) continue;
            if (missingImplicits == null) {
                missingImplicits = new ArrayList<TypedModel>();
            }
            missingImplicits.add(typedModel);
            typedModel.setIsTrace(true);
        }
        return missingImplicits;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void sortPatternVariables(@NonNull List<@NonNull Variable> variables) {
        if (variables.size() > 1) {
            HashMap<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs = new HashMap<Variable, List<VariableDeclaration>>();
            for (Variable variable : variables) {
                def2refs.put(variable, null);
            }
            for (Variable variable : variables) {
                ArrayList<VariableDeclaration> refs = null;
                OCLExpression initExpression = variable.getOwnedInit();
                if (initExpression == null) continue;
                for (EObject eObject : new TreeIterable((EObject)initExpression, true)) {
                    if (!(eObject instanceof VariableExp)) continue;
                    VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                    assert (referredVariable != null);
                    if (!def2refs.containsKey(referredVariable)) continue;
                    if (refs == null) {
                        refs = new ArrayList<VariableDeclaration>();
                        def2refs.put(variable, refs);
                    }
                    if (refs.contains(referredVariable)) continue;
                    refs.add(referredVariable);
                }
            }
            boolean changed = true;
            while (changed) {
                changed = false;
                for (Variable variable : def2refs.keySet()) {
                    @NonNull List refs = (List)def2refs.get(variable);
                    if (refs == null) continue;
                    int i = 0;
                    while (i < refs.size()) {
                        VariableDeclaration ref = (VariableDeclaration)refs.get(i);
                        @NonNull List refRefs = (List)def2refs.get(ref);
                        if (refRefs != null) {
                            for (VariableDeclaration refRef : refRefs) {
                                if (refs.contains(refRef)) continue;
                                refs.add(refRef);
                                changed = true;
                            }
                        }
                        ++i;
                    }
                }
            }
            ClassUtil.sort(variables, (Comparator)new PatternVariableComparator(def2refs));
        }
    }

    public static class Internal
    extends QVTbaseUtil.Internal {
        public static @NonNull List<@NonNull Assignment> getOwnedAssignmentsList(@NonNull BottomPattern mBottomPattern) {
            return ClassUtil.nullFree(mBottomPattern.getAssignment());
        }
    }

    protected static class PatternVariableComparator
    implements Comparator<Variable> {
        private final @NonNull Map<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs;

        protected PatternVariableComparator(@NonNull Map<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs) {
            this.def2refs = def2refs;
        }

        @Override
        public int compare(@NonNull Variable o1, @NonNull Variable o2) {
            int s2;
            List<@NonNull VariableDeclaration> l1 = this.def2refs.get(o1);
            List<@NonNull VariableDeclaration> l2 = this.def2refs.get(o2);
            int s1 = l1 != null ? l1.size() : 0;
            int n = s2 = l2 != null ? l2.size() : 0;
            if (s1 != s2) {
                return s1 - s2;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

