/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.VariableFinder;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEnvironmentFactory;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironment;
import org.eclipse.ocl.examples.debug.vm.evaluator.IVMEvaluationEnvironmentExtension;
import org.eclipse.ocl.examples.debug.vm.utils.ASTBindingHelper;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.examples.debug.vm.utils.VMStackTraceBuilder;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.debug.core.QVTiDebugCore;
import org.eclipse.qvtd.debug.evaluator.IQVTiVMEvaluationEnvironment;
import org.eclipse.qvtd.debug.evaluator.QVTiVMModelManager;
import org.eclipse.qvtd.debug.vm.QVTiVariableFinder;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiRootEvaluationEnvironment;

public class QVTiVMRootEvaluationEnvironment
extends QVTiRootEvaluationEnvironment
implements IQVTiVMEvaluationEnvironment,
IVMEvaluationEnvironmentExtension {
    @NonNull
    protected final IVMEnvironmentFactory vmEnvironmentFactory;
    private List<Runnable> myDeferredTasks;
    private boolean myIsDeferedExecution;
    @NonNull
    private Element myCurrentIP;
    private final long id;
    @NonNull
    private final Variable pcVariable;
    @NonNull
    private final Stack<IVMEvaluationEnvironment.StepperEntry> stepperStack = new Stack();

    public QVTiVMRootEvaluationEnvironment(@NonNull IVMEnvironmentFactory vmEnvironmentFactory, @NonNull Transformation executableObject, @NonNull QVTiModelManager modelManager, long id) {
        super(vmEnvironmentFactory.getEnvironmentFactory(), executableObject, modelManager);
        this.vmEnvironmentFactory = vmEnvironmentFactory;
        this.myCurrentIP = executableObject;
        this.id = id;
        this.pcVariable = (Variable)ClassUtil.nonNullEMF((Object)PivotFactory.eINSTANCE.createVariable());
        this.pcVariable.setName("$pc");
        String typeName = (String)ClassUtil.nonNullEMF((Object)PivotPackage.Literals.NAMED_ELEMENT.getName());
        this.pcVariable.setType((Type)this.environmentFactory.getMetamodelManager().getASClass(typeName));
    }

    @Override
    @NonNull
    public IQVTiVMEvaluationEnvironment createClonedEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public VariableFinder createVariableFinder(boolean isStoreValues) {
        return new QVTiVariableFinder(this, isStoreValues);
    }

    @Override
    @NonNull
    public Element getCurrentIP() {
        return this.myCurrentIP;
    }

    @Override
    @NonNull
    public UnitLocation getCurrentLocation() {
        int startPosition = ASTBindingHelper.getStartPosition((Element)this.myCurrentIP);
        int endPosition = ASTBindingHelper.getEndPosition((Element)this.myCurrentIP);
        return new UnitLocation(startPosition, endPosition, (IVMEvaluationEnvironment)this, this.myCurrentIP);
    }

    @NonNull
    public QVTiDebugCore getDebugCore() {
        return QVTiDebugCore.INSTANCE;
    }

    @NonNull
    public Transformation getDebuggableElement() {
        return this.getTransformation();
    }

    public int getDepth() {
        return 1;
    }

    public long getID() {
        return this.id;
    }

    @Override
    @NonNull
    public QVTiVMModelManager getModelManager() {
        return (QVTiVMModelManager)super.getModelManager();
    }

    @Deprecated
    @NonNull
    public Map<String, Resource> getModelParameterVariables() {
        return new HashMap<String, Resource>();
    }

    @NonNull
    public NamedElement getOperation() {
        return this.getTransformation();
    }

    @NonNull
    public Variable getPCVariable() {
        return this.pcVariable;
    }

    @NonNull
    public QVTiRootEvaluationEnvironment getRootEvaluationEnvironment() {
        return this;
    }

    @NonNull
    public Stack<IVMEvaluationEnvironment.StepperEntry> getStepperStack() {
        return this.stepperStack;
    }

    @NonNull
    public IVMEnvironmentFactory getVMEnvironmentFactory() {
        return this.vmEnvironmentFactory;
    }

    @Override
    @Nullable
    public QVTiVMRootEvaluationEnvironment getVMParentEvaluationEnvironment() {
        return (QVTiVMRootEvaluationEnvironment)super.getParentEvaluationEnvironment();
    }

    @Override
    @NonNull
    public QVTiVMRootEvaluationEnvironment getVMRootEvaluationEnvironment() {
        return this;
    }

    public boolean isDeferredExecution() {
        return this.myIsDeferedExecution;
    }

    @Override
    public void processDeferredTasks() {
        if (this.myDeferredTasks != null) {
            try {
                this.myIsDeferedExecution = true;
                ArrayList<Runnable> tasksCopy = new ArrayList<Runnable>(this.myDeferredTasks);
                for (Runnable task : tasksCopy) {
                    task.run();
                }
            }
            finally {
                this.myIsDeferedExecution = false;
            }
        }
    }

    protected void saveThrownException(@NonNull VMRuntimeException exception) {
    }

    @Override
    @NonNull
    public Element setCurrentIP(@NonNull Element element) {
        Element prevValue = this.myCurrentIP;
        this.myCurrentIP = element;
        return prevValue;
    }

    public void setException(@NonNull VMRuntimeException exception) {
        this.saveThrownException(exception);
    }

    @Override
    public void throwVMException(@NonNull VMRuntimeException exception) throws VMRuntimeException {
        try {
            this.saveThrownException(exception);
            exception.setStackVMTrace(new VMStackTraceBuilder((IVMEvaluationEnvironment)this).buildStackTrace());
        }
        catch (Exception e) {
            this.getDebugCore().error("Failed to build VM stack trace", e);
        }
        throw exception;
    }
}

