/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.actions.OpenFileInSystemEditorAction;
import org.eclipse.team.internal.ui.synchronize.actions.OpenInCompareAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizePageSite;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.keys.IBindingService;

public class OpenWithActionGroup
extends ActionGroup {
    private OpenFileInSystemEditorAction openFileAction;
    private OpenInCompareAction openInCompareAction;
    private final boolean includeOpenInCompare;
    private final ISynchronizePageConfiguration configuration;

    public OpenWithActionGroup(ISynchronizePageConfiguration configuration, boolean includeOpenInCompare) {
        this.configuration = configuration;
        this.includeOpenInCompare = includeOpenInCompare;
        this.makeActions();
    }

    protected void makeActions() {
        IWorkbenchSite ws = this.getSite().getWorkbenchSite();
        if (ws != null) {
            this.openFileAction = new OpenFileInSystemEditorAction(ws.getPage());
            if (this.includeOpenInCompare) {
                this.openInCompareAction = new OpenInCompareAction(this.configuration);
            }
        }
    }

    private ISynchronizeParticipant getParticipant() {
        return this.configuration.getParticipant();
    }

    private ISynchronizePageSite getSite() {
        return this.configuration.getSite();
    }

    public void fillContextMenu(IMenuManager menu, String groupId) {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !this.hasFileMenu(menu)) {
            this.fillOpenWithMenu(menu, groupId, (IStructuredSelection)selection);
        }
    }

    private boolean hasFileMenu(IMenuManager menu) {
        return menu.find(this.openFileAction.getId()) != null || menu.find("org.eclipse.ui.navigate.showInQuickMenu") != null;
    }

    private void fillOpenWithMenu(IMenuManager menu, String groupId, IStructuredSelection selection) {
        IWorkbenchSite ws;
        IResource resource;
        if (selection == null || selection.size() < 1) {
            return;
        }
        Object[] elements = selection.toArray();
        IResource[] resources = Utils.getResources(elements);
        if (resources.length == 0) {
            ISynchronizeParticipant participant;
            if (this.openInCompareAction != null && elements.length > 0 && (participant = this.getParticipant()) instanceof ModelSynchronizeParticipant) {
                ModelSynchronizeParticipant msp = (ModelSynchronizeParticipant)participant;
                boolean allElementsHaveCompareInput = true;
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (!msp.hasCompareInputFor(element)) {
                        allElementsHaveCompareInput = false;
                        break;
                    }
                    ++n2;
                }
                if (allElementsHaveCompareInput) {
                    menu.appendToGroup(groupId, (IAction)this.openInCompareAction);
                }
            }
            return;
        }
        if (elements.length != resources.length) {
            return;
        }
        boolean allFiles = true;
        IResource[] iResourceArray = resources;
        int element = resources.length;
        int allElementsHaveCompareInput = 0;
        while (allElementsHaveCompareInput < element) {
            resource = iResourceArray[allElementsHaveCompareInput];
            if (resource.getType() != 1) {
                allFiles = false;
                break;
            }
            ++allElementsHaveCompareInput;
        }
        if (allFiles && this.openInCompareAction != null) {
            menu.appendToGroup(groupId, (IAction)this.openInCompareAction);
        }
        iResourceArray = resources;
        element = resources.length;
        allElementsHaveCompareInput = 0;
        while (allElementsHaveCompareInput < element) {
            resource = iResourceArray[allElementsHaveCompareInput];
            if (!resource.exists()) {
                return;
            }
            ++allElementsHaveCompareInput;
        }
        if (allFiles) {
            if (this.openFileAction != null) {
                this.openFileAction.selectionChanged(selection);
                menu.appendToGroup(groupId, (IAction)this.openFileAction);
            }
            if (resources.length == 1 && (ws = this.getSite().getWorkbenchSite()) != null) {
                MenuManager openWithSubmenu = new MenuManager(TeamUIMessages.OpenWithActionGroup_0);
                openWithSubmenu.add((IContributionItem)new OpenWithMenu(ws.getPage(), (IAdaptable)resources[0]));
                menu.appendToGroup(groupId, (IContributionItem)openWithSubmenu);
            }
        }
        if ((ws = this.getSite().getWorkbenchSite()) != null) {
            MenuManager showInSubmenu = new MenuManager(OpenWithActionGroup.getShowInMenuLabel(), "org.eclipse.ui.navigate.showInQuickMenu");
            IContributionItem showInMenu = ContributionItemFactory.VIEWS_SHOW_IN.create(ws.getWorkbenchWindow());
            showInSubmenu.add(showInMenu);
            menu.appendToGroup(groupId, (IContributionItem)showInSubmenu);
        }
    }

    private static String getShowInMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu");
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)TeamUIMessages.SaveableCompareEditorInput_0, (Object)keyBinding);
    }

    public void openInCompareEditor() {
        if (this.openInCompareAction != null) {
            this.openInCompareAction.run();
        }
    }
}

