/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.motioncalculator.json.http;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.lsat.motioncalculator.json.JsonRequest;
import org.eclipse.lsat.motioncalculator.json.JsonResponse;
import org.eclipse.lsat.motioncalculator.json.JsonSerializer;
import org.eclipse.lsat.motioncalculator.json.JsonServer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.prefs.Preferences;

public class HttpJsonServer
implements JsonServer {
    private static final int MAX_CACHE_SIZE = 1000;
    private static final String CONSOLE_NAME = "Console";
    private static final Preferences PREFERENCES = InstanceScope.INSTANCE.getNode("org.eclipse.lsat.motioncalculator.json.http");
    private static final String ARROW_LEFT = "\u2190 ";
    private static final String ARROW_RIGHT = "\u2192 ";
    private static Boolean write;
    private static HttpJsonServer instance;
    private final HttpClient httpClient;
    private final String serverUrl;
    private final LinkedHashMap<String, String> cache = new LinkedHashMap();
    private MessageConsole console;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpJsonServer getServer() {
        Preferences preferences = PREFERENCES;
        synchronized (preferences) {
            boolean writeMessages = PREFERENCES.getBoolean("WRITE_MESSAGES", false);
            Object href = PREFERENCES.get("HREF", null);
            if (href != null && !((String)href).toLowerCase().matches("https?://.*")) {
                href = "http://" + (String)href;
            }
            if (write == null || instance == null || href != HttpJsonServer.instance.serverUrl || writeMessages != write) {
                write = writeMessages;
                instance = new HttpJsonServer((String)href, writeMessages);
            }
        }
        return instance;
    }

    public HttpJsonServer(String serverUrl, boolean write) {
        this.serverUrl = serverUrl;
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
        if (write) {
            this.console = HttpJsonServer.getConsole();
        }
    }

    private static MessageConsole getConsole() {
        IConsole[] existingConsoles;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        IConsole[] iConsoleArray = existingConsoles = consoleManager.getConsoles();
        int n = existingConsoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (CONSOLE_NAME.equals(console.getName())) {
                return (MessageConsole)console;
            }
            ++n2;
        }
        MessageConsole newConsole = new MessageConsole(CONSOLE_NAME, null);
        consoleManager.addConsoles(new IConsole[]{newConsole});
        consoleManager.showConsoleView((IConsole)newConsole);
        return newConsole;
    }

    public String request(String content) {
        String cachedResponse = (String)this.cache.remove(content);
        if (cachedResponse != null) {
            this.cache.put(content, cachedResponse);
            return cachedResponse;
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.serverUrl)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(content, StandardCharsets.UTF_8)).build();
            this.logRequest(content);
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            String result = response.body();
            this.cache.put(content, result);
            if (this.cache.size() > 1000) {
                this.cache.entrySet().remove(this.cache.firstEntry());
            }
            this.logResponse(result);
            return result;
        }
        catch (IOException | InterruptedException e) {
            return this.error(content, e.getMessage(), e);
        }
    }

    private void logRequest(String request) {
        this.log(ARROW_RIGHT, request);
    }

    private void logResponse(String response) {
        if (this.console != null) {
            try {
                JsonResponse r = JsonSerializer.createResponse((String)response);
                response = JsonSerializer.toJson((JsonResponse)r);
                if (response == null || response.isEmpty()) {
                    response = "{}";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log(ARROW_LEFT, response);
        }
    }

    private void log(String ... strs) {
        if (this.console != null) {
            Display.getDefault().asyncExec(() -> {
                MessageConsoleStream stream = this.console.newMessageStream();
                String[] stringArray2 = strs;
                int n = strs.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray2[n2];
                    stream.print(str);
                    ++n2;
                }
                stream.println();
                try {
                    stream.flush();
                    stream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private String error(String request, String message, Throwable error) {
        JsonRequest jsonRequest = JsonSerializer.createRequest((String)request);
        JsonResponse jsonResponse = new JsonResponse();
        jsonResponse.setRequestType(jsonRequest.getRequestType());
        jsonResponse.setErrorMessage(message + " " + this.serverUrl + (String)(error != null ? " error: " + error.getMessage() : ""));
        String response = JsonSerializer.toJson((JsonResponse)jsonResponse);
        return response;
    }
}

