/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractPopupBarTool
extends TargetingTool
implements DragTracker {
    private EditPart myHostEditPart = null;
    private IElementType myElementType = null;
    private CreateRequest myRequest = null;

    public AbstractPopupBarTool(EditPart epHost, IElementType elementType) {
        this.myElementType = elementType;
        this.myHostEditPart = epHost;
        this.lockTargetEditPart(epHost);
    }

    public AbstractPopupBarTool(EditPart epHost, CreateRequest theRequest) {
        this.myHostEditPart = epHost;
        this.myRequest = theRequest;
        this.lockTargetEditPart(epHost);
    }

    protected abstract Request createTargetRequest();

    protected abstract Command getCommand();

    public boolean isCommandEnabled() {
        Command cmd = this.getCommand();
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void commitDrag() {
    }

    protected boolean handleButtonDown(int button) {
        this.setCurrentCommand(this.getCommand());
        return super.handleButtonDown(button);
    }

    protected boolean handleButtonUp(int button) {
        this.performCreation(button);
        return true;
    }

    private void performCreation(int button) {
        EditPartViewer viewer = this.getCurrentViewer();
        Command c = this.getCurrentCommand();
        this.executeCurrentCommand();
        ArrayList<EditPart> editparts = new ArrayList<EditPart>(1);
        Collection newObjects = DiagramCommandStack.getReturnValues(c);
        for (Object o : newObjects) {
            EditPart editpart = null;
            if (o instanceof IAdaptable) {
                IAdaptable adapter = (IAdaptable)o;
                View view = (View)adapter.getAdapter(View.class);
                if (view != null) {
                    editpart = (EditPart)viewer.getEditPartRegistry().get(view);
                }
            } else if (o instanceof EObject) {
                IGraphicalEditPart host = (IGraphicalEditPart)this.myHostEditPart;
                editpart = host.findEditPart((EditPart)host, (EObject)o);
            }
            if (editpart == null) continue;
            editparts.add(editpart);
        }
        this.selectAddedObject(viewer, editparts);
    }

    protected void selectAddedObject(final EditPartViewer viewer, final List editparts) {
        if (editparts.isEmpty()) {
            return;
        }
        boolean selectable = false;
        for (EditPart editpart : editparts) {
            if (!editpart.isSelectable()) continue;
            selectable = true;
            break;
        }
        if (selectable) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    viewer.setSelection((ISelection)new StructuredSelection(editparts));
                    EditPart editpart = (EditPart)editparts.get(0);
                    editpart.performRequest(new Request((Object)"direct edit"));
                }
            });
        }
    }

    protected void unlockTargetEditPart() {
    }

    protected IElementType getElementType() {
        return this.myElementType;
    }

    protected void setElementKind(IElementType elementType) {
        this.myElementType = elementType;
    }

    protected String getCommandName() {
        return "create child";
    }

    protected String getDebugName() {
        return "Popup Bar Creation Tool";
    }

    protected EditPart getHost() {
        return this.myHostEditPart;
    }

    protected PreferencesHint getPreferencesHint() {
        PreferencesHint preferencesHint = null;
        if (this.myHostEditPart != null) {
            preferencesHint = ((IGraphicalEditPart)this.myHostEditPart).getDiagramPreferencesHint();
        }
        return preferencesHint;
    }

    protected CreateRequest getCreateRequest() {
        return this.myRequest;
    }
}

