/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.ExecutionDiagnosticImpl;
import org.eclipse.m2m.internal.qvt.oml.Messages;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.Transformation;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;

public class CstTransformation
implements Transformation {
    private URI fURI;
    private EPackage.Registry fPackageRegistry;
    private CompiledUnit fCompiledUnit;
    private ExecutionDiagnostic fLoadDiagnostic;
    private OperationalTransformation fTransformation;
    private QVTOCompiler fCompiler;

    public CstTransformation(URI uri) {
        this(uri, EPackage.Registry.INSTANCE);
    }

    public CstTransformation(URI uri, EPackage.Registry packageRegistry) {
        if (uri == null) {
            throw new IllegalArgumentException("null transformation URI");
        }
        this.fURI = uri;
        this.fPackageRegistry = packageRegistry == null ? EPackage.Registry.INSTANCE : packageRegistry;
    }

    protected CompiledUnit getCompiledUnit(IProgressMonitor monitor) throws MdaException {
        if ("qvtox".equals(this.fURI.fileExtension())) {
            return new CompiledUnit(this.fURI, this.getCompiler().getResourceSet());
        }
        UnitProxy proxy = UnitResolverFactory.Registry.INSTANCE.getUnit(this.fURI);
        if (proxy == null) {
            this.fLoadDiagnostic = new ExecutionDiagnosticImpl(4, 200, NLS.bind(Messages.UnitNotFoundError, this.fURI));
            return null;
        }
        QVTOCompiler compiler = this.getCompiler();
        return compiler.compile(proxy, null, monitor);
    }

    private QVTOCompiler getCompiler() {
        if (this.fCompiler == null) {
            this.fCompiler = this.createCompiler();
        }
        return this.fCompiler;
    }

    protected QVTOCompiler createCompiler() {
        if (this.fPackageRegistry == null) {
            return new QVTOCompiler();
        }
        return new QVTOCompiler(this.fPackageRegistry);
    }

    private void doLoad(IProgressMonitor monitor) {
        this.fLoadDiagnostic = ExecutionDiagnosticImpl.createOkInstance();
        try {
            this.fCompiledUnit = this.getCompiledUnit(monitor);
        }
        catch (MdaException e) {
            this.fLoadDiagnostic = new ExecutionDiagnosticImpl(4, 200, NLS.bind(Messages.FailedToCompileUnitError, this.fURI));
            this.fLoadDiagnostic.merge(BasicDiagnostic.toDiagnostic((IStatus)e.getStatus()));
        }
        if (this.fCompiledUnit != null && EmfUtilPlugin.isSuccess((Diagnostic)this.fLoadDiagnostic)) {
            ExecutionDiagnostic compilationDiagnostic = CstTransformation.createCompilationDiagnostic(this.fCompiledUnit);
            if (!EmfUtilPlugin.isSuccess((Diagnostic)compilationDiagnostic)) {
                compilationDiagnostic.addAll(this.fLoadDiagnostic);
                this.fLoadDiagnostic = compilationDiagnostic;
                return;
            }
            this.fLoadDiagnostic.addAll(compilationDiagnostic);
            this.fTransformation = this.doGetTransformation();
            if (this.fTransformation == null) {
                ExecutionDiagnosticImpl transformationDiagnostic = new ExecutionDiagnosticImpl(4, 200, NLS.bind(Messages.NotTransformationInUnitError, this.fURI));
                transformationDiagnostic.addAll(this.fLoadDiagnostic);
                this.fLoadDiagnostic = transformationDiagnostic;
                return;
            }
            ExecutionDiagnostic executabilityDiagnostic = CstTransformation.checkIsExecutable(this.fTransformation);
            if (EmfUtilPlugin.isSuccess((Diagnostic)executabilityDiagnostic)) {
                this.fLoadDiagnostic.addAll(executabilityDiagnostic);
            } else {
                executabilityDiagnostic.addAll(this.fLoadDiagnostic);
                this.fLoadDiagnostic = executabilityDiagnostic;
            }
        }
    }

    private OperationalTransformation doGetTransformation() {
        if (this.fCompiledUnit == null) {
            return null;
        }
        List<Module> allModules = this.fCompiledUnit.getModules();
        for (Module module : allModules) {
            if (!(module instanceof OperationalTransformation)) continue;
            return (OperationalTransformation)module;
        }
        return null;
    }

    private static ExecutionDiagnostic createCompilationDiagnostic(CompiledUnit compiledUnit) {
        ExecutionDiagnosticImpl mainDiagnostic = ExecutionDiagnosticImpl.createOkInstance();
        if (!compiledUnit.getErrors().isEmpty()) {
            URI uRI = compiledUnit.getURI();
            mainDiagnostic = new ExecutionDiagnosticImpl(4, 130, NLS.bind(Messages.CompilationErrorsFoundInUnit, uRI.toString()));
            for (Diagnostic diagnostic : compiledUnit.getErrors()) {
                mainDiagnostic.add(diagnostic);
            }
        }
        for (Diagnostic diagnostic : compiledUnit.getWarnings()) {
            mainDiagnostic.add(diagnostic);
        }
        return mainDiagnostic;
    }

    @Override
    public OperationalTransformation getTransformation(IProgressMonitor monitor) {
        this.loadTransformation(monitor);
        return this.fTransformation;
    }

    private static ExecutionDiagnostic checkIsExecutable(OperationalTransformation transformation) {
        if (transformation.isIsBlackbox()) {
            return ExecutionDiagnosticImpl.createOkInstance();
        }
        EList operations = transformation.getEOperations();
        for (EOperation oper : operations) {
            if (!(oper instanceof ImperativeOperation) || !"main".equals(oper.getName())) continue;
            return ExecutionDiagnosticImpl.createOkInstance();
        }
        return new ExecutionDiagnosticImpl(4, 130, NLS.bind(Messages.NoTransformationEntryPointError, transformation.getName()));
    }

    private Diagnostic loadTransformation(IProgressMonitor monitor) {
        try {
            if (this.fLoadDiagnostic == null) {
                this.doLoad(monitor);
            }
            ExecutionDiagnostic executionDiagnostic = this.fLoadDiagnostic;
            return executionDiagnostic;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ExecutionDiagnostic getDiagnostic() {
        this.loadTransformation((IProgressMonitor)new NullProgressMonitor());
        return this.fLoadDiagnostic;
    }

    @Override
    public URI getURI() {
        return this.fURI;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.getUnit().getResourceSet();
    }

    @Override
    public CompiledUnit getUnit() {
        this.loadTransformation((IProgressMonitor)new NullProgressMonitor());
        return this.fCompiledUnit;
    }

    @Override
    public void cleanup() {
        if (this.getResourceSet() != null) {
            EmfUtil.cleanupResourceSet((ResourceSet)this.getResourceSet());
        }
        this.getCompiler().cleanup();
    }
}

