/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.javascript;

import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.SvgCodeGen;
import org.eclipse.escet.cif.codegen.javascript.JavaScriptCodeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgFile;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEvent;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIf;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIfEntry;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventSingle;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.svg.SvgUtils;
import org.w3c.dom.Document;

public class JavaScriptSvgCodeGen
extends SvgCodeGen {
    CodeBox codeSvgContent;
    CodeBox codeSvgToggles;
    CodeBox codeCopyApply;
    CodeBox codeMoveApply;
    CodeBox codeInClickHandlers;
    CodeBox codeInEventSetters;
    CodeBox codeInSetup;
    CodeBox codeInCss;
    CodeBox codeOutDeclarations;
    CodeBox codeOutAssignments;
    CodeBox codeOutApply;

    void genCodeCifSvg(CodeContext ctxt, String cifSpecFileDir, List<IoDecl> svgDecls, Map<Event, Integer> eventMap, Map<SvgIn, Event> environmentEvents) {
        Map svgPathsAbsToNormRel = Maps.map();
        Map svgPathsRelToAbs = Maps.map();
        for (IoDecl decl : svgDecls) {
            SvgFile file = null;
            if (decl instanceof SvgCopy) {
                SvgCopy svgCopy = (SvgCopy)decl;
                file = svgCopy.getSvgFile();
            } else if (decl instanceof SvgMove) {
                SvgMove svgMove = (SvgMove)decl;
                file = svgMove.getSvgFile();
            } else if (decl instanceof SvgIn) {
                SvgIn svgIn = (SvgIn)decl;
                file = svgIn.getSvgFile();
            } else if (decl instanceof SvgOut) {
                SvgOut svgOut = (SvgOut)decl;
                file = svgOut.getSvgFile();
            } else {
                throw new AssertionError((Object)("Unexpected CIF/SVG declaration: " + String.valueOf(decl)));
            }
            String svgRelPath = file.getPath();
            String svgAbsPath = Paths.resolve((String)svgRelPath, (String)cifSpecFileDir);
            String svgNormRelPath = Paths.getRelativePath((String)svgAbsPath, (String)cifSpecFileDir);
            svgPathsAbsToNormRel.put(svgAbsPath, svgNormRelPath);
            svgPathsRelToAbs.put(svgRelPath, svgAbsPath);
        }
        Map svgAbsPathsToWrapperElemIds = Maps.map();
        Map svgOutElemQueriesToFields = Maps.map();
        AtomicInteger nextSvgInId = new AtomicInteger();
        int svgImageNumber = 0;
        int declsProcessed = 0;
        for (Map.Entry entry : svgPathsAbsToNormRel.entrySet()) {
            String svgFileNormRelPath;
            String svgWrapElemId;
            String absSvgPath;
            String svgPath;
            String svgWrapElemId2;
            String svgAbsPath = (String)entry.getKey();
            String svgNormRelPath = (String)entry.getValue();
            ++svgImageNumber;
            Document document = SvgUtils.loadSvgFile((String)svgAbsPath);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            StringWriter svgContentWriter = new StringWriter();
            try {
                Transformer transformer = transFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(document.getDocumentElement()), new StreamResult(svgContentWriter));
            }
            catch (TransformerException e) {
                throw new RuntimeException("Failed to transform SVG document to text: " + svgNormRelPath, e);
            }
            String svgContent = svgContentWriter.toString();
            String svgWrapperElementId = Strings.fmt((String)"cif-svg-wrapper-%d", (Object[])new Object[]{svgImageNumber});
            svgAbsPathsToWrapperElemIds.put(svgAbsPath, svgWrapperElementId);
            this.codeSvgContent.add("<div id=\"%s\" class=\"svg-visible\">%s</div>", new Object[]{svgWrapperElementId, svgContent});
            if (svgPathsAbsToNormRel.size() > 1) {
                this.codeSvgToggles.add("<input type=\"checkbox\" onclick=\"toggleSVG('%s');\" checked>Image %d</input>", new Object[]{svgWrapperElementId, svgImageNumber});
            }
            SvgCodeGen.CifSvgDecls imgSvgDecls = JavaScriptSvgCodeGen.filterAndGroup(svgDecls, svgAbsPath, svgPathsRelToAbs);
            declsProcessed += imgSvgDecls.size();
            if (imgSvgDecls.svgOuts.isEmpty() && imgSvgDecls.svgIns.isEmpty()) {
                OutputProvider.warn((String)"SVG file \"%s\" has no CIF/SVG input/output mappings that apply to it.", (Object[])new Object[]{svgNormRelPath});
            }
            for (SvgCopy svgCopy : imgSvgDecls.svgCopies) {
                svgWrapElemId2 = (String)svgAbsPathsToWrapperElemIds.get(svgPathsRelToAbs.get(svgCopy.getSvgFile().getPath()));
                this.gencodeSvgCopy(svgCopy, svgWrapElemId2, ctxt);
            }
            for (SvgMove svgMove : imgSvgDecls.svgMoves) {
                svgWrapElemId2 = (String)svgAbsPathsToWrapperElemIds.get(svgPathsRelToAbs.get(svgMove.getSvgFile().getPath()));
                this.gencodeSvgMove(svgMove, svgWrapElemId2, ctxt);
            }
            for (SvgIn svgIn : imgSvgDecls.svgIns) {
                svgPath = svgIn.getSvgFile().getPath();
                absSvgPath = (String)svgPathsRelToAbs.get(svgPath);
                svgWrapElemId = (String)svgAbsPathsToWrapperElemIds.get(absSvgPath);
                svgFileNormRelPath = (String)svgPathsAbsToNormRel.get(absSvgPath);
                this.gencodeSvgIn(svgIn, svgWrapElemId, svgFileNormRelPath, nextSvgInId, eventMap, environmentEvents, ctxt);
            }
            for (SvgOut svgOut : imgSvgDecls.svgOuts) {
                svgPath = svgOut.getSvgFile().getPath();
                absSvgPath = (String)svgPathsRelToAbs.get(svgPath);
                svgWrapElemId = (String)svgAbsPathsToWrapperElemIds.get(absSvgPath);
                svgFileNormRelPath = (String)svgPathsAbsToNormRel.get(absSvgPath);
                this.gencodeSvgOut(svgOut, svgWrapElemId, svgOutElemQueriesToFields, svgFileNormRelPath, ctxt);
            }
        }
        Assert.areEqual((Object)declsProcessed, (Object)svgDecls.size());
    }

    private void gencodeSvgCopy(SvgCopy svgCopy, String svgWrapElemId, CodeContext ctxt) {
        String copyId = JavaScriptSvgCodeGen.evalSvgStringExpr(svgCopy.getId());
        String pre = svgCopy.getPre() == null ? "" : JavaScriptSvgCodeGen.evalSvgStringExpr(svgCopy.getPre());
        String post = svgCopy.getPost() == null ? "" : JavaScriptSvgCodeGen.evalSvgStringExpr(svgCopy.getPost());
        this.codeCopyApply.add("applySvgCopy(%s, %s, %s, %s);", new Object[]{Strings.stringToJava((String)svgWrapElemId), Strings.stringToJava((String)copyId), Strings.stringToJava((String)pre), Strings.stringToJava((String)post)});
    }

    private void gencodeSvgMove(SvgMove svgMove, String svgWrapElemId, CodeContext ctxt) {
        String moveId = JavaScriptSvgCodeGen.evalSvgStringExpr(svgMove.getId());
        double x = JavaScriptSvgCodeGen.evalSvgNumberExpr(svgMove.getX());
        double y = JavaScriptSvgCodeGen.evalSvgNumberExpr(svgMove.getY());
        this.codeMoveApply.add("applySvgMove(%s, %s, %s, %s);", new Object[]{Strings.stringToJava((String)svgWrapElemId), Strings.stringToJava((String)moveId), x, y});
    }

    private void gencodeSvgOut(SvgOut svgOut, String svgWrapElemId, Map<String, String> svgOutElemQueriesToFields, String svgFileNormRelPath, CodeContext ctxt) {
        block14: {
            String fieldName;
            block12: {
                String outId = JavaScriptSvgCodeGen.evalSvgStringExpr(svgOut.getId());
                String querySelector = Strings.fmt((String)"#%s #%s", (Object[])new Object[]{JavaScriptCodeUtils.escapeCssIdentifier(svgWrapElemId), JavaScriptCodeUtils.escapeCssIdentifier(outId)});
                fieldName = svgOutElemQueriesToFields.get(querySelector);
                if (fieldName == null) {
                    fieldName = Strings.fmt((String)"outElem%d", (Object[])new Object[]{svgOutElemQueriesToFields.size()});
                    this.codeOutDeclarations.add(Strings.fmt((String)"%s;", (Object[])new Object[]{fieldName}));
                    this.codeOutAssignments.add("%s.%s = document.querySelector(%s);", new Object[]{ctxt.getPrefix(), fieldName, Strings.stringToJava((String)querySelector)});
                    svgOutElemQueriesToFields.put(querySelector, fieldName);
                }
                ExprCode exprCode = ctxt.exprToTarget(svgOut.getValue(), null);
                this.codeOutApply.add("var value;");
                this.codeOutApply.add("try {");
                this.codeOutApply.indent();
                this.codeOutApply.add((Box)exprCode.getCode());
                this.codeOutApply.add("value = %s;", new Object[]{exprCode.getData()});
                this.codeOutApply.dedent();
                this.codeOutApply.add("} catch (e) {");
                this.codeOutApply.indent();
                this.codeOutApply.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
                this.codeOutApply.indent();
                this.codeOutApply.add("e = new %sException(\"Failed to evaluate the value of the SVG output mapping with id \\\"%s\\\" in SVG file \\\"%s\\\".\", e);", new Object[]{ctxt.getPrefix(), outId, Strings.escape((String)svgFileNormRelPath)});
                this.codeOutApply.add("this.runtimeError(e);");
                this.codeOutApply.dedent();
                this.codeOutApply.add("}");
                this.codeOutApply.add("throw e;");
                this.codeOutApply.dedent();
                this.codeOutApply.add("}");
                if (svgOut.getAttr() == null) break block12;
                switch (svgOut.getAttr()) {
                    case "opacity": 
                    case "fill": 
                    case "visibility": {
                        this.codeOutApply.add("%s.%s.style.%s = value;", new Object[]{ctxt.getPrefix(), fieldName, svgOut.getAttr()});
                        break;
                    }
                    default: {
                        this.codeOutApply.add("%s.%s.setAttribute(%s, value);", new Object[]{ctxt.getPrefix(), fieldName, Strings.stringToJava((String)svgOut.getAttr())});
                        break;
                    }
                }
                break block14;
            }
            this.codeOutApply.add("if (%s.%s.hasChildNodes()) {", new Object[]{ctxt.getPrefix(), fieldName});
            this.codeOutApply.indent();
            this.codeOutApply.add("%s.%s.childNodes[0].textContent = value;", new Object[]{ctxt.getPrefix(), fieldName});
            this.codeOutApply.dedent();
            this.codeOutApply.add("} else {");
            this.codeOutApply.indent();
            this.codeOutApply.add("%s.%s.textContent = value;", new Object[]{ctxt.getPrefix(), fieldName});
            this.codeOutApply.dedent();
            this.codeOutApply.add("}");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gencodeSvgIn(SvgIn svgIn, String svgWrapElemId, String svgFileNormRelPath, AtomicInteger nextSvgInId, Map<Event, Integer> eventMap, Map<SvgIn, Event> environmentEvents, CodeContext ctxt) {
        int uniqueId = nextSvgInId.getAndIncrement();
        String inId = JavaScriptSvgCodeGen.evalSvgStringExpr(svgIn.getId());
        String querySelector = Strings.fmt((String)"#%s #%s", (Object[])new Object[]{JavaScriptCodeUtils.escapeCssIdentifier(svgWrapElemId), JavaScriptCodeUtils.escapeCssIdentifier(inId)});
        String clickEventHandlerName = Strings.fmt((String)"cif_svgin_%d_Click", (Object[])new Object[]{uniqueId});
        String eventSetterName = Strings.fmt((String)"cif_svgin_%d_EventSetter", (Object[])new Object[]{uniqueId});
        this.codeInSetup.add("var elem = document.querySelector(%s);", new Object[]{Strings.stringToJava((String)querySelector)});
        this.codeInSetup.add("elem.addEventListener(\"click\", %s.%s);", new Object[]{ctxt.getPrefix(), clickEventHandlerName});
        this.codeInSetup.add("elem.style.cursor = \"pointer\";");
        this.codeInCss.add("%s:hover { stroke-width: 1 !important; stroke: rgb(255, 0, 0) !important; }", new Object[]{querySelector});
        this.codeInCss.add("%s:hover > * { stroke-width: 1 !important; stroke: rgb(255, 0, 0) !important; }", new Object[]{querySelector});
        this.codeInClickHandlers.add();
        this.codeInClickHandlers.add("%s() { // %s", new Object[]{clickEventHandlerName, inId});
        this.codeInClickHandlers.indent();
        this.codeInClickHandlers.add("if (%s.playing) {", new Object[]{ctxt.getPrefix()});
        this.codeInClickHandlers.indent();
        this.codeInClickHandlers.add("%s.svgInQueue.push(%s.%s);", new Object[]{ctxt.getPrefix(), ctxt.getPrefix(), eventSetterName});
        this.codeInClickHandlers.dedent();
        this.codeInClickHandlers.add("}");
        this.codeInClickHandlers.dedent();
        this.codeInClickHandlers.add("}");
        this.codeInEventSetters.add();
        this.codeInEventSetters.add("%s() { // %s", new Object[]{eventSetterName, inId});
        this.codeInEventSetters.indent();
        this.codeInEventSetters.add("%s.svgInId = '%s';", new Object[]{ctxt.getPrefix(), inId});
        Assert.check((boolean)(svgIn.getEvent() == null ^ svgIn.getUpdates().isEmpty()));
        if (svgIn.getEvent() != null) {
            SvgInEvent svgInEvent = svgIn.getEvent();
            if (svgInEvent instanceof SvgInEventSingle) {
                SvgInEventSingle singleEvt = (SvgInEventSingle)svgInEvent;
                Event event = ((EventExpression)singleEvt.getEvent()).getEvent();
                int eventIdx = eventMap.get(event);
                String absEventName = CifTextUtils.getAbsName((PositionObject)event);
                this.codeInEventSetters.add("%s.svgInEvent = %d; // %s", new Object[]{ctxt.getPrefix(), eventIdx, absEventName});
            } else {
                if (!(svgInEvent instanceof SvgInEventIf)) throw new RuntimeException("Unknown SVG input mapping event: " + String.valueOf(svgInEvent));
                SvgInEventIf ifEvent = (SvgInEventIf)svgInEvent;
                boolean hasElse = false;
                this.codeInEventSetters.add();
                this.codeInEventSetters.add("var guardCond;");
                this.codeInEventSetters.add();
                for (SvgInEventIfEntry entry : ifEvent.getEntries()) {
                    Event event = ((EventExpression)entry.getEvent()).getEvent();
                    int eventIdx = eventMap.get(event);
                    String absEventName = CifTextUtils.getAbsName((PositionObject)event);
                    if (entry.getGuard() == null) {
                        this.codeInEventSetters.add("%s.svgInEvent = %d; // %s", new Object[]{ctxt.getPrefix(), eventIdx, absEventName});
                        hasElse = true;
                        continue;
                    }
                    this.codeInEventSetters.add("try {");
                    this.codeInEventSetters.indent();
                    ExprCode guardCode = ctxt.exprToTarget(entry.getGuard(), null);
                    Assert.check((!guardCode.hasCode() ? 1 : 0) != 0);
                    this.codeInEventSetters.add("guardCond = %s;", new Object[]{guardCode.getData()});
                    this.codeInEventSetters.dedent();
                    this.codeInEventSetters.add("} catch (e) {");
                    this.codeInEventSetters.indent();
                    this.codeInEventSetters.add("if (e instanceof %sException) {", new Object[]{ctxt.getPrefix()});
                    this.codeInEventSetters.indent();
                    this.codeInEventSetters.add("e = new %sException(\"Failed to evaluate a guard of the SVG input mapping with id \\\"%s\\\" in SVG file \\\"%s\\\".\", e);", new Object[]{ctxt.getPrefix(), inId, Strings.escape((String)svgFileNormRelPath)});
                    this.codeInEventSetters.add("%s.runtimeError(e);", new Object[]{ctxt.getPrefix()});
                    this.codeInEventSetters.dedent();
                    this.codeInEventSetters.add("}");
                    this.codeInEventSetters.add("throw e;");
                    this.codeInEventSetters.dedent();
                    this.codeInEventSetters.add("}");
                    this.codeInEventSetters.add("if (guardCond) {");
                    this.codeInEventSetters.indent();
                    this.codeInEventSetters.add("%s.svgInEvent = %d; // %s", new Object[]{ctxt.getPrefix(), eventIdx, absEventName});
                    this.codeInEventSetters.add("return;");
                    this.codeInEventSetters.dedent();
                    this.codeInEventSetters.add("}");
                    this.codeInEventSetters.add();
                }
                if (!hasElse) {
                    this.codeInEventSetters.add("var e = new %sException(\"Incomplete SVG input mapping with id \\\"%s\\\" in SVG file \\\"%s\\\": none of the guards are satisfied (evaluate to value \\\"true\\\").\");", new Object[]{ctxt.getPrefix(), inId, Strings.escape((String)svgFileNormRelPath)});
                    this.codeInEventSetters.add("%s.runtimeError(e);", new Object[]{ctxt.getPrefix()});
                    this.codeInEventSetters.add("throw e;");
                }
            }
        } else {
            if (svgIn.getUpdates().isEmpty()) throw new AssertionError((Object)("Unexpected SVG input mapping: " + String.valueOf(svgIn)));
            Event event = environmentEvents.get(svgIn);
            Assert.notNull((Object)event);
            int eventIdx = eventMap.get(event);
            String eventName = event.getName();
            this.codeInEventSetters.add("%s.svgInEvent = %d; // %s", new Object[]{ctxt.getPrefix(), eventIdx, eventName});
        }
        this.codeInEventSetters.dedent();
        this.codeInEventSetters.add("}");
    }
}

