/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.gef.internal.InternalGEFPlugin;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;

public class DefaultPaletteViewerPreferences
implements PaletteViewerPreferences {
    private static final String DEFAULT_FONT = "Default";
    private final PreferenceStoreListener listener;
    private final IPropertyChangeListener fontListener;
    private FontData fontData;
    private final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private final IPreferenceStore store;
    private int[] supportedModes;

    public DefaultPaletteViewerPreferences() {
        this(InternalGEFPlugin.getDefault().getPreferenceStore());
    }

    public DefaultPaletteViewerPreferences(IPreferenceStore store) {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.supportedModes = nArray;
        this.store = store;
        store.setDefault("Use Large Icons - Details", false);
        store.setDefault("Use Large Icons - Columns", true);
        store.setDefault("Use Large Icons - Icons", true);
        store.setDefault("Use Large Icons - List", false);
        store.setDefault("Layout Setting", 0);
        store.setDefault("Auto-Collapse Setting", 0);
        store.setDefault("Palette Font", DEFAULT_FONT);
        this.listener = new PreferenceStoreListener();
        store.addPropertyChangeListener((IPropertyChangeListener)this.listener);
        this.fontListener = event -> {
            if ("org.eclipse.jface.dialogfont".equals(event.getProperty()) && this.getPreferenceStore().getString("Palette Font").equals(DEFAULT_FONT)) {
                this.setFontData(JFaceResources.getDialogFont().getFontData()[0]);
                this.handlePreferenceStorePropertyChanged("Palette Font");
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fontListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public static String convertLayoutToPreferenceName(int layout) {
        String key = "";
        switch (layout) {
            case 1: {
                key = "Use Large Icons - Columns";
                break;
            }
            case 0: {
                key = "Use Large Icons - List";
                break;
            }
            case 2: {
                key = "Use Large Icons - Icons";
                break;
            }
            case 3: {
                key = "Use Large Icons - Details";
            }
        }
        return key;
    }

    public static int convertPreferenceNameToLayout(String preference) {
        int layout = -1;
        if (preference.equals("Use Large Icons - Details")) {
            layout = 3;
        } else if (preference.equals("Use Large Icons - Columns")) {
            layout = 1;
        } else if (preference.equals("Use Large Icons - Icons")) {
            layout = 2;
        } else if (preference.equals("Use Large Icons - List")) {
            layout = 0;
        }
        return layout;
    }

    protected void firePropertyChanged(String property, Object newVal) {
        this.listeners.firePropertyChange(property, null, newVal);
    }

    @Override
    public int getAutoCollapseSetting() {
        return this.getPreferenceStore().getInt("Auto-Collapse Setting");
    }

    @Override
    public FontData getFontData() {
        if (this.fontData == null) {
            String value = this.getPreferenceStore().getString("Palette Font");
            this.fontData = value.equals(DEFAULT_FONT) ? JFaceResources.getDialogFont().getFontData()[0] : new FontData(value);
        }
        return this.fontData;
    }

    @Override
    public int getLayoutSetting() {
        return this.getPreferenceStore().getInt("Layout Setting");
    }

    @Override
    public int[] getSupportedLayoutModes() {
        return this.supportedModes;
    }

    protected void handlePreferenceStorePropertyChanged(String property) {
        if (property.equals("Layout Setting")) {
            this.firePropertyChanged(property, this.getLayoutSetting());
        } else if (property.equals("Auto-Collapse Setting")) {
            this.firePropertyChanged(property, this.getAutoCollapseSetting());
        } else if (property.equals("Palette Font")) {
            this.firePropertyChanged(property, this.getFontData());
        } else {
            this.firePropertyChanged(property, this.useLargeIcons(DefaultPaletteViewerPreferences.convertPreferenceNameToLayout(property)));
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.store;
    }

    @Override
    public boolean isSupportedLayoutMode(int layout) {
        int[] nArray = this.supportedModes;
        int n = this.supportedModes.length;
        int n2 = 0;
        while (n2 < n) {
            int supportedMode = nArray[n2];
            if (supportedMode == layout) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    @Override
    public void setAutoCollapseSetting(int newVal) {
        this.getPreferenceStore().setValue("Auto-Collapse Setting", newVal);
    }

    @Override
    public void setFontData(FontData data) {
        this.fontData = data;
        String value = data.toString();
        if (this.fontData.equals((Object)JFaceResources.getDialogFont().getFontData()[0])) {
            value = DEFAULT_FONT;
        }
        this.getPreferenceStore().setValue("Palette Font", value);
    }

    @Override
    public void setLayoutSetting(int newVal) {
        this.getPreferenceStore().setValue("Layout Setting", newVal);
    }

    @Override
    public void setCurrentUseLargeIcons(boolean newVal) {
        this.setUseLargeIcons(this.getLayoutSetting(), newVal);
    }

    @Override
    public void setSupportedLayoutModes(int[] modes) {
        this.supportedModes = modes;
        if (!this.isSupportedLayoutMode(this.getPreferenceStore().getDefaultInt("Layout Setting"))) {
            this.getPreferenceStore().setDefault("Layout Setting", this.supportedModes[0]);
        }
        if (!this.isSupportedLayoutMode(this.getPreferenceStore().getInt("Layout Setting"))) {
            this.setLayoutSetting(this.supportedModes[0]);
        }
    }

    @Override
    public void setUseLargeIcons(int layout, boolean newVal) {
        this.getPreferenceStore().setValue(DefaultPaletteViewerPreferences.convertLayoutToPreferenceName(layout), newVal);
    }

    @Override
    public boolean useLargeIcons(int layout) {
        return this.getPreferenceStore().getBoolean(DefaultPaletteViewerPreferences.convertLayoutToPreferenceName(layout));
    }

    @Override
    public boolean useLargeIcons() {
        return this.useLargeIcons(this.getLayoutSetting());
    }

    private class PreferenceStoreListener
    implements IPropertyChangeListener {
        private PreferenceStoreListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            DefaultPaletteViewerPreferences.this.handlePreferenceStorePropertyChanged(evt.getProperty());
        }
    }
}

