/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventdisabler;

import java.util.List;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.eventdisabler.EventDisabler;
import org.eclipse.escet.cif.eventdisabler.options.EventNamesFileOption;
import org.eclipse.escet.cif.eventdisabler.options.EventNamesOption;
import org.eclipse.escet.cif.eventdisabler.options.EventUsageOption;
import org.eclipse.escet.cif.eventdisabler.options.IncludeInputSpecOption;
import org.eclipse.escet.cif.eventdisabler.options.SvgInputEventsOption;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.typechecker.postchk.CifAnnotationsPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.cif.typechecker.postchk.CifToolPostCheckEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.typechecker.SemanticException;

public class EventDisablerApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        EventDisablerApplication app = new EventDisablerApplication();
        app.run(args, true);
    }

    public EventDisablerApplication() {
    }

    public EventDisablerApplication(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF event disabler";
    }

    public String getAppDescription() {
        return "Disables events of a CIF specification.";
    }

    protected int runInternal() {
        Specification spec;
        CifReader cifReader;
        block7: {
            block6: {
                try {
                    cifReader = (CifReader)new CifReader().init();
                    spec = (Specification)cifReader.read();
                    if (!this.isTerminationRequested()) break block6;
                    return 0;
                }
                catch (ApplicationException e) {
                    String msg = Strings.fmt((String)"Failed to disable events for CIF file \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
                    throw new InvalidInputException(msg, (Throwable)e);
                }
            }
            new ElimComponentDefInst().transform(spec);
            spec = EventDisabler.disableEvents(spec);
            if (!this.isTerminationRequested()) break block7;
            return 0;
        }
        CifToolPostCheckEnv env = new CifToolPostCheckEnv(cifReader.getAbsDirPath(), "output");
        try {
            new CifAnnotationsPostChecker((CifPostCheckEnv)env).check(spec);
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        env.throwUnsupportedExceptionIfAnyErrors(null);
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".disabled.cif");
        String absOutPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)spec, (PathPair)new PathPair(outPath, absOutPath), (String)cifReader.getAbsDirPath());
        return 0;
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = EventDisablerApplication.getGeneralOptionCategory();
        List genOpts = Lists.list();
        genOpts.add(Options.getInstance(InputFileOption.class));
        genOpts.add(Options.getInstance(OutputFileOption.class));
        genOpts.add(Options.getInstance(EventNamesOption.class));
        genOpts.add(Options.getInstance(EventNamesFileOption.class));
        genOpts.add(Options.getInstance(SvgInputEventsOption.class));
        genOpts.add(Options.getInstance(EventUsageOption.class));
        genOpts.add(Options.getInstance(IncludeInputSpecOption.class));
        List genSubCats = Lists.list();
        OptionCategory genCat = new OptionCategory("Generator", "Generator options.", genSubCats, genOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, genCat});
        OptionCategory options = new OptionCategory("CIF Event Disabler Options", "All options for the CIF event disabler.", cats, Lists.list());
        return options;
    }
}

