/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.simulator.compiler.AssignmentCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class UpdatesCodeGenerator {
    private UpdatesCodeGenerator() {
    }

    public static List<ExprCodeGeneratorResult> gencodeUpdates(CodeBox c, Automaton aut, CifCompilerContext ctxt, List<Update> updates, String state) {
        List exprResults = Lists.list();
        for (Update update : updates) {
            if (update instanceof Assignment) {
                Assignment asgn = (Assignment)update;
                exprResults.addAll(AssignmentCodeGenerator.gencodeAssignment(asgn.getAddressable(), asgn.getValue(), aut, c, ctxt, state));
                continue;
            }
            exprResults.addAll(UpdatesCodeGenerator.gencodeIfUpdate(c, aut, ctxt, (IfUpdate)update, state));
        }
        return exprResults;
    }

    private static List<ExprCodeGeneratorResult> gencodeIfUpdate(CodeBox c, Automaton aut, CifCompilerContext ctxt, IfUpdate update, String state) {
        List exprResults = Lists.list();
        c.add("try {");
        c.indent();
        ExprCodeGeneratorResult updateResult = ExprCodeGenerator.gencodePreds((List<Expression>)update.getGuards(), ctxt, state);
        c.add("b = %s;", new Object[]{updateResult});
        exprResults.add(updateResult);
        c.dedent();
        c.add("} catch (CifSimulatorException e) {");
        c.indent();
        c.add("throw new CifSimulatorException(\"Evaluation of \\\"if\\\" update guard(s) \\\"%s\\\" failed.\", e, source);", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)CifTextUtils.exprsToStr((List)update.getGuards()), (int)1000))});
        c.dedent();
        c.add("}");
        c.add("if (b) {");
        c.indent();
        exprResults.addAll(UpdatesCodeGenerator.gencodeUpdates(c, aut, ctxt, (List<Update>)update.getThens(), state));
        c.dedent();
        for (ElifUpdate elifUpd : update.getElifs()) {
            c.add("} else {");
            c.indent();
            c.add("try {");
            c.indent();
            ExprCodeGeneratorResult elifUpdResult = ExprCodeGenerator.gencodePreds((List<Expression>)elifUpd.getGuards(), ctxt, state);
            c.add("b = %s;", new Object[]{elifUpdResult});
            exprResults.add(updateResult);
            c.dedent();
            c.add("} catch (CifSimulatorException e) {");
            c.indent();
            c.add("throw new CifSimulatorException(\"Evaluation of \\\"elif\\\" update guard(s) \\\"%s\\\" failed.\", e, source);", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)CifTextUtils.exprsToStr((List)elifUpd.getGuards()), (int)1000))});
            c.dedent();
            c.add("}");
            c.add("if (b) {");
            c.indent();
            exprResults.addAll(UpdatesCodeGenerator.gencodeUpdates(c, aut, ctxt, (List<Update>)elifUpd.getThens(), state));
            c.dedent();
        }
        if (!update.getElses().isEmpty()) {
            c.add("} else {");
            c.indent();
            exprResults.addAll(UpdatesCodeGenerator.gencodeUpdates(c, aut, ctxt, (List<Update>)update.getElses(), state));
            c.dedent();
        }
        int i = 0;
        while (i < update.getElifs().size()) {
            c.add("}");
            c.dedent();
            ++i;
        }
        c.add("}");
        return exprResults;
    }
}

