/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
grammar InternalActivity;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.lsat.activity.teditor.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.lsat.activity.teditor.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess;

}

@parser::members {

 	private ActivityGrammarAccess grammarAccess;

    public InternalActivityParser(TokenStream input, ActivityGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "ActivitySet";
   	}

   	@Override
   	protected ActivityGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleActivitySet
entryRuleActivitySet returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getActivitySetRule()); }
	iv_ruleActivitySet=ruleActivitySet
	{ $current=$iv_ruleActivitySet.current; }
	EOF;

// Rule ActivitySet
ruleActivitySet returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getActivitySetAccess().getActivitySetAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getActivitySetAccess().getImportsImportParserRuleCall_1_0());
				}
				lv_imports_1_0=ruleImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActivitySetRule());
					}
					add(
						$current,
						"imports",
						lv_imports_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.Import");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getActivitySetAccess().getActivitiesActivityParserRuleCall_2_0_0());
					}
					lv_activities_2_0=ruleActivity
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getActivitySetRule());
						}
						add(
							$current,
							"activities",
							lv_activities_2_0,
							"org.eclipse.lsat.activity.teditor.Activity.Activity");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					{
						newCompositeNode(grammarAccess.getActivitySetAccess().getEventsEventParserRuleCall_2_1_0());
					}
					lv_events_3_0=ruleEvent
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getActivitySetRule());
						}
						add(
							$current,
							"events",
							lv_events_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.Event");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
	)
;

// Entry rule entryRuleImport
entryRuleImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getImportRule()); }
	iv_ruleImport=ruleImport
	{ $current=$iv_ruleImport.current; }
	EOF;

// Rule Import
ruleImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='import'
		{
			newLeafNode(otherlv_0, grammarAccess.getImportAccess().getImportKeyword_0());
		}
		(
			(
				lv_importURI_1_0=RULE_STRING
				{
					newLeafNode(lv_importURI_1_0, grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getImportRule());
					}
					setWithLastConsumed(
						$current,
						"importURI",
						lv_importURI_1_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)
	)
;

// Entry rule entryRuleActivity
entryRuleActivity returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getActivityRule()); }
	iv_ruleActivity=ruleActivity
	{ $current=$iv_ruleActivity.current; }
	EOF;

// Rule Activity
ruleActivity returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='activity'
		{
			newLeafNode(otherlv_0, grammarAccess.getActivityAccess().getActivityKeyword_0());
		}
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getActivityAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getActivityRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			otherlv_2='('
			{
				newLeafNode(otherlv_2, grammarAccess.getActivityAccess().getLeftParenthesisKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getActivityAccess().getParameterDeclarationsParameterDeclarationParserRuleCall_2_1_0());
					}
					lv_parameterDeclarations_3_0=ruleParameterDeclaration
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getActivityRule());
						}
						add(
							$current,
							"parameterDeclarations",
							lv_parameterDeclarations_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.ParameterDeclaration");
						afterParserOrEnumRuleCall();
					}
				)
			)?
			(
				otherlv_4=','
				{
					newLeafNode(otherlv_4, grammarAccess.getActivityAccess().getCommaKeyword_2_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getActivityAccess().getParameterDeclarationsParameterDeclarationParserRuleCall_2_2_1_0());
						}
						lv_parameterDeclarations_5_0=ruleParameterDeclaration
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getActivityRule());
							}
							add(
								$current,
								"parameterDeclarations",
								lv_parameterDeclarations_5_0,
								"org.eclipse.lsat.activity.teditor.Activity.ParameterDeclaration");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_6=')'
			{
				newLeafNode(otherlv_6, grammarAccess.getActivityAccess().getRightParenthesisKeyword_2_3());
			}
		)?
		otherlv_7='{'
		{
			newLeafNode(otherlv_7, grammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_3());
		}
		(
			otherlv_8='prerequisites'
			{
				newLeafNode(otherlv_8, grammarAccess.getActivityAccess().getPrerequisitesKeyword_4_0());
			}
			otherlv_9='{'
			{
				newLeafNode(otherlv_9, grammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_4_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getActivityAccess().getPrerequisitesLocationPrerequisiteParserRuleCall_4_2_0());
					}
					lv_prerequisites_10_0=ruleLocationPrerequisite
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getActivityRule());
						}
						add(
							$current,
							"prerequisites",
							lv_prerequisites_10_0,
							"org.eclipse.lsat.activity.teditor.Activity.LocationPrerequisite");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_11='}'
			{
				newLeafNode(otherlv_11, grammarAccess.getActivityAccess().getRightCurlyBracketKeyword_4_3());
			}
		)?
		otherlv_12='actions'
		{
			newLeafNode(otherlv_12, grammarAccess.getActivityAccess().getActionsKeyword_5());
		}
		otherlv_13='{'
		{
			newLeafNode(otherlv_13, grammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_6());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getActivityAccess().getNodesNodeParserRuleCall_7_0());
				}
				lv_nodes_14_0=ruleNode
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActivityRule());
					}
					add(
						$current,
						"nodes",
						lv_nodes_14_0,
						"org.eclipse.lsat.activity.teditor.Activity.Node");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_15='}'
		{
			newLeafNode(otherlv_15, grammarAccess.getActivityAccess().getRightCurlyBracketKeyword_8());
		}
		otherlv_16='action flow'
		{
			newLeafNode(otherlv_16, grammarAccess.getActivityAccess().getActionFlowKeyword_9());
		}
		otherlv_17='{'
		{
			newLeafNode(otherlv_17, grammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_10());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getActivityAccess().getEdgesEdgesParserRuleCall_11_0());
				}
				lv_edges_18_0=ruleEdges
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActivityRule());
					}
					add(
						$current,
						"edges",
						lv_edges_18_0,
						"org.eclipse.lsat.activity.teditor.Activity.Edges");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_19='}'
		{
			newLeafNode(otherlv_19, grammarAccess.getActivityAccess().getRightCurlyBracketKeyword_12());
		}
		(
			otherlv_20='constraints'
			{
				newLeafNode(otherlv_20, grammarAccess.getActivityAccess().getConstraintsKeyword_13_0());
			}
			otherlv_21='{'
			{
				newLeafNode(otherlv_21, grammarAccess.getActivityAccess().getLeftCurlyBracketKeyword_13_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getActivityAccess().getConstraintsEdgesWithConstraintsParserRuleCall_13_2_0());
					}
					lv_constraints_22_0=ruleEdgesWithConstraints
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getActivityRule());
						}
						add(
							$current,
							"constraints",
							lv_constraints_22_0,
							"org.eclipse.lsat.activity.teditor.Activity.EdgesWithConstraints");
						afterParserOrEnumRuleCall();
					}
				)
			)*
			otherlv_23='}'
			{
				newLeafNode(otherlv_23, grammarAccess.getActivityAccess().getRightCurlyBracketKeyword_13_3());
			}
		)?
		otherlv_24='}'
		{
			newLeafNode(otherlv_24, grammarAccess.getActivityAccess().getRightCurlyBracketKeyword_14());
		}
	)
;

// Entry rule entryRuleParameterDeclaration
entryRuleParameterDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getParameterDeclarationRule()); }
	iv_ruleParameterDeclaration=ruleParameterDeclaration
	{ $current=$iv_ruleParameterDeclaration.current; }
	EOF;

// Rule ParameterDeclaration
ruleParameterDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getParameterDeclarationAccess().getEventDeclarationParserRuleCall_0());
		}
		this_EventDeclaration_0=ruleEventDeclaration
		{
			$current = $this_EventDeclaration_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getParameterDeclarationAccess().getActionDeclarationParserRuleCall_1());
		}
		this_ActionDeclaration_1=ruleActionDeclaration
		{
			$current = $this_ActionDeclaration_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getParameterDeclarationAccess().getResourceDeclarationParserRuleCall_2());
		}
		this_ResourceDeclaration_2=ruleResourceDeclaration
		{
			$current = $this_ResourceDeclaration_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getParameterDeclarationAccess().getSymbolicPositionDeclarationParserRuleCall_3());
		}
		this_SymbolicPositionDeclaration_3=ruleSymbolicPositionDeclaration
		{
			$current = $this_SymbolicPositionDeclaration_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getParameterDeclarationAccess().getProfileDeclarationParserRuleCall_4());
		}
		this_ProfileDeclaration_4=ruleProfileDeclaration
		{
			$current = $this_ProfileDeclaration_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getParameterDeclarationAccess().getDistanceDeclarationParserRuleCall_5());
		}
		this_DistanceDeclaration_5=ruleDistanceDeclaration
		{
			$current = $this_DistanceDeclaration_5.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getParameterDeclarationAccess().getModelTypeDefinitionRefDeclarationParserRuleCall_6());
		}
		this_ModelTypeDefinitionRefDeclaration_6=ruleModelTypeDefinitionRefDeclaration
		{
			$current = $this_ModelTypeDefinitionRefDeclaration_6.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleEventDeclaration
entryRuleEventDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEventDeclarationRule()); }
	iv_ruleEventDeclaration=ruleEventDeclaration
	{ $current=$iv_ruleEventDeclaration.current; }
	EOF;

// Rule EventDeclaration
ruleEventDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEventDeclarationAccess().getParameterDeclarationAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getEventDeclarationAccess().getDeclarationsEventDefParserRuleCall_1_0());
				}
				lv_declarations_1_0=ruleEventDef
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEventDeclarationRule());
					}
					add(
						$current,
						"declarations",
						lv_declarations_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.EventDef");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2=','
			{
				newLeafNode(otherlv_2, grammarAccess.getEventDeclarationAccess().getCommaKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getEventDeclarationAccess().getDeclarationsEventDefParserRuleCall_2_1_0());
					}
					lv_declarations_3_0=ruleEventDef
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEventDeclarationRule());
						}
						add(
							$current,
							"declarations",
							lv_declarations_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.EventDef");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_4=':'
		{
			newLeafNode(otherlv_4, grammarAccess.getEventDeclarationAccess().getColonKeyword_3());
		}
		otherlv_5='Event'
		{
			newLeafNode(otherlv_5, grammarAccess.getEventDeclarationAccess().getEventKeyword_4());
		}
	)
;

// Entry rule entryRuleActionDeclaration
entryRuleActionDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getActionDeclarationRule()); }
	iv_ruleActionDeclaration=ruleActionDeclaration
	{ $current=$iv_ruleActionDeclaration.current; }
	EOF;

// Rule ActionDeclaration
ruleActionDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getActionDeclarationAccess().getParameterDeclarationAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getActionDeclarationAccess().getDeclarationsActionDefParserRuleCall_1_0());
				}
				lv_declarations_1_0=ruleActionDef
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getActionDeclarationRule());
					}
					add(
						$current,
						"declarations",
						lv_declarations_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.ActionDef");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2=','
			{
				newLeafNode(otherlv_2, grammarAccess.getActionDeclarationAccess().getCommaKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getActionDeclarationAccess().getDeclarationsActionDefParserRuleCall_2_1_0());
					}
					lv_declarations_3_0=ruleActionDef
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getActionDeclarationRule());
						}
						add(
							$current,
							"declarations",
							lv_declarations_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.ActionDef");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_4=':'
		{
			newLeafNode(otherlv_4, grammarAccess.getActionDeclarationAccess().getColonKeyword_3());
		}
		otherlv_5='Action'
		{
			newLeafNode(otherlv_5, grammarAccess.getActionDeclarationAccess().getActionKeyword_4());
		}
	)
;

// Entry rule entryRuleSymbolicPositionDeclaration
entryRuleSymbolicPositionDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSymbolicPositionDeclarationRule()); }
	iv_ruleSymbolicPositionDeclaration=ruleSymbolicPositionDeclaration
	{ $current=$iv_ruleSymbolicPositionDeclaration.current; }
	EOF;

// Rule SymbolicPositionDeclaration
ruleSymbolicPositionDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSymbolicPositionDeclarationAccess().getParameterDeclarationAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getSymbolicPositionDeclarationAccess().getDeclarationsSymbolicPositionDefParserRuleCall_1_0());
				}
				lv_declarations_1_0=ruleSymbolicPositionDef
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSymbolicPositionDeclarationRule());
					}
					add(
						$current,
						"declarations",
						lv_declarations_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.SymbolicPositionDef");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2=','
			{
				newLeafNode(otherlv_2, grammarAccess.getSymbolicPositionDeclarationAccess().getCommaKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getSymbolicPositionDeclarationAccess().getDeclarationsSymbolicPositionDefParserRuleCall_2_1_0());
					}
					lv_declarations_3_0=ruleSymbolicPositionDef
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSymbolicPositionDeclarationRule());
						}
						add(
							$current,
							"declarations",
							lv_declarations_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.SymbolicPositionDef");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_4=':'
		{
			newLeafNode(otherlv_4, grammarAccess.getSymbolicPositionDeclarationAccess().getColonKeyword_3());
		}
		otherlv_5='SymbolicPosition'
		{
			newLeafNode(otherlv_5, grammarAccess.getSymbolicPositionDeclarationAccess().getSymbolicPositionKeyword_4());
		}
	)
;

// Entry rule entryRuleProfileDeclaration
entryRuleProfileDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getProfileDeclarationRule()); }
	iv_ruleProfileDeclaration=ruleProfileDeclaration
	{ $current=$iv_ruleProfileDeclaration.current; }
	EOF;

// Rule ProfileDeclaration
ruleProfileDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getProfileDeclarationAccess().getParameterDeclarationAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getProfileDeclarationAccess().getDeclarationsProfileDefParserRuleCall_1_0());
				}
				lv_declarations_1_0=ruleProfileDef
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getProfileDeclarationRule());
					}
					add(
						$current,
						"declarations",
						lv_declarations_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.ProfileDef");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2=','
			{
				newLeafNode(otherlv_2, grammarAccess.getProfileDeclarationAccess().getCommaKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getProfileDeclarationAccess().getDeclarationsProfileDefParserRuleCall_2_1_0());
					}
					lv_declarations_3_0=ruleProfileDef
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getProfileDeclarationRule());
						}
						add(
							$current,
							"declarations",
							lv_declarations_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.ProfileDef");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_4=':'
		{
			newLeafNode(otherlv_4, grammarAccess.getProfileDeclarationAccess().getColonKeyword_3());
		}
		otherlv_5='Profile'
		{
			newLeafNode(otherlv_5, grammarAccess.getProfileDeclarationAccess().getProfileKeyword_4());
		}
	)
;

// Entry rule entryRuleDistanceDeclaration
entryRuleDistanceDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDistanceDeclarationRule()); }
	iv_ruleDistanceDeclaration=ruleDistanceDeclaration
	{ $current=$iv_ruleDistanceDeclaration.current; }
	EOF;

// Rule DistanceDeclaration
ruleDistanceDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDistanceDeclarationAccess().getParameterDeclarationAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getDistanceDeclarationAccess().getDeclarationsDistanceDefParserRuleCall_1_0());
				}
				lv_declarations_1_0=ruleDistanceDef
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getDistanceDeclarationRule());
					}
					add(
						$current,
						"declarations",
						lv_declarations_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.DistanceDef");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2=','
			{
				newLeafNode(otherlv_2, grammarAccess.getDistanceDeclarationAccess().getCommaKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getDistanceDeclarationAccess().getDeclarationsDistanceDefParserRuleCall_2_1_0());
					}
					lv_declarations_3_0=ruleDistanceDef
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getDistanceDeclarationRule());
						}
						add(
							$current,
							"declarations",
							lv_declarations_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.DistanceDef");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_4=':'
		{
			newLeafNode(otherlv_4, grammarAccess.getDistanceDeclarationAccess().getColonKeyword_3());
		}
		otherlv_5='Distance'
		{
			newLeafNode(otherlv_5, grammarAccess.getDistanceDeclarationAccess().getDistanceKeyword_4());
		}
	)
;

// Entry rule entryRuleResourceDeclaration
entryRuleResourceDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getResourceDeclarationRule()); }
	iv_ruleResourceDeclaration=ruleResourceDeclaration
	{ $current=$iv_ruleResourceDeclaration.current; }
	EOF;

// Rule ResourceDeclaration
ruleResourceDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getResourceDeclarationAccess().getParameterDeclarationAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getResourceDeclarationAccess().getDeclarationsResourceDefParserRuleCall_1_0());
				}
				lv_declarations_1_0=ruleResourceDef
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getResourceDeclarationRule());
					}
					add(
						$current,
						"declarations",
						lv_declarations_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.ResourceDef");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2=','
			{
				newLeafNode(otherlv_2, grammarAccess.getResourceDeclarationAccess().getCommaKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getResourceDeclarationAccess().getDeclarationsResourceDefParserRuleCall_2_1_0());
					}
					lv_declarations_3_0=ruleResourceDef
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getResourceDeclarationRule());
						}
						add(
							$current,
							"declarations",
							lv_declarations_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.ResourceDef");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)*
		otherlv_4=':'
		{
			newLeafNode(otherlv_4, grammarAccess.getResourceDeclarationAccess().getColonKeyword_3());
		}
		otherlv_5='Resource'
		{
			newLeafNode(otherlv_5, grammarAccess.getResourceDeclarationAccess().getResourceKeyword_4());
		}
	)
;

// Entry rule entryRuleModelTypeDefinitionRefDeclaration
entryRuleModelTypeDefinitionRefDeclaration returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getModelTypeDefinitionRefDeclarationRule()); }
	iv_ruleModelTypeDefinitionRefDeclaration=ruleModelTypeDefinitionRefDeclaration
	{ $current=$iv_ruleModelTypeDefinitionRefDeclaration.current; }
	EOF;

// Rule ModelTypeDefinitionRefDeclaration
ruleModelTypeDefinitionRefDeclaration returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getModelTypeDefinitionRefDeclarationAccess().getParameterDeclarationAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getModelTypeDefinitionRefDeclarationAccess().getDeclarationsModelTypeDefinitionRefParserRuleCall_1_0());
				}
				lv_declarations_1_0=ruleModelTypeDefinitionRef
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getModelTypeDefinitionRefDeclarationRule());
					}
					add(
						$current,
						"declarations",
						lv_declarations_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.ModelTypeDefinitionRef");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleEventDef
entryRuleEventDef returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEventDefRule()); }
	iv_ruleEventDef=ruleEventDef
	{ $current=$iv_ruleEventDef.current; }
	EOF;

// Rule EventDef
ruleEventDef returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEventDefAccess().getEventAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getEventDefAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEventDefRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleActionDef
entryRuleActionDef returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getActionDefRule()); }
	iv_ruleActionDef=ruleActionDef
	{ $current=$iv_ruleActionDef.current; }
	EOF;

// Rule ActionDef
ruleActionDef returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getActionDefAccess().getActionTypeAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getActionDefAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getActionDefRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleSymbolicPositionDef
entryRuleSymbolicPositionDef returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSymbolicPositionDefRule()); }
	iv_ruleSymbolicPositionDef=ruleSymbolicPositionDef
	{ $current=$iv_ruleSymbolicPositionDef.current; }
	EOF;

// Rule SymbolicPositionDef
ruleSymbolicPositionDef returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSymbolicPositionDefAccess().getSymbolicPositionAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getSymbolicPositionDefAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSymbolicPositionDefRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleProfileDef
entryRuleProfileDef returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getProfileDefRule()); }
	iv_ruleProfileDef=ruleProfileDef
	{ $current=$iv_ruleProfileDef.current; }
	EOF;

// Rule ProfileDef
ruleProfileDef returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getProfileDefAccess().getProfileAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getProfileDefAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getProfileDefRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleDistanceDef
entryRuleDistanceDef returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDistanceDefRule()); }
	iv_ruleDistanceDef=ruleDistanceDef
	{ $current=$iv_ruleDistanceDef.current; }
	EOF;

// Rule DistanceDef
ruleDistanceDef returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDistanceDefAccess().getDistanceAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getDistanceDefAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getDistanceDefRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleResourceDef
entryRuleResourceDef returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getResourceDefRule()); }
	iv_ruleResourceDef=ruleResourceDef
	{ $current=$iv_ruleResourceDef.current; }
	EOF;

// Rule ResourceDef
ruleResourceDef returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getResourceDefAccess().getResourceAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getResourceDefAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getResourceDefRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleModelTypeDefinitionRef
entryRuleModelTypeDefinitionRef returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getModelTypeDefinitionRefRule()); }
	iv_ruleModelTypeDefinitionRef=ruleModelTypeDefinitionRef
	{ $current=$iv_ruleModelTypeDefinitionRef.current; }
	EOF;

// Rule ModelTypeDefinitionRef
ruleModelTypeDefinitionRef returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getModelTypeDefinitionRefAccess().getModelTypeDefinitionRefAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getModelTypeDefinitionRefAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getModelTypeDefinitionRefRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getModelTypeDefinitionRefAccess().getColonKeyword_2());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getModelTypeDefinitionRefRule());
					}
				}
				otherlv_3=RULE_ID
				{
					newLeafNode(otherlv_3, grammarAccess.getModelTypeDefinitionRefAccess().getTypeDefinitionTypeDefinitionCrossReference_3_0());
				}
			)
		)
	)
;

// Entry rule entryRuleLocationPrerequisite
entryRuleLocationPrerequisite returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLocationPrerequisiteRule()); }
	iv_ruleLocationPrerequisite=ruleLocationPrerequisite
	{ $current=$iv_ruleLocationPrerequisite.current; }
	EOF;

// Rule LocationPrerequisite
ruleLocationPrerequisite returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getLocationPrerequisiteRule());
					}
				}
				otherlv_0=RULE_ID
				{
					newLeafNode(otherlv_0, grammarAccess.getLocationPrerequisiteAccess().getResourceDefinitionResourceCrossReference_0_0());
				}
			)
		)
		(
			otherlv_1='.'
			{
				newLeafNode(otherlv_1, grammarAccess.getLocationPrerequisiteAccess().getFullStopKeyword_1_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getLocationPrerequisiteRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getLocationPrerequisiteAccess().getResourceItemResourceItemCrossReference_1_1_0());
					}
					ruleIID
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_3='.'
		{
			newLeafNode(otherlv_3, grammarAccess.getLocationPrerequisiteAccess().getFullStopKeyword_2());
		}
		(
			((
				RULE_ID
			)
			)=>
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getLocationPrerequisiteRule());
					}
				}
				otherlv_4=RULE_ID
				{
					newLeafNode(otherlv_4, grammarAccess.getLocationPrerequisiteAccess().getPeripheralPeripheralCrossReference_3_0());
				}
			)
		)
		otherlv_5='at'
		{
			newLeafNode(otherlv_5, grammarAccess.getLocationPrerequisiteAccess().getAtKeyword_4());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getLocationPrerequisiteRule());
					}
				}
				otherlv_6=RULE_ID
				{
					newLeafNode(otherlv_6, grammarAccess.getLocationPrerequisiteAccess().getPositionSymbolicPositionCrossReference_5_0());
				}
			)
		)
	)
;

// Entry rule entryRuleNode
entryRuleNode returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNodeRule()); }
	iv_ruleNode=ruleNode
	{ $current=$iv_ruleNode.current; }
	EOF;

// Rule Node
ruleNode returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getNodeAccess().getClaimParserRuleCall_0());
		}
		this_Claim_0=ruleClaim
		{
			$current = $this_Claim_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNodeAccess().getReleaseParserRuleCall_1());
		}
		this_Release_1=ruleRelease
		{
			$current = $this_Release_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNodeAccess().getSimpleActionParserRuleCall_2());
		}
		this_SimpleAction_2=ruleSimpleAction
		{
			$current = $this_SimpleAction_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNodeAccess().getMoveParserRuleCall_3());
		}
		this_Move_3=ruleMove
		{
			$current = $this_Move_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNodeAccess().getRequireEventParserRuleCall_4());
		}
		this_RequireEvent_4=ruleRequireEvent
		{
			$current = $this_RequireEvent_4.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getNodeAccess().getRaiseEventParserRuleCall_5());
		}
		this_RaiseEvent_5=ruleRaiseEvent
		{
			$current = $this_RaiseEvent_5.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleClaim
entryRuleClaim returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getClaimRule()); }
	iv_ruleClaim=ruleClaim
	{ $current=$iv_ruleClaim.current; }
	EOF;

// Rule Claim
ruleClaim returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getClaimAccess().getClaimAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getClaimAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getClaimRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getClaimAccess().getColonKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getClaimAccess().getEntryTracePointParserRuleCall_3_0_0());
					}
					lv_entry_3_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getClaimRule());
						}
						set(
							$current,
							"entry",
							lv_entry_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getClaimAccess().getOuterEntryTracePointParserRuleCall_3_1_0_0());
						}
						lv_outerEntry_4_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getClaimRule());
							}
							set(
								$current,
								"outerEntry",
								lv_outerEntry_4_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getClaimAccess().getEntryTracePointParserRuleCall_3_1_1_0());
						}
						lv_entry_5_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getClaimRule());
							}
							set(
								$current,
								"entry",
								lv_entry_5_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
		(
			(
				lv_passive_6_0='passive'
				{
					newLeafNode(lv_passive_6_0, grammarAccess.getClaimAccess().getPassivePassiveKeyword_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getClaimRule());
					}
					setWithLastConsumed($current, "passive", lv_passive_6_0 != null, "passive");
				}
			)
		)?
		otherlv_7='claim'
		{
			newLeafNode(otherlv_7, grammarAccess.getClaimAccess().getClaimKeyword_5());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getClaimRule());
					}
				}
				otherlv_8=RULE_ID
				{
					newLeafNode(otherlv_8, grammarAccess.getClaimAccess().getResourceDefinitionResourceCrossReference_6_0());
				}
			)
		)
		(
			otherlv_9='.'
			{
				newLeafNode(otherlv_9, grammarAccess.getClaimAccess().getFullStopKeyword_7_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getClaimRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getClaimAccess().getResourceItemResourceItemCrossReference_7_1_0());
					}
					ruleIID
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getClaimAccess().getExitTracePointParserRuleCall_8_0_0());
					}
					lv_exit_11_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getClaimRule());
						}
						set(
							$current,
							"exit",
							lv_exit_11_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getClaimAccess().getExitTracePointParserRuleCall_8_1_0_0());
						}
						lv_exit_12_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getClaimRule());
							}
							set(
								$current,
								"exit",
								lv_exit_12_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getClaimAccess().getOuterExitTracePointParserRuleCall_8_1_1_0());
						}
						lv_outerExit_13_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getClaimRule());
							}
							set(
								$current,
								"outerExit",
								lv_outerExit_13_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleRelease
entryRuleRelease returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getReleaseRule()); }
	iv_ruleRelease=ruleRelease
	{ $current=$iv_ruleRelease.current; }
	EOF;

// Rule Release
ruleRelease returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getReleaseAccess().getReleaseAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getReleaseAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getReleaseRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getReleaseAccess().getColonKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getReleaseAccess().getEntryTracePointParserRuleCall_3_0_0());
					}
					lv_entry_3_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getReleaseRule());
						}
						set(
							$current,
							"entry",
							lv_entry_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getReleaseAccess().getOuterEntryTracePointParserRuleCall_3_1_0_0());
						}
						lv_outerEntry_4_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReleaseRule());
							}
							set(
								$current,
								"outerEntry",
								lv_outerEntry_4_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getReleaseAccess().getEntryTracePointParserRuleCall_3_1_1_0());
						}
						lv_entry_5_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReleaseRule());
							}
							set(
								$current,
								"entry",
								lv_entry_5_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
		otherlv_6='release'
		{
			newLeafNode(otherlv_6, grammarAccess.getReleaseAccess().getReleaseKeyword_4());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getReleaseRule());
					}
				}
				otherlv_7=RULE_ID
				{
					newLeafNode(otherlv_7, grammarAccess.getReleaseAccess().getResourceDefinitionResourceCrossReference_5_0());
				}
			)
		)
		(
			otherlv_8='.'
			{
				newLeafNode(otherlv_8, grammarAccess.getReleaseAccess().getFullStopKeyword_6_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getReleaseRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getReleaseAccess().getResourceItemResourceItemCrossReference_6_1_0());
					}
					ruleIID
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getReleaseAccess().getExitTracePointParserRuleCall_7_0_0());
					}
					lv_exit_10_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getReleaseRule());
						}
						set(
							$current,
							"exit",
							lv_exit_10_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getReleaseAccess().getExitTracePointParserRuleCall_7_1_0_0());
						}
						lv_exit_11_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReleaseRule());
							}
							set(
								$current,
								"exit",
								lv_exit_11_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getReleaseAccess().getOuterExitTracePointParserRuleCall_7_1_1_0());
						}
						lv_outerExit_12_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getReleaseRule());
							}
							set(
								$current,
								"outerExit",
								lv_outerExit_12_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleRaiseEvent
entryRuleRaiseEvent returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRaiseEventRule()); }
	iv_ruleRaiseEvent=ruleRaiseEvent
	{ $current=$iv_ruleRaiseEvent.current; }
	EOF;

// Rule RaiseEvent
ruleRaiseEvent returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getRaiseEventAccess().getRaiseEventAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getRaiseEventAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRaiseEventRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getRaiseEventAccess().getColonKeyword_2());
		}
		otherlv_3='raise'
		{
			newLeafNode(otherlv_3, grammarAccess.getRaiseEventAccess().getRaiseKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRaiseEventRule());
					}
				}
				otherlv_4=RULE_ID
				{
					newLeafNode(otherlv_4, grammarAccess.getRaiseEventAccess().getResourceDefinitionEventCrossReference_4_0());
				}
			)
		)
		(
			otherlv_5='.'
			{
				newLeafNode(otherlv_5, grammarAccess.getRaiseEventAccess().getFullStopKeyword_5_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRaiseEventRule());
						}
					}
					otherlv_6=RULE_ID
					{
						newLeafNode(otherlv_6, grammarAccess.getRaiseEventAccess().getResourceItemEventItemCrossReference_5_1_0());
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleRequireEvent
entryRuleRequireEvent returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRequireEventRule()); }
	iv_ruleRequireEvent=ruleRequireEvent
	{ $current=$iv_ruleRequireEvent.current; }
	EOF;

// Rule RequireEvent
ruleRequireEvent returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getRequireEventAccess().getRequireEventAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getRequireEventAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRequireEventRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getRequireEventAccess().getColonKeyword_2());
		}
		otherlv_3='require'
		{
			newLeafNode(otherlv_3, grammarAccess.getRequireEventAccess().getRequireKeyword_3());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRequireEventRule());
					}
				}
				otherlv_4=RULE_ID
				{
					newLeafNode(otherlv_4, grammarAccess.getRequireEventAccess().getResourceDefinitionEventCrossReference_4_0());
				}
			)
		)
		(
			otherlv_5='.'
			{
				newLeafNode(otherlv_5, grammarAccess.getRequireEventAccess().getFullStopKeyword_5_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRequireEventRule());
						}
					}
					otherlv_6=RULE_ID
					{
						newLeafNode(otherlv_6, grammarAccess.getRequireEventAccess().getResourceItemEventItemCrossReference_5_1_0());
					}
				)
			)
		)?
	)
;

// Entry rule entryRuleMove
entryRuleMove returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getMoveRule()); }
	iv_ruleMove=ruleMove
	{ $current=$iv_ruleMove.current; }
	EOF;

// Rule Move
ruleMove returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getMoveAccess().getMoveAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getMoveAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMoveRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getMoveAccess().getColonKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getMoveAccess().getEntryTracePointParserRuleCall_3_0_0());
					}
					lv_entry_3_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMoveRule());
						}
						set(
							$current,
							"entry",
							lv_entry_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getMoveAccess().getOuterEntryTracePointParserRuleCall_3_1_0_0());
						}
						lv_outerEntry_4_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getMoveRule());
							}
							set(
								$current,
								"outerEntry",
								lv_outerEntry_4_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getMoveAccess().getEntryTracePointParserRuleCall_3_1_1_0());
						}
						lv_entry_5_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getMoveRule());
							}
							set(
								$current,
								"entry",
								lv_entry_5_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
		otherlv_6='move'
		{
			newLeafNode(otherlv_6, grammarAccess.getMoveAccess().getMoveKeyword_4());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMoveRule());
					}
				}
				otherlv_7=RULE_ID
				{
					newLeafNode(otherlv_7, grammarAccess.getMoveAccess().getResourceDefinitionResourceCrossReference_5_0());
				}
			)
		)
		(
			otherlv_8='.'
			{
				newLeafNode(otherlv_8, grammarAccess.getMoveAccess().getFullStopKeyword_6_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getMoveRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getMoveAccess().getResourceItemResourceItemCrossReference_6_1_0());
					}
					ruleIID
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_10='.'
		{
			newLeafNode(otherlv_10, grammarAccess.getMoveAccess().getFullStopKeyword_7());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getMoveRule());
					}
				}
				otherlv_11=RULE_ID
				{
					newLeafNode(otherlv_11, grammarAccess.getMoveAccess().getPeripheralPeripheralCrossReference_8_0());
				}
			)
		)
		(
			(
				(
					(
						(
							lv_passing_12_0='passing'
							{
								newLeafNode(lv_passing_12_0, grammarAccess.getMoveAccess().getPassingPassingKeyword_9_0_0_0_0());
							}
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getMoveRule());
								}
								setWithLastConsumed($current, "passing", lv_passing_12_0 != null, "passing");
							}
						)
					)
					    |
					otherlv_13='to'
					{
						newLeafNode(otherlv_13, grammarAccess.getMoveAccess().getToKeyword_9_0_0_1());
					}
				)
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getMoveRule());
							}
						}
						otherlv_14=RULE_ID
						{
							newLeafNode(otherlv_14, grammarAccess.getMoveAccess().getTargetPositionSymbolicPositionCrossReference_9_0_1_0());
						}
					)
				)
			)
			    |
			(
				(
					(
						(
							lv_continuing_15_0='continuing'
							{
								newLeafNode(lv_continuing_15_0, grammarAccess.getMoveAccess().getContinuingContinuingKeyword_9_1_0_0_0());
							}
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getMoveRule());
								}
								setWithLastConsumed($current, "continuing", lv_continuing_15_0 != null, "continuing");
							}
						)
					)
					    |
					otherlv_16='for'
					{
						newLeafNode(otherlv_16, grammarAccess.getMoveAccess().getForKeyword_9_1_0_1());
					}
				)
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getMoveRule());
							}
						}
						otherlv_17=RULE_ID
						{
							newLeafNode(otherlv_17, grammarAccess.getMoveAccess().getDistanceDistanceCrossReference_9_1_1_0());
						}
					)
				)
			)
		)
		(
			otherlv_18='with speed profile'
			{
				newLeafNode(otherlv_18, grammarAccess.getMoveAccess().getWithSpeedProfileKeyword_10_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getMoveRule());
						}
					}
					otherlv_19=RULE_ID
					{
						newLeafNode(otherlv_19, grammarAccess.getMoveAccess().getProfileProfileCrossReference_10_1_0());
					}
				)
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getMoveAccess().getSchedulingTypeSchedulingEnumRuleCall_11_0());
				}
				lv_schedulingType_20_0=ruleScheduling
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getMoveRule());
					}
					set(
						$current,
						"schedulingType",
						lv_schedulingType_20_0,
						"org.eclipse.lsat.activity.teditor.Activity.Scheduling");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getMoveAccess().getProductChangesProductChangeParserRuleCall_12_0_0());
					}
					lv_productChanges_21_0=ruleProductChange
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMoveRule());
						}
						add(
							$current,
							"productChanges",
							lv_productChanges_21_0,
							"org.eclipse.lsat.activity.teditor.Activity.ProductChange");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getMoveAccess().getProductChangesProductChangeWithTransferTypeParserRuleCall_12_1_0());
					}
					lv_productChanges_22_0=ruleProductChangeWithTransferType
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMoveRule());
						}
						add(
							$current,
							"productChanges",
							lv_productChanges_22_0,
							"org.eclipse.lsat.activity.teditor.Activity.ProductChangeWithTransferType");
						afterParserOrEnumRuleCall();
					}
				)
			)*
		)?
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getMoveAccess().getExitTracePointParserRuleCall_13_0_0());
					}
					lv_exit_23_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getMoveRule());
						}
						set(
							$current,
							"exit",
							lv_exit_23_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getMoveAccess().getExitTracePointParserRuleCall_13_1_0_0());
						}
						lv_exit_24_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getMoveRule());
							}
							set(
								$current,
								"exit",
								lv_exit_24_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getMoveAccess().getOuterExitTracePointParserRuleCall_13_1_1_0());
						}
						lv_outerExit_25_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getMoveRule());
							}
							set(
								$current,
								"outerExit",
								lv_outerExit_25_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleSimpleAction
entryRuleSimpleAction returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSimpleActionRule()); }
	iv_ruleSimpleAction=ruleSimpleAction
	{ $current=$iv_ruleSimpleAction.current; }
	EOF;

// Rule SimpleAction
ruleSimpleAction returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSimpleActionAccess().getSimpleActionAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getSimpleActionAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSimpleActionRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getSimpleActionAccess().getColonKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getSimpleActionAccess().getEntryTracePointParserRuleCall_3_0_0());
					}
					lv_entry_3_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
						}
						set(
							$current,
							"entry",
							lv_entry_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getSimpleActionAccess().getOuterEntryTracePointParserRuleCall_3_1_0_0());
						}
						lv_outerEntry_4_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
							}
							set(
								$current,
								"outerEntry",
								lv_outerEntry_4_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getSimpleActionAccess().getEntryTracePointParserRuleCall_3_1_1_0());
						}
						lv_entry_5_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
							}
							set(
								$current,
								"entry",
								lv_entry_5_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
		(
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSimpleActionRule());
						}
					}
					otherlv_6=RULE_ID
					{
						newLeafNode(otherlv_6, grammarAccess.getSimpleActionAccess().getResourceDefinitionResourceCrossReference_4_0_0());
					}
				)
			)
			otherlv_7='.'
			{
				newLeafNode(otherlv_7, grammarAccess.getSimpleActionAccess().getFullStopKeyword_4_1());
			}
			(
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getSimpleActionRule());
							}
						}
						{
							newCompositeNode(grammarAccess.getSimpleActionAccess().getResourceItemResourceItemCrossReference_4_2_0_0());
						}
						ruleIID
						{
							afterParserOrEnumRuleCall();
						}
					)
				)
				otherlv_9='.'
				{
					newLeafNode(otherlv_9, grammarAccess.getSimpleActionAccess().getFullStopKeyword_4_2_1());
				}
			)?
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSimpleActionRule());
						}
					}
					otherlv_10=RULE_ID
					{
						newLeafNode(otherlv_10, grammarAccess.getSimpleActionAccess().getPeripheralPeripheralCrossReference_4_3_0());
					}
				)
			)
			otherlv_11='.'
			{
				newLeafNode(otherlv_11, grammarAccess.getSimpleActionAccess().getFullStopKeyword_4_4());
			}
		)?
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getSimpleActionRule());
					}
				}
				otherlv_12=RULE_ID
				{
					newLeafNode(otherlv_12, grammarAccess.getSimpleActionAccess().getTypeActionTypeCrossReference_5_0());
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getSimpleActionAccess().getSchedulingTypeSchedulingEnumRuleCall_6_0());
				}
				lv_schedulingType_13_0=ruleScheduling
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
					}
					set(
						$current,
						"schedulingType",
						lv_schedulingType_13_0,
						"org.eclipse.lsat.activity.teditor.Activity.Scheduling");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getSimpleActionAccess().getProductChangesProductChangeParserRuleCall_7_0_0());
					}
					lv_productChanges_14_0=ruleProductChange
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
						}
						add(
							$current,
							"productChanges",
							lv_productChanges_14_0,
							"org.eclipse.lsat.activity.teditor.Activity.ProductChange");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getSimpleActionAccess().getProductChangesProductChangeWithTransferTypeParserRuleCall_7_1_0());
					}
					lv_productChanges_15_0=ruleProductChangeWithTransferType
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
						}
						add(
							$current,
							"productChanges",
							lv_productChanges_15_0,
							"org.eclipse.lsat.activity.teditor.Activity.ProductChangeWithTransferType");
						afterParserOrEnumRuleCall();
					}
				)
			)*
		)?
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getSimpleActionAccess().getExitTracePointParserRuleCall_8_0_0());
					}
					lv_exit_16_0=ruleTracePoint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
						}
						set(
							$current,
							"exit",
							lv_exit_16_0,
							"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			    |
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getSimpleActionAccess().getExitTracePointParserRuleCall_8_1_0_0());
						}
						lv_exit_17_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
							}
							set(
								$current,
								"exit",
								lv_exit_17_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					(
						{
							newCompositeNode(grammarAccess.getSimpleActionAccess().getOuterExitTracePointParserRuleCall_8_1_1_0());
						}
						lv_outerExit_18_0=ruleTracePoint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getSimpleActionRule());
							}
							set(
								$current,
								"outerExit",
								lv_outerExit_18_0,
								"org.eclipse.lsat.activity.teditor.Activity.TracePoint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)?
	)
;

// Entry rule entryRuleProductChange
entryRuleProductChange returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getProductChangeRule()); }
	iv_ruleProductChange=ruleProductChange
	{ $current=$iv_ruleProductChange.current; }
	EOF;

// Rule ProductChange
ruleProductChange returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getProductChangeAccess().getProductChangeWithTransferTypeParserRuleCall_0());
		}
		this_ProductChangeWithTransferType_0=ruleProductChangeWithTransferType
		{
			$current = $this_ProductChangeWithTransferType_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getProductChangeAccess().getProductChangeNoTransferTypeParserRuleCall_1());
		}
		this_ProductChangeNoTransferType_1=ruleProductChangeNoTransferType
		{
			$current = $this_ProductChangeNoTransferType_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleProductChangeNoTransferType
entryRuleProductChangeNoTransferType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getProductChangeNoTransferTypeRule()); }
	iv_ruleProductChangeNoTransferType=ruleProductChangeNoTransferType
	{ $current=$iv_ruleProductChangeNoTransferType.current; }
	EOF;

// Rule ProductChangeNoTransferType
ruleProductChangeNoTransferType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getProductChangeNoTransferTypeAccess().getProductChangeAction_0(),
					$current);
			}
		)
		(
			(
				(
					otherlv_1='product'
					{
						newLeafNode(otherlv_1, grammarAccess.getProductChangeNoTransferTypeAccess().getProductKeyword_1_0_0_0());
					}
					(
						(
							{
								if ($current==null) {
									$current = createModelElement(grammarAccess.getProductChangeNoTransferTypeRule());
								}
							}
							otherlv_2=RULE_ID
							{
								newLeafNode(otherlv_2, grammarAccess.getProductChangeNoTransferTypeAccess().getProductProductDefinitionCrossReference_1_0_0_1_0());
							}
						)
					)
				)
				(
					(
						otherlv_3='slot'
						{
							newLeafNode(otherlv_3, grammarAccess.getProductChangeNoTransferTypeAccess().getSlotKeyword_1_0_1_0());
						}
					)?
					(
						(
							{
								newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getSlotIIDParserRuleCall_1_0_1_1_0());
							}
							lv_slot_4_0=ruleIID
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
								}
								set(
									$current,
									"slot",
									lv_slot_4_0,
									"org.eclipse.lsat.activity.teditor.Activity.IID");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)?
				(
					otherlv_5='@start'
					{
						newLeafNode(otherlv_5, grammarAccess.getProductChangeNoTransferTypeAccess().getStartKeyword_1_0_2_0());
					}
					otherlv_6='('
					{
						newLeafNode(otherlv_6, grammarAccess.getProductChangeNoTransferTypeAccess().getLeftParenthesisKeyword_1_0_2_1());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesPropertyParserRuleCall_1_0_2_2_0());
							}
							lv_startProperties_7_0=ruleProperty
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
								}
								add(
									$current,
									"startProperties",
									lv_startProperties_7_0,
									"org.eclipse.lsat.activity.teditor.Activity.Property");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_8=','
						{
							newLeafNode(otherlv_8, grammarAccess.getProductChangeNoTransferTypeAccess().getCommaKeyword_1_0_2_3_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesPropertyParserRuleCall_1_0_2_3_1_0());
								}
								lv_startProperties_9_0=ruleProperty
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
									}
									add(
										$current,
										"startProperties",
										lv_startProperties_9_0,
										"org.eclipse.lsat.activity.teditor.Activity.Property");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
					otherlv_10=')'
					{
						newLeafNode(otherlv_10, grammarAccess.getProductChangeNoTransferTypeAccess().getRightParenthesisKeyword_1_0_2_4());
					}
				)?
				(
					otherlv_11='@end'
					{
						newLeafNode(otherlv_11, grammarAccess.getProductChangeNoTransferTypeAccess().getEndKeyword_1_0_3_0());
					}
					otherlv_12='('
					{
						newLeafNode(otherlv_12, grammarAccess.getProductChangeNoTransferTypeAccess().getLeftParenthesisKeyword_1_0_3_1());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesPropertyParserRuleCall_1_0_3_2_0());
							}
							lv_endProperties_13_0=ruleProperty
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
								}
								add(
									$current,
									"endProperties",
									lv_endProperties_13_0,
									"org.eclipse.lsat.activity.teditor.Activity.Property");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_14=','
						{
							newLeafNode(otherlv_14, grammarAccess.getProductChangeNoTransferTypeAccess().getCommaKeyword_1_0_3_3_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesPropertyParserRuleCall_1_0_3_3_1_0());
								}
								lv_endProperties_15_0=ruleProperty
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
									}
									add(
										$current,
										"endProperties",
										lv_endProperties_15_0,
										"org.eclipse.lsat.activity.teditor.Activity.Property");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
					otherlv_16=')'
					{
						newLeafNode(otherlv_16, grammarAccess.getProductChangeNoTransferTypeAccess().getRightParenthesisKeyword_1_0_3_4());
					}
				)?
			)
			    |
			(
				(
					(
						otherlv_17='slot'
						{
							newLeafNode(otherlv_17, grammarAccess.getProductChangeNoTransferTypeAccess().getSlotKeyword_1_1_0_0());
						}
					)?
					(
						(
							{
								newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getSlotIIDParserRuleCall_1_1_0_1_0());
							}
							lv_slot_18_0=ruleIID
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
								}
								set(
									$current,
									"slot",
									lv_slot_18_0,
									"org.eclipse.lsat.activity.teditor.Activity.IID");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)
				(
					otherlv_19='@start'
					{
						newLeafNode(otherlv_19, grammarAccess.getProductChangeNoTransferTypeAccess().getStartKeyword_1_1_1_0());
					}
					otherlv_20='('
					{
						newLeafNode(otherlv_20, grammarAccess.getProductChangeNoTransferTypeAccess().getLeftParenthesisKeyword_1_1_1_1());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesPropertyParserRuleCall_1_1_1_2_0());
							}
							lv_startProperties_21_0=ruleProperty
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
								}
								add(
									$current,
									"startProperties",
									lv_startProperties_21_0,
									"org.eclipse.lsat.activity.teditor.Activity.Property");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_22=','
						{
							newLeafNode(otherlv_22, grammarAccess.getProductChangeNoTransferTypeAccess().getCommaKeyword_1_1_1_3_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesPropertyParserRuleCall_1_1_1_3_1_0());
								}
								lv_startProperties_23_0=ruleProperty
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
									}
									add(
										$current,
										"startProperties",
										lv_startProperties_23_0,
										"org.eclipse.lsat.activity.teditor.Activity.Property");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
					otherlv_24=')'
					{
						newLeafNode(otherlv_24, grammarAccess.getProductChangeNoTransferTypeAccess().getRightParenthesisKeyword_1_1_1_4());
					}
				)?
				(
					otherlv_25='@end'
					{
						newLeafNode(otherlv_25, grammarAccess.getProductChangeNoTransferTypeAccess().getEndKeyword_1_1_2_0());
					}
					otherlv_26='('
					{
						newLeafNode(otherlv_26, grammarAccess.getProductChangeNoTransferTypeAccess().getLeftParenthesisKeyword_1_1_2_1());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesPropertyParserRuleCall_1_1_2_2_0());
							}
							lv_endProperties_27_0=ruleProperty
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
								}
								add(
									$current,
									"endProperties",
									lv_endProperties_27_0,
									"org.eclipse.lsat.activity.teditor.Activity.Property");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_28=','
						{
							newLeafNode(otherlv_28, grammarAccess.getProductChangeNoTransferTypeAccess().getCommaKeyword_1_1_2_3_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesPropertyParserRuleCall_1_1_2_3_1_0());
								}
								lv_endProperties_29_0=ruleProperty
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
									}
									add(
										$current,
										"endProperties",
										lv_endProperties_29_0,
										"org.eclipse.lsat.activity.teditor.Activity.Property");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
					otherlv_30=')'
					{
						newLeafNode(otherlv_30, grammarAccess.getProductChangeNoTransferTypeAccess().getRightParenthesisKeyword_1_1_2_4());
					}
				)?
			)
			    |
			(
				(
					otherlv_31='@start'
					{
						newLeafNode(otherlv_31, grammarAccess.getProductChangeNoTransferTypeAccess().getStartKeyword_1_2_0_0());
					}
					otherlv_32='('
					{
						newLeafNode(otherlv_32, grammarAccess.getProductChangeNoTransferTypeAccess().getLeftParenthesisKeyword_1_2_0_1());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesPropertyParserRuleCall_1_2_0_2_0());
							}
							lv_startProperties_33_0=ruleProperty
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
								}
								add(
									$current,
									"startProperties",
									lv_startProperties_33_0,
									"org.eclipse.lsat.activity.teditor.Activity.Property");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_34=','
						{
							newLeafNode(otherlv_34, grammarAccess.getProductChangeNoTransferTypeAccess().getCommaKeyword_1_2_0_3_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getStartPropertiesPropertyParserRuleCall_1_2_0_3_1_0());
								}
								lv_startProperties_35_0=ruleProperty
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
									}
									add(
										$current,
										"startProperties",
										lv_startProperties_35_0,
										"org.eclipse.lsat.activity.teditor.Activity.Property");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
					otherlv_36=')'
					{
						newLeafNode(otherlv_36, grammarAccess.getProductChangeNoTransferTypeAccess().getRightParenthesisKeyword_1_2_0_4());
					}
				)
				(
					otherlv_37='@end'
					{
						newLeafNode(otherlv_37, grammarAccess.getProductChangeNoTransferTypeAccess().getEndKeyword_1_2_1_0());
					}
					otherlv_38='('
					{
						newLeafNode(otherlv_38, grammarAccess.getProductChangeNoTransferTypeAccess().getLeftParenthesisKeyword_1_2_1_1());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesPropertyParserRuleCall_1_2_1_2_0());
							}
							lv_endProperties_39_0=ruleProperty
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
								}
								add(
									$current,
									"endProperties",
									lv_endProperties_39_0,
									"org.eclipse.lsat.activity.teditor.Activity.Property");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_40=','
						{
							newLeafNode(otherlv_40, grammarAccess.getProductChangeNoTransferTypeAccess().getCommaKeyword_1_2_1_3_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesPropertyParserRuleCall_1_2_1_3_1_0());
								}
								lv_endProperties_41_0=ruleProperty
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
									}
									add(
										$current,
										"endProperties",
										lv_endProperties_41_0,
										"org.eclipse.lsat.activity.teditor.Activity.Property");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
					otherlv_42=')'
					{
						newLeafNode(otherlv_42, grammarAccess.getProductChangeNoTransferTypeAccess().getRightParenthesisKeyword_1_2_1_4());
					}
				)?
			)
			    |
			(
				otherlv_43='@end'
				{
					newLeafNode(otherlv_43, grammarAccess.getProductChangeNoTransferTypeAccess().getEndKeyword_1_3_0());
				}
				otherlv_44='('
				{
					newLeafNode(otherlv_44, grammarAccess.getProductChangeNoTransferTypeAccess().getLeftParenthesisKeyword_1_3_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesPropertyParserRuleCall_1_3_2_0());
						}
						lv_endProperties_45_0=ruleProperty
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
							}
							add(
								$current,
								"endProperties",
								lv_endProperties_45_0,
								"org.eclipse.lsat.activity.teditor.Activity.Property");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_46=','
					{
						newLeafNode(otherlv_46, grammarAccess.getProductChangeNoTransferTypeAccess().getCommaKeyword_1_3_3_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getProductChangeNoTransferTypeAccess().getEndPropertiesPropertyParserRuleCall_1_3_3_1_0());
							}
							lv_endProperties_47_0=ruleProperty
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getProductChangeNoTransferTypeRule());
								}
								add(
									$current,
									"endProperties",
									lv_endProperties_47_0,
									"org.eclipse.lsat.activity.teditor.Activity.Property");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
				otherlv_48=')'
				{
					newLeafNode(otherlv_48, grammarAccess.getProductChangeNoTransferTypeAccess().getRightParenthesisKeyword_1_3_4());
				}
			)
		)
	)
;

// Entry rule entryRuleProductChangeWithTransferType
entryRuleProductChangeWithTransferType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getProductChangeWithTransferTypeRule()); }
	iv_ruleProductChangeWithTransferType=ruleProductChangeWithTransferType
	{ $current=$iv_ruleProductChangeWithTransferType.current; }
	EOF;

// Rule ProductChangeWithTransferType
ruleProductChangeWithTransferType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getProductChangeWithTransferTypeAccess().getProductChangeAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getProductChangeWithTransferTypeAccess().getTransferTypeTransferTypeEnumRuleCall_1_0());
				}
				lv_transferType_1_0=ruleTransferType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getProductChangeWithTransferTypeRule());
					}
					set(
						$current,
						"transferType",
						lv_transferType_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.TransferType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_2='product'
			{
				newLeafNode(otherlv_2, grammarAccess.getProductChangeWithTransferTypeAccess().getProductKeyword_2_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getProductChangeWithTransferTypeRule());
						}
					}
					otherlv_3=RULE_ID
					{
						newLeafNode(otherlv_3, grammarAccess.getProductChangeWithTransferTypeAccess().getProductProductDefinitionCrossReference_2_1_0());
					}
				)
			)
		)?
		(
			(
				otherlv_4='slot'
				{
					newLeafNode(otherlv_4, grammarAccess.getProductChangeWithTransferTypeAccess().getSlotKeyword_3_0());
				}
			)?
			(
				(
					{
						newCompositeNode(grammarAccess.getProductChangeWithTransferTypeAccess().getSlotIIDParserRuleCall_3_1_0());
					}
					lv_slot_5_0=ruleIID
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getProductChangeWithTransferTypeRule());
						}
						set(
							$current,
							"slot",
							lv_slot_5_0,
							"org.eclipse.lsat.activity.teditor.Activity.IID");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		(
			otherlv_6='@start'
			{
				newLeafNode(otherlv_6, grammarAccess.getProductChangeWithTransferTypeAccess().getStartKeyword_4_0());
			}
			otherlv_7='('
			{
				newLeafNode(otherlv_7, grammarAccess.getProductChangeWithTransferTypeAccess().getLeftParenthesisKeyword_4_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getProductChangeWithTransferTypeAccess().getStartPropertiesPropertyParserRuleCall_4_2_0());
					}
					lv_startProperties_8_0=ruleProperty
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getProductChangeWithTransferTypeRule());
						}
						add(
							$current,
							"startProperties",
							lv_startProperties_8_0,
							"org.eclipse.lsat.activity.teditor.Activity.Property");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_9=','
				{
					newLeafNode(otherlv_9, grammarAccess.getProductChangeWithTransferTypeAccess().getCommaKeyword_4_3_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getProductChangeWithTransferTypeAccess().getStartPropertiesPropertyParserRuleCall_4_3_1_0());
						}
						lv_startProperties_10_0=ruleProperty
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getProductChangeWithTransferTypeRule());
							}
							add(
								$current,
								"startProperties",
								lv_startProperties_10_0,
								"org.eclipse.lsat.activity.teditor.Activity.Property");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_11=')'
			{
				newLeafNode(otherlv_11, grammarAccess.getProductChangeWithTransferTypeAccess().getRightParenthesisKeyword_4_4());
			}
		)?
		(
			otherlv_12='@end'
			{
				newLeafNode(otherlv_12, grammarAccess.getProductChangeWithTransferTypeAccess().getEndKeyword_5_0());
			}
			otherlv_13='('
			{
				newLeafNode(otherlv_13, grammarAccess.getProductChangeWithTransferTypeAccess().getLeftParenthesisKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getProductChangeWithTransferTypeAccess().getEndPropertiesPropertyParserRuleCall_5_2_0());
					}
					lv_endProperties_14_0=ruleProperty
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getProductChangeWithTransferTypeRule());
						}
						add(
							$current,
							"endProperties",
							lv_endProperties_14_0,
							"org.eclipse.lsat.activity.teditor.Activity.Property");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_15=','
				{
					newLeafNode(otherlv_15, grammarAccess.getProductChangeWithTransferTypeAccess().getCommaKeyword_5_3_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getProductChangeWithTransferTypeAccess().getEndPropertiesPropertyParserRuleCall_5_3_1_0());
						}
						lv_endProperties_16_0=ruleProperty
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getProductChangeWithTransferTypeRule());
							}
							add(
								$current,
								"endProperties",
								lv_endProperties_16_0,
								"org.eclipse.lsat.activity.teditor.Activity.Property");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_17=')'
			{
				newLeafNode(otherlv_17, grammarAccess.getProductChangeWithTransferTypeAccess().getRightParenthesisKeyword_5_4());
			}
		)?
	)
;

// Entry rule entryRuleProperty
entryRuleProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPropertyRule()); }
	iv_ruleProperty=ruleProperty
	{ $current=$iv_ruleProperty.current; }
	EOF;

// Rule Property
ruleProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPropertyAccess().getPropertyAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPropertyRule());
					}
				}
				otherlv_1=RULE_ID
				{
					newLeafNode(otherlv_1, grammarAccess.getPropertyAccess().getDefinitionPropertyDefinitionCrossReference_1_0());
				}
			)
		)
		otherlv_2=':'
		{
			newLeafNode(otherlv_2, grammarAccess.getPropertyAccess().getColonKeyword_2());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getPropertyAccess().getValueBooleanValueParserRuleCall_3_0_0());
					}
					lv_value_3_1=ruleBooleanValue
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPropertyRule());
						}
						set(
							$current,
							"value",
							lv_value_3_1,
							"org.eclipse.lsat.activity.teditor.Activity.BooleanValue");
						afterParserOrEnumRuleCall();
					}
					    |
					{
						newCompositeNode(grammarAccess.getPropertyAccess().getValueIntegerValueParserRuleCall_3_0_1());
					}
					lv_value_3_2=ruleIntegerValue
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPropertyRule());
						}
						set(
							$current,
							"value",
							lv_value_3_2,
							"org.eclipse.lsat.activity.teditor.Activity.IntegerValue");
						afterParserOrEnumRuleCall();
					}
					    |
					{
						newCompositeNode(grammarAccess.getPropertyAccess().getValueStringValueParserRuleCall_3_0_2());
					}
					lv_value_3_3=ruleStringValue
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPropertyRule());
						}
						set(
							$current,
							"value",
							lv_value_3_3,
							"org.eclipse.lsat.activity.teditor.Activity.StringValue");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
	)
;

// Entry rule entryRuleBooleanValue
entryRuleBooleanValue returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBooleanValueRule()); }
	iv_ruleBooleanValue=ruleBooleanValue
	{ $current=$iv_ruleBooleanValue.current; }
	EOF;

// Rule BooleanValue
ruleBooleanValue returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getBooleanValueAccess().getBooleanValueAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getBooleanValueAccess().getValueBooleanLiteralParserRuleCall_1_0());
				}
				lv_value_1_0=ruleBooleanLiteral
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getBooleanValueRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.BooleanLiteral");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleBooleanLiteral
entryRuleBooleanLiteral returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBooleanLiteralRule()); }
	iv_ruleBooleanLiteral=ruleBooleanLiteral
	{ $current=$iv_ruleBooleanLiteral.current.getText(); }
	EOF;

// Rule BooleanLiteral
ruleBooleanLiteral returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='True'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getBooleanLiteralAccess().getTrueKeyword_0());
		}
		    |
		kw='False'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getBooleanLiteralAccess().getFalseKeyword_1());
		}
	)
;

// Entry rule entryRuleIntegerValue
entryRuleIntegerValue returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getIntegerValueRule()); }
	iv_ruleIntegerValue=ruleIntegerValue
	{ $current=$iv_ruleIntegerValue.current; }
	EOF;

// Rule IntegerValue
ruleIntegerValue returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getIntegerValueAccess().getIntegerValueAction_0(),
					$current);
			}
		)
		(
			(
				lv_value_1_0=RULE_INT
				{
					newLeafNode(lv_value_1_0, grammarAccess.getIntegerValueAccess().getValueINTTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getIntegerValueRule());
					}
					setWithLastConsumed(
						$current,
						"value",
						lv_value_1_0,
						"org.eclipse.xtext.common.Terminals.INT");
				}
			)
		)
	)
;

// Entry rule entryRuleStringValue
entryRuleStringValue returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getStringValueRule()); }
	iv_ruleStringValue=ruleStringValue
	{ $current=$iv_ruleStringValue.current; }
	EOF;

// Rule StringValue
ruleStringValue returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getStringValueAccess().getStringValueAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getStringValueAccess().getValueEStringParserRuleCall_1_0());
				}
				lv_value_1_0=ruleEString
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getStringValueRule());
					}
					set(
						$current,
						"value",
						lv_value_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.EString");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleTracePoint
entryRuleTracePoint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTracePointRule()); }
	iv_ruleTracePoint=ruleTracePoint
	{ $current=$iv_ruleTracePoint.current; }
	EOF;

// Rule TracePoint
ruleTracePoint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='['
		{
			newLeafNode(otherlv_0, grammarAccess.getTracePointAccess().getLeftSquareBracketKeyword_0());
		}
		(
			(
				lv_regex_1_0='~'
				{
					newLeafNode(lv_regex_1_0, grammarAccess.getTracePointAccess().getRegexTildeKeyword_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getTracePointRule());
					}
					setWithLastConsumed($current, "regex", lv_regex_1_0 != null, "~");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getTracePointAccess().getValueEStringParserRuleCall_2_0());
				}
				lv_value_2_0=ruleEString
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTracePointRule());
					}
					set(
						$current,
						"value",
						lv_value_2_0,
						"org.eclipse.lsat.activity.teditor.Activity.EString");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3=']'
		{
			newLeafNode(otherlv_3, grammarAccess.getTracePointAccess().getRightSquareBracketKeyword_3());
		}
	)
;

// Entry rule entryRuleEdges
entryRuleEdges returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEdgesRule()); }
	iv_ruleEdges=ruleEdges
	{ $current=$iv_ruleEdges.current; }
	EOF;

// Rule Edges
ruleEdges returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getEdgesAccess().getEdgeParserRuleCall_0());
		}
		this_Edge_0=ruleEdge
		{
			$current = $this_Edge_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getEdgesAccess().getJitConstraintEdgeParserRuleCall_1());
		}
		this_JitConstraintEdge_1=ruleJitConstraintEdge
		{
			$current = $this_JitConstraintEdge_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getEdgesAccess().getTimeConstraintEdgeParserRuleCall_2());
		}
		this_TimeConstraintEdge_2=ruleTimeConstraintEdge
		{
			$current = $this_TimeConstraintEdge_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleEdge
entryRuleEdge returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEdgeRule()); }
	iv_ruleEdge=ruleEdge
	{ $current=$iv_ruleEdge.current; }
	EOF;

// Rule Edge
ruleEdge returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEdgeAccess().getDependencyAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getEdgeAccess().getSourceSourceReferenceParserRuleCall_1_0());
				}
				lv_source_1_0=ruleSourceReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEdgeRule());
					}
					set(
						$current,
						"source",
						lv_source_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.SourceReference");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='->'
		{
			newLeafNode(otherlv_2, grammarAccess.getEdgeAccess().getHyphenMinusGreaterThanSignKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEdgeAccess().getTargetDependencyTargetParserRuleCall_3_0());
				}
				lv_target_3_0=ruleDependencyTarget
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEdgeRule());
					}
					set(
						$current,
						"target",
						lv_target_3_0,
						"org.eclipse.lsat.activity.teditor.Activity.DependencyTarget");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleJitConstraintEdge
entryRuleJitConstraintEdge returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getJitConstraintEdgeRule()); }
	iv_ruleJitConstraintEdge=ruleJitConstraintEdge
	{ $current=$iv_ruleJitConstraintEdge.current; }
	EOF;

// Rule JitConstraintEdge
ruleJitConstraintEdge returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getJitConstraintEdgeAccess().getDependencyAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getJitConstraintEdgeAccess().getSourceSourceReferenceParserRuleCall_1_0());
				}
				lv_source_1_0=ruleSourceReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getJitConstraintEdgeRule());
					}
					set(
						$current,
						"source",
						lv_source_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.SourceReference");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='-jit->'
		{
			newLeafNode(otherlv_2, grammarAccess.getJitConstraintEdgeAccess().getJitKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getJitConstraintEdgeAccess().getBoundsJitConstraintParserRuleCall_3_0());
				}
				lv_bounds_3_0=ruleJitConstraint
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getJitConstraintEdgeRule());
					}
					set(
						$current,
						"bounds",
						lv_bounds_3_0,
						"org.eclipse.lsat.activity.teditor.Activity.JitConstraint");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getJitConstraintEdgeAccess().getTargetDependencyTargetParserRuleCall_4_0());
				}
				lv_target_4_0=ruleDependencyTarget
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getJitConstraintEdgeRule());
					}
					set(
						$current,
						"target",
						lv_target_4_0,
						"org.eclipse.lsat.activity.teditor.Activity.DependencyTarget");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleTimeConstraintEdge
entryRuleTimeConstraintEdge returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTimeConstraintEdgeRule()); }
	iv_ruleTimeConstraintEdge=ruleTimeConstraintEdge
	{ $current=$iv_ruleTimeConstraintEdge.current; }
	EOF;

// Rule TimeConstraintEdge
ruleTimeConstraintEdge returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getTimeConstraintEdgeAccess().getDependencyAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getTimeConstraintEdgeAccess().getSourceSourceReferenceParserRuleCall_1_0());
				}
				lv_source_1_0=ruleSourceReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTimeConstraintEdgeRule());
					}
					set(
						$current,
						"source",
						lv_source_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.SourceReference");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='-['
		{
			newLeafNode(otherlv_2, grammarAccess.getTimeConstraintEdgeAccess().getHyphenMinusLeftSquareBracketKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTimeConstraintEdgeAccess().getBoundsTimeConstraintParserRuleCall_3_0());
				}
				lv_bounds_3_0=ruleTimeConstraint
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTimeConstraintEdgeRule());
					}
					set(
						$current,
						"bounds",
						lv_bounds_3_0,
						"org.eclipse.lsat.activity.teditor.Activity.TimeConstraint");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=']->'
		{
			newLeafNode(otherlv_4, grammarAccess.getTimeConstraintEdgeAccess().getRightSquareBracketHyphenMinusGreaterThanSignKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTimeConstraintEdgeAccess().getTargetDependencyTargetParserRuleCall_5_0());
				}
				lv_target_5_0=ruleDependencyTarget
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTimeConstraintEdgeRule());
					}
					set(
						$current,
						"target",
						lv_target_5_0,
						"org.eclipse.lsat.activity.teditor.Activity.DependencyTarget");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleEdgesWithConstraints
entryRuleEdgesWithConstraints returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEdgesWithConstraintsRule()); }
	iv_ruleEdgesWithConstraints=ruleEdgesWithConstraints
	{ $current=$iv_ruleEdgesWithConstraints.current; }
	EOF;

// Rule EdgesWithConstraints
ruleEdgesWithConstraints returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getEdgesWithConstraintsAccess().getEdgeWithJitConstraintParserRuleCall_0());
		}
		this_EdgeWithJitConstraint_0=ruleEdgeWithJitConstraint
		{
			$current = $this_EdgeWithJitConstraint_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getEdgesWithConstraintsAccess().getEdgeWithTimeConstraintParserRuleCall_1());
		}
		this_EdgeWithTimeConstraint_1=ruleEdgeWithTimeConstraint
		{
			$current = $this_EdgeWithTimeConstraint_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getEdgesWithConstraintsAccess().getEdgeWithInfiniteTimeConstraintParserRuleCall_2());
		}
		this_EdgeWithInfiniteTimeConstraint_2=ruleEdgeWithInfiniteTimeConstraint
		{
			$current = $this_EdgeWithInfiniteTimeConstraint_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleEdgeWithJitConstraint
entryRuleEdgeWithJitConstraint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEdgeWithJitConstraintRule()); }
	iv_ruleEdgeWithJitConstraint=ruleEdgeWithJitConstraint
	{ $current=$iv_ruleEdgeWithJitConstraint.current; }
	EOF;

// Rule EdgeWithJitConstraint
ruleEdgeWithJitConstraint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEdgeWithJitConstraintAccess().getConstraintEdgeAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEdgeWithJitConstraintRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getEdgeWithJitConstraintAccess().getSourceResourceActionCrossReference_1_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='-jit->'
		{
			newLeafNode(otherlv_2, grammarAccess.getEdgeWithJitConstraintAccess().getJitKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEdgeWithJitConstraintAccess().getBoundsJitConstraintParserRuleCall_3_0());
				}
				lv_bounds_3_0=ruleJitConstraint
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEdgeWithJitConstraintRule());
					}
					set(
						$current,
						"bounds",
						lv_bounds_3_0,
						"org.eclipse.lsat.activity.teditor.Activity.JitConstraint");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEdgeWithJitConstraintRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getEdgeWithJitConstraintAccess().getTargetResourceActionCrossReference_4_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleEdgeWithTimeConstraint
entryRuleEdgeWithTimeConstraint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEdgeWithTimeConstraintRule()); }
	iv_ruleEdgeWithTimeConstraint=ruleEdgeWithTimeConstraint
	{ $current=$iv_ruleEdgeWithTimeConstraint.current; }
	EOF;

// Rule EdgeWithTimeConstraint
ruleEdgeWithTimeConstraint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEdgeWithTimeConstraintAccess().getConstraintEdgeAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEdgeWithTimeConstraintRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getEdgeWithTimeConstraintAccess().getSourceResourceActionCrossReference_1_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='-['
		{
			newLeafNode(otherlv_2, grammarAccess.getEdgeWithTimeConstraintAccess().getHyphenMinusLeftSquareBracketKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEdgeWithTimeConstraintAccess().getBoundsTimeConstraintParserRuleCall_3_0());
				}
				lv_bounds_3_0=ruleTimeConstraint
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEdgeWithTimeConstraintRule());
					}
					set(
						$current,
						"bounds",
						lv_bounds_3_0,
						"org.eclipse.lsat.activity.teditor.Activity.TimeConstraint");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4=']->'
		{
			newLeafNode(otherlv_4, grammarAccess.getEdgeWithTimeConstraintAccess().getRightSquareBracketHyphenMinusGreaterThanSignKeyword_4());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEdgeWithTimeConstraintRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getEdgeWithTimeConstraintAccess().getTargetResourceActionCrossReference_5_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleEdgeWithInfiniteTimeConstraint
entryRuleEdgeWithInfiniteTimeConstraint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEdgeWithInfiniteTimeConstraintRule()); }
	iv_ruleEdgeWithInfiniteTimeConstraint=ruleEdgeWithInfiniteTimeConstraint
	{ $current=$iv_ruleEdgeWithInfiniteTimeConstraint.current; }
	EOF;

// Rule EdgeWithInfiniteTimeConstraint
ruleEdgeWithInfiniteTimeConstraint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getConstraintEdgeAction_0(),
					$current);
			}
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEdgeWithInfiniteTimeConstraintRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getSourceResourceActionCrossReference_1_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='->'
		{
			newLeafNode(otherlv_2, grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getHyphenMinusGreaterThanSignKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getBoundsInfiniteTimeConstraintParserRuleCall_3_0());
				}
				lv_bounds_3_0=ruleInfiniteTimeConstraint
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEdgeWithInfiniteTimeConstraintRule());
					}
					set(
						$current,
						"bounds",
						lv_bounds_3_0,
						"org.eclipse.lsat.activity.teditor.Activity.InfiniteTimeConstraint");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEdgeWithInfiniteTimeConstraintRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getEdgeWithInfiniteTimeConstraintAccess().getTargetResourceActionCrossReference_4_0());
				}
				ruleIID
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleJitConstraint
entryRuleJitConstraint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getJitConstraintRule()); }
	iv_ruleJitConstraint=ruleJitConstraint
	{ $current=$iv_ruleJitConstraint.current; }
	EOF;

// Rule JitConstraint
ruleJitConstraint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			$current = forceCreateModelElement(
				grammarAccess.getJitConstraintAccess().getJitBoundsAction(),
				$current);
		}
	)
;

// Entry rule entryRuleTimeConstraint
entryRuleTimeConstraint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTimeConstraintRule()); }
	iv_ruleTimeConstraint=ruleTimeConstraint
	{ $current=$iv_ruleTimeConstraint.current; }
	EOF;

// Rule TimeConstraint
ruleTimeConstraint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getTimeConstraintAccess().getTimeBoundsAction_0(),
					$current);
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getTimeConstraintAccess().getLowerEBigDecimalParserRuleCall_1_0());
				}
				lv_lower_1_0=ruleEBigDecimal
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTimeConstraintRule());
					}
					set(
						$current,
						"lower",
						lv_lower_1_0,
						"org.eclipse.lsat.activity.teditor.Activity.EBigDecimal");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=','
		{
			newLeafNode(otherlv_2, grammarAccess.getTimeConstraintAccess().getCommaKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getTimeConstraintAccess().getUpperEBigDecimalParserRuleCall_3_0());
				}
				lv_upper_3_0=ruleEBigDecimal
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getTimeConstraintRule());
					}
					set(
						$current,
						"upper",
						lv_upper_3_0,
						"org.eclipse.lsat.activity.teditor.Activity.EBigDecimal");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleInfiniteTimeConstraint
entryRuleInfiniteTimeConstraint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getInfiniteTimeConstraintRule()); }
	iv_ruleInfiniteTimeConstraint=ruleInfiniteTimeConstraint
	{ $current=$iv_ruleInfiniteTimeConstraint.current; }
	EOF;

// Rule InfiniteTimeConstraint
ruleInfiniteTimeConstraint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			$current = forceCreateModelElement(
				grammarAccess.getInfiniteTimeConstraintAccess().getTimeBoundsAction(),
				$current);
		}
	)
;

// Entry rule entryRuleSourceReference
entryRuleSourceReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getSourceReferenceRule()); }
	iv_ruleSourceReference=ruleSourceReference
	{ $current=$iv_ruleSourceReference.current; }
	EOF;

// Rule SourceReference
ruleSourceReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getSourceReferenceAccess().getSourceReferenceAction_0(),
					$current);
			}
		)
		(
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getSourceReferenceRule());
						}
					}
					otherlv_1=RULE_ID
					{
						newLeafNode(otherlv_1, grammarAccess.getSourceReferenceAccess().getNodeActionCrossReference_1_0_0());
					}
				)
			)
			    |
			(
				otherlv_2='|'
				{
					newLeafNode(otherlv_2, grammarAccess.getSourceReferenceAccess().getVerticalLineKeyword_1_1_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getSourceReferenceRule());
							}
						}
						otherlv_3=RULE_ID
						{
							newLeafNode(otherlv_3, grammarAccess.getSourceReferenceAccess().getNodeSyncBarCrossReference_1_1_1_0());
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRuleDependencyTarget
entryRuleDependencyTarget returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDependencyTargetRule()); }
	iv_ruleDependencyTarget=ruleDependencyTarget
	{ $current=$iv_ruleDependencyTarget.current; }
	EOF;

// Rule DependencyTarget
ruleDependencyTarget returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getDependencyTargetAccess().getTargetReferenceParserRuleCall_0());
		}
		this_TargetReference_0=ruleTargetReference
		{
			$current = $this_TargetReference_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			{
				newCompositeNode(grammarAccess.getDependencyTargetAccess().getEdgeParserRuleCall_1_0());
			}
			this_Edge_1=ruleEdge
			{
				$current = $this_Edge_1.current;
				afterParserOrEnumRuleCall();
			}
			    |
			{
				newCompositeNode(grammarAccess.getDependencyTargetAccess().getJitConstraintEdgeParserRuleCall_1_1());
			}
			this_JitConstraintEdge_2=ruleJitConstraintEdge
			{
				$current = $this_JitConstraintEdge_2.current;
				afterParserOrEnumRuleCall();
			}
			    |
			{
				newCompositeNode(grammarAccess.getDependencyTargetAccess().getTimeConstraintEdgeParserRuleCall_1_2());
			}
			this_TimeConstraintEdge_3=ruleTimeConstraintEdge
			{
				$current = $this_TimeConstraintEdge_3.current;
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleTargetReference
entryRuleTargetReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTargetReferenceRule()); }
	iv_ruleTargetReference=ruleTargetReference
	{ $current=$iv_ruleTargetReference.current; }
	EOF;

// Rule TargetReference
ruleTargetReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getTargetReferenceAccess().getTargetReferenceAction_0(),
					$current);
			}
		)
		(
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getTargetReferenceRule());
						}
					}
					otherlv_1=RULE_ID
					{
						newLeafNode(otherlv_1, grammarAccess.getTargetReferenceAccess().getNodeActionCrossReference_1_0_0());
					}
				)
			)
			    |
			(
				otherlv_2='|'
				{
					newLeafNode(otherlv_2, grammarAccess.getTargetReferenceAccess().getVerticalLineKeyword_1_1_0());
				}
				(
					(
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getTargetReferenceRule());
							}
						}
						otherlv_3=RULE_ID
						{
							newLeafNode(otherlv_3, grammarAccess.getTargetReferenceAccess().getNodeSyncBarCrossReference_1_1_1_0());
						}
					)
				)
			)
		)
	)
;

// Entry rule entryRuleEvent
entryRuleEvent returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEventRule()); }
	iv_ruleEvent=ruleEvent
	{ $current=$iv_ruleEvent.current; }
	EOF;

// Rule Event
ruleEvent returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='event'
		{
			newLeafNode(otherlv_0, grammarAccess.getEventAccess().getEventKeyword_0());
		}
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getEventAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEventRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			otherlv_2='('
			{
				newLeafNode(otherlv_2, grammarAccess.getEventAccess().getLeftParenthesisKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getEventAccess().getItemsEventItemParserRuleCall_2_1_0());
					}
					lv_items_3_0=ruleEventItem
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEventRule());
						}
						add(
							$current,
							"items",
							lv_items_3_0,
							"org.eclipse.lsat.activity.teditor.Activity.EventItem");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_4=','
				{
					newLeafNode(otherlv_4, grammarAccess.getEventAccess().getCommaKeyword_2_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getEventAccess().getItemsEventItemParserRuleCall_2_2_1_0());
						}
						lv_items_5_0=ruleEventItem
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getEventRule());
							}
							add(
								$current,
								"items",
								lv_items_5_0,
								"org.eclipse.lsat.activity.teditor.Activity.EventItem");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_6=')'
			{
				newLeafNode(otherlv_6, grammarAccess.getEventAccess().getRightParenthesisKeyword_2_3());
			}
		)?
	)
;

// Entry rule entryRuleEventItem
entryRuleEventItem returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEventItemRule()); }
	iv_ruleEventItem=ruleEventItem
	{ $current=$iv_ruleEventItem.current; }
	EOF;

// Rule EventItem
ruleEventItem returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getEventItemAccess().getEventItemAction_0(),
					$current);
			}
		)
		(
			(
				lv_name_1_0=RULE_ID
				{
					newLeafNode(lv_name_1_0, grammarAccess.getEventItemAccess().getNameIDTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEventItemRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
	)
;

// Entry rule entryRuleIID
entryRuleIID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIIDRule()); }
	iv_ruleIID=ruleIID
	{ $current=$iv_ruleIID.current.getText(); }
	EOF;

// Rule IID
ruleIID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_INT_0=RULE_INT
		{
			$current.merge(this_INT_0);
		}
		{
			newLeafNode(this_INT_0, grammarAccess.getIIDAccess().getINTTerminalRuleCall_0());
		}
		    |
		this_ID_1=RULE_ID
		{
			$current.merge(this_ID_1);
		}
		{
			newLeafNode(this_ID_1, grammarAccess.getIIDAccess().getIDTerminalRuleCall_1());
		}
	)
;

// Entry rule entryRuleEBigDecimal
entryRuleEBigDecimal returns [String current=null]:
	{ newCompositeNode(grammarAccess.getEBigDecimalRule()); }
	iv_ruleEBigDecimal=ruleEBigDecimal
	{ $current=$iv_ruleEBigDecimal.current.getText(); }
	EOF;

// Rule EBigDecimal
ruleEBigDecimal returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			kw='-'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getHyphenMinusKeyword_0());
			}
		)?
		this_INT_1=RULE_INT
		{
			$current.merge(this_INT_1);
		}
		{
			newLeafNode(this_INT_1, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_1());
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getFullStopKeyword_2_0());
			}
			this_INT_3=RULE_INT
			{
				$current.merge(this_INT_3);
			}
			{
				newLeafNode(this_INT_3, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_2_1());
			}
		)?
		(
			(
				kw='E'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getEKeyword_3_0_0());
				}
				    |
				kw='e'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getEKeyword_3_0_1());
				}
			)
			(
				kw='+'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getPlusSignKeyword_3_1_0());
				}
				    |
				kw='-'
				{
					$current.merge(kw);
					newLeafNode(kw, grammarAccess.getEBigDecimalAccess().getHyphenMinusKeyword_3_1_1());
				}
			)
			this_INT_8=RULE_INT
			{
				$current.merge(this_INT_8);
			}
			{
				newLeafNode(this_INT_8, grammarAccess.getEBigDecimalAccess().getINTTerminalRuleCall_3_2());
			}
		)?
	)
;

// Entry rule entryRuleEString
entryRuleEString returns [String current=null]:
	{ newCompositeNode(grammarAccess.getEStringRule()); }
	iv_ruleEString=ruleEString
	{ $current=$iv_ruleEString.current.getText(); }
	EOF;

// Rule EString
ruleEString returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_STRING_0=RULE_STRING
		{
			$current.merge(this_STRING_0);
		}
		{
			newLeafNode(this_STRING_0, grammarAccess.getEStringAccess().getSTRINGTerminalRuleCall_0());
		}
		    |
		this_ID_1=RULE_ID
		{
			$current.merge(this_ID_1);
		}
		{
			newLeafNode(this_ID_1, grammarAccess.getEStringAccess().getIDTerminalRuleCall_1());
		}
	)
;

// Rule Scheduling
ruleScheduling returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='ASAP'
			{
				$current = grammarAccess.getSchedulingAccess().getASAPEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getSchedulingAccess().getASAPEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='ALAP'
			{
				$current = grammarAccess.getSchedulingAccess().getALAPEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getSchedulingAccess().getALAPEnumLiteralDeclaration_1());
			}
		)
	)
;

// Rule TransferType
ruleTransferType returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='in'
			{
				$current = grammarAccess.getTransferTypeAccess().getINEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getTransferTypeAccess().getINEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='out'
			{
				$current = grammarAccess.getTransferTypeAccess().getOUTEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getTransferTypeAccess().getOUTEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='entry'
			{
				$current = grammarAccess.getTransferTypeAccess().getENTRYEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getTransferTypeAccess().getENTRYEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='exit'
			{
				$current = grammarAccess.getTransferTypeAccess().getEXITEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getTransferTypeAccess().getEXITEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='\u00E7hange'
			{
				$current = grammarAccess.getTransferTypeAccess().getUNKNOWNEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getTransferTypeAccess().getUNKNOWNEnumLiteralDeclaration_4());
			}
		)
	)
;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
