# coding: utf-8

"""
    LSAT API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.5.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from lsat_client.models.lsat_base import LsatBase
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from lsat_client.models.bounds import Bounds
from lsat_client.models.stochastic_measurements import StochasticMeasurements
from lsat_client.models.stochastic_properties import StochasticProperties
from typing import Optional, Set
from typing_extensions import Self

class StochasticAnnotation(LsatBase):
    """
    StochasticAnnotation
    """ # noqa: E501
    start_time: StochasticProperties = Field(alias="startTime")
    confidence_interval: Optional[Bounds] = Field(default=None, alias="confidenceInterval")
    criticality: Union[StrictFloat, StrictInt]
    measurements: Optional[StochasticMeasurements] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["startTime", "confidenceInterval", "criticality", "measurements"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StochasticAnnotation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of start_time
        if self.start_time:
            _dict['startTime'] = self.start_time.to_dict()
        # override the default output from pydantic by calling `to_dict()` of confidence_interval
        if self.confidence_interval:
            _dict['confidenceInterval'] = self.confidence_interval.to_dict()
        # override the default output from pydantic by calling `to_dict()` of measurements
        if self.measurements:
            _dict['measurements'] = self.measurements.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StochasticAnnotation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "startTime": StochasticProperties.from_dict(obj["startTime"]) if obj.get("startTime") is not None else None,
            "confidenceInterval": Bounds.from_dict(obj["confidenceInterval"]) if obj.get("confidenceInterval") is not None else None,
            "criticality": obj.get("criticality"),
            "measurements": StochasticMeasurements.from_dict(obj["measurements"]) if obj.get("measurements") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


