/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.SyntaxException;
import org.eclipse.ocl.TypeChecker;
import org.eclipse.ocl.lpg.AbstractBasicEnvironment;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.BasicEnvironment2;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.ocl.parser.OCLProblemHandler;
import org.eclipse.ocl.util.Adaptable;
import org.eclipse.ocl.util.OCLTypeChecker;
import org.eclipse.ocl.util.ProblemAware;
import org.eclipse.ocl.utilities.TypedElement;

public final class OCLUtil {
    public static final String PLUGIN_ID = "org.eclipse.ocl";
    private static final Map<Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?>, Reference<BasicEnvironment2>> environments = new WeakHashMap();
    private static final Map<Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?>, Reference<TypeChecker<?, ?, ?>>> typesCheckerEnvironments = new WeakHashMap();

    private OCLUtil() {
    }

    public static <T> T getAdapter(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env, Class<T> adapterType) {
        Object result = env instanceof Adaptable ? ((Adaptable)((Object)env)).getAdapter(adapterType) : (adapterType.isInstance(env) ? env : null);
        if (result == null) {
            if (adapterType == TypeChecker.class) {
                result = OCLUtil.getTypeChecker(env);
            } else if (adapterType == BasicEnvironment.class) {
                result = OCLUtil.getBasicEnvironment(env);
            } else if (adapterType == BasicEnvironment2.class) {
                result = OCLUtil.getBasicEnvironment(env);
            } else if (adapterType == ProblemHandler.class) {
                result = OCLUtil.getAdapter(env, BasicEnvironment.class).getProblemHandler();
            } else if (adapterType == Environment.Lookup.class) {
                final Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> _env = env;
                result = new Environment.Lookup<Object, Object, Object, Object>(){

                    @Override
                    public Object tryLookupPackage(List<String> names) throws LookupException {
                        return _env.lookupPackage(names);
                    }

                    @Override
                    public Object tryLookupClassifier(List<String> names) throws LookupException {
                        return _env.lookupClassifier(names);
                    }

                    @Override
                    public Object tryLookupOperation(Object owner, String name, List<? extends TypedElement<Object>> args) throws LookupException {
                        return _env.lookupOperation(owner, name, args);
                    }

                    @Override
                    public Object tryLookupProperty(Object owner, String name) throws LookupException {
                        return _env.lookupProperty(owner, name);
                    }

                    @Override
                    public Object tryLookupAssociationClassReference(Object owner, String name) throws LookupException {
                        return _env.lookupAssociationClassReference(owner, name);
                    }

                    @Override
                    public Object tryLookupSignal(Object owner, String name, List<? extends TypedElement<Object>> args) throws LookupException {
                        return _env.lookupSignal(owner, name, args);
                    }
                };
            }
        }
        return result;
    }

    private static BasicEnvironment2 getBasicEnvironment(final Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env) {
        BasicEnvironment2 result = null;
        Reference<BasicEnvironment2> ref = environments.get(env);
        if (ref != null) {
            result = ref.get();
        }
        if (result == null) {
            result = new AbstractBasicEnvironment(null){

                @Override
                public <T> T getAdapter(Class<T> adapterType) {
                    if (adapterType == Environment.class) {
                        return (T)env;
                    }
                    return super.getAdapter(adapterType);
                }
            };
            environments.put(env, new WeakReference<BasicEnvironment2>(result));
        }
        return result;
    }

    private static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> TypeChecker<C, O, P> getTypeChecker(Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> env) {
        TypeChecker<?, ?, ?> result = null;
        Reference<TypeChecker<?, ?, ?>> ref = typesCheckerEnvironments.get(env);
        if (ref != null) {
            result = ref.get();
        }
        if (result == null) {
            result = new OCLTypeChecker(env);
            typesCheckerEnvironments.put(env, new WeakReference(result));
        }
        return result;
    }

    public static <T> T getAdapter(EnvironmentFactory<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> factory, Class<T> adapterType) {
        Object result = factory instanceof Adaptable ? ((Adaptable)((Object)factory)).getAdapter(adapterType) : (adapterType.isInstance(factory) ? factory : null);
        if (result == null && adapterType == EnvironmentFactory.Lookup.class) {
            final EnvironmentFactory<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> _factory = factory;
            result = new EnvironmentFactory.Lookup<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object>(){

                @Override
                public Environment<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object> tryCreatePackageContext(Environment<Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object, Object> parent, List<String> pathname) throws LookupException {
                    return _factory.createPackageContext(parent, pathname);
                }
            };
        }
        return result;
    }

    public static <T> T getAdapter(EvaluationEnvironment<?, ?, ?, ?, ?> env, Class<T> adapterType) {
        Object result = env instanceof Adaptable ? ((Adaptable)((Object)env)).getAdapter(adapterType) : (adapterType.isInstance(env) ? env : null);
        return result;
    }

    public static Diagnostic checkForErrors(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env) throws SyntaxException, SemanticException {
        return OCLUtil.checkForErrors(OCLUtil.getAdapter(env, ProblemHandler.class));
    }

    public static Diagnostic checkForErrors(ProblemHandler problemHandler) throws SyntaxException, SemanticException {
        Diagnostic result = null;
        if (problemHandler instanceof OCLProblemHandler && (result = ((OCLProblemHandler)problemHandler).getDiagnostic()) != null && result.getSeverity() >= 4) {
            List data = result.getData();
            if (data.contains(ProblemHandler.Phase.LEXER) || data.contains(ProblemHandler.Phase.PARSER)) {
                throw new SyntaxException(result);
            }
            throw new SemanticException(result);
        }
        return result;
    }

    public static Diagnostic checkForErrorsOrWarnings(Environment<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> env) throws SyntaxException, SemanticException {
        return OCLUtil.checkForErrorsOrWarnings(OCLUtil.getAdapter(env, ProblemHandler.class));
    }

    public static Diagnostic checkForErrorsOrWarnings(ProblemHandler problemHandler) throws SyntaxException, SemanticException {
        Diagnostic result = null;
        if (problemHandler instanceof OCLProblemHandler && (result = ((OCLProblemHandler)problemHandler).getDiagnostic()) != null && result.getSeverity() >= 2) {
            List data = result.getData();
            if (data.contains(ProblemHandler.Phase.LEXER) || data.contains(ProblemHandler.Phase.PARSER)) {
                throw new SyntaxException(result);
            }
            throw new SemanticException(result);
        }
        return result;
    }

    public static <PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> Environment<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> getValidationEnvironment(Object target, Map<Object, Object> context) {
        Environment result = (Environment)context.get(Environment.class);
        if (result == null && (result = Environment.Registry.INSTANCE.getEnvironmentFor(target)) != null) {
            context.put(Environment.class, result);
        }
        return result;
    }

    public static <C, CLS, E> Diagnostic getEvaluationProblems(Query<C, CLS, E> query) {
        if (query instanceof ProblemAware) {
            ProblemAware problemAware = (ProblemAware)((Object)query);
            return problemAware.getProblems();
        }
        return null;
    }
}

