/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c89.typeinfos;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.DataValue;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.c89.C89DataValue;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfo;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89TypeInfoHelper;
import org.eclipse.escet.cif.codegen.typeinfos.StringTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.FormatDecoder;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class C89StringTypeInfo
extends StringTypeInfo
implements C89TypeInfo {
    public final boolean genLocalFunctions;

    public C89StringTypeInfo(boolean genLocalFunctions, CifType cifType) {
        super(cifType);
        this.genLocalFunctions = genLocalFunctions;
    }

    @Override
    public boolean supportRawMemCmp() {
        return false;
    }

    @Override
    public boolean useValues() {
        return false;
    }

    @Override
    public String getTypePrintName(boolean rawString) {
        return rawString ? "StringTypePrintRaw" : "StringTypePrintEscaped";
    }

    @Override
    public ExprCode convertLiteral(String value, Destination dest, CodeContext ctxt) {
        Object destRef;
        ExprCode result = new ExprCode();
        if (dest == null) {
            VariableInformation tempVar = ctxt.makeTempVariable(this, "str_tmp");
            destRef = "&" + tempVar.targetRef;
            result.add(Strings.fmt((String)"%s %s;", (Object[])new Object[]{this.getTargetType(), tempVar.targetRef}));
            result.setDataValue(C89DataValue.makeValue(tempVar.targetRef));
        } else {
            destRef = dest.getReference();
        }
        result.add(Strings.fmt((String)"StringTypeCopyText(%s, %s);", (Object[])new Object[]{destRef, value}));
        return result;
    }

    @Override
    public ExprCode convertConcatenation(BinaryExpression expr, Destination dest, CodeContext ctxt) {
        Object destRef;
        ExprCode leftCode = ctxt.exprToTarget(expr.getLeft(), null);
        ExprCode rightCode = ctxt.exprToTarget(expr.getRight(), null);
        ExprCode result = new ExprCode();
        result.add(leftCode);
        result.add(rightCode);
        if (dest == null) {
            VariableInformation tempVar = ctxt.makeTempVariable(this, "str_tmp");
            destRef = "&" + tempVar.targetRef;
            result.add(Strings.fmt((String)"%s %s;", (Object[])new Object[]{this.getTargetType(), tempVar.targetRef}));
            result.setDataValue(C89DataValue.makeValue(tempVar.targetRef));
        } else {
            destRef = dest.getReference();
        }
        String leftRef = C89DataValue.constructReference(leftCode.getRawDataValue(), (TypeInfo)this, ctxt, result);
        String rightRef = C89DataValue.constructReference(rightCode.getRawDataValue(), (TypeInfo)this, ctxt, result);
        result.add(Strings.fmt((String)"StringTypeConcat(%s, %s, %s);", (Object[])new Object[]{destRef, leftRef, rightRef}));
        return result;
    }

    @Override
    public ExprCode convertSizeStdLib(Expression expression, Destination dest, CodeContext ctxt) {
        ExprCode argCode = ctxt.exprToTarget(expression, null);
        ExprCode result = new ExprCode();
        result.add(argCode.getCode());
        String argRef = C89DataValue.constructReference(argCode.getRawDataValue(), (TypeInfo)this, ctxt, result);
        result.setDestination(dest);
        String resultText = Strings.fmt((String)"StringTypeSize(%s)", (Object[])new Object[]{argRef});
        result.setDataValue(C89DataValue.makeComputed(resultText));
        return result;
    }

    @Override
    public ExprCode convertFormatFunction(String pattern, List<Expression> args, List<CifType> argTypes, Destination dest, CodeContext ctxt) {
        boolean needsDestScratch;
        Object destScratch;
        String destValue;
        ExprCode result = new ExprCode();
        MemoryCodeBox code = ctxt.makeCodeBox();
        code.add("{");
        code.indent();
        FormatDecoder decoder = new FormatDecoder();
        List parts = decoder.decode(pattern);
        String[] argText = this.convertFmtArguments(parts, args, argTypes, (CodeBox)code, ctxt);
        if (dest == null) {
            VariableInformation tempVar = ctxt.makeTempVariable(this, "str_tmp");
            destValue = tempVar.targetRef;
            destScratch = "&" + destValue;
            needsDestScratch = false;
            result.add(Strings.fmt((String)"%s %s;", (Object[])new Object[]{this.getTargetType(), tempVar.targetRef}));
            result.setDataValue(C89DataValue.makeValue(tempVar.targetRef));
        } else {
            destValue = dest.getData();
            needsDestScratch = false;
            destScratch = "&" + destValue;
            for (CifType type : argTypes) {
                if (!(type instanceof StringType)) continue;
                destScratch = "&dest_scratch";
                needsDestScratch = true;
                break;
            }
        }
        boolean needsScratch = false;
        for (CifType argType : argTypes) {
            needsScratch = this.argumentNeedsScratchSpace(argType);
            if (needsScratch) break;
        }
        String strSize = "(MAX_STRING_SIZE + 1) > 128 ? (MAX_STRING_SIZE + 1) : 128";
        if (needsScratch) {
            code.add("char scratch[%s]; /* Value scratch space. */", new Object[]{strSize});
        }
        if (needsDestScratch) {
            code.add("StringType dest_scratch; /* Resulting string scratch space. */");
        }
        code.add("int index = 0;");
        int implicitIndex = 0;
        for (FormatDescription part : parts) {
            String flags;
            int idx = 0;
            if (part.conversion != FormatDescription.Conversion.LITERAL) {
                idx = !part.index.isEmpty() ? part.getExplicitIndex() - 1 : implicitIndex++;
            }
            if (part.flags == null) {
                flags = "FMTFLAGS_NONE";
            } else {
                List flagsParts = Lists.list();
                if (part.flags.contains("-")) {
                    flagsParts.add("FMTFLAGS_LEFT");
                }
                if (part.flags.contains("+")) {
                    flagsParts.add("FMTFLAGS_SIGN");
                }
                if (part.flags.contains(" ")) {
                    flagsParts.add("FMTFLAGS_SPACE");
                }
                if (part.flags.contains("0")) {
                    flagsParts.add("FMTFLAGS_ZEROES");
                }
                if (part.flags.contains(",")) {
                    flagsParts.add("FMTFLAGS_GROUPS");
                }
                flags = flagsParts.isEmpty() ? "FMTFLAGS_NONE" : String.join((CharSequence)"|", flagsParts);
            }
            String width = part.width;
            if (width == null || width.isEmpty()) {
                width = "0";
            }
            String text = this.convertArgument(part, argTypes.get(idx), argText[idx], (CodeBox)code, ctxt);
            code.add("index = StringTypeAppendText(%s, index, %s, %s, %s);", new Object[]{destScratch, flags, width, text});
        }
        if (needsDestScratch) {
            code.add("memcpy(%s.data, dest_scratch.data, MAX_STRING_SIZE);", new Object[]{destValue});
        }
        code.dedent();
        code.add("}");
        result.add((CodeBox)code);
        return result;
    }

    private String[] convertFmtArguments(List<FormatDescription> parts, List<Expression> args, List<CifType> argTypes, CodeBox code, CodeContext ctxt) {
        int[] usageCount = this.countFmtParamUsages(args.size(), parts);
        String[] argText = new String[args.size()];
        int i = 0;
        while (i < argText.length) {
            CifType argType = argTypes.get(i);
            TypeInfo argTi = ctxt.typeToTarget(argType);
            if (usageCount[i] == 0) {
                argText[i] = null;
            } else if (usageCount[i] == 1) {
                ExprCode argCode = ctxt.exprToTarget(args.get(i), null);
                code.add((Box)argCode.getCode());
                if (C89TypeInfoHelper.typeUsesValues(argTi)) {
                    argText[i] = argCode.getData();
                } else {
                    DataValue dataValue = argCode.getRawDataValue();
                    if (dataValue.canBeReferenced()) {
                        argText[i] = dataValue.getReference();
                    } else {
                        VariableInformation tempVar = ctxt.makeTempVariable(argTi, "fmt_temp");
                        code.add("%s %s = %s;", new Object[]{argTi.getTargetType(), tempVar.targetRef, dataValue.getData()});
                        argText[i] = "&" + tempVar.targetRef;
                    }
                }
            } else {
                VariableInformation tempVar = ctxt.makeTempVariable(argTi, "fmt_temp");
                ExprCode argCode = ctxt.exprToTarget(args.get(i), null);
                code.add((Box)argCode.getCode());
                if (C89TypeInfoHelper.typeUsesValues(argTi)) {
                    code.add("%s %s = %s;", new Object[]{argTi.getTargetType(), tempVar.targetRef, argCode.getData()});
                    argText[i] = tempVar.targetRef;
                } else {
                    DataValue dataValue = argCode.getRawDataValue();
                    if (dataValue.canBeReferenced()) {
                        code.add("%s *%s = %s;", new Object[]{argTi.getTargetType(), tempVar.targetRef, dataValue.getReference()});
                        argText[i] = tempVar.targetRef;
                    } else {
                        code.add("%s %s = %s;", new Object[]{argTi.getTargetType(), tempVar.targetRef, dataValue.getData()});
                        argText[i] = "&" + tempVar.targetRef;
                    }
                }
            }
            ++i;
        }
        return argText;
    }

    private int[] countFmtParamUsages(int numArgs, List<FormatDescription> parts) {
        int[] usageCount = new int[numArgs];
        int i = 0;
        while (i < usageCount.length) {
            usageCount[i] = 0;
            ++i;
        }
        int implicitIndex = 0;
        for (FormatDescription part : parts) {
            if (part.conversion == FormatDescription.Conversion.LITERAL) continue;
            int idx = !part.index.isEmpty() ? part.getExplicitIndex() - 1 : implicitIndex++;
            Assert.check((idx >= 0 && idx < usageCount.length ? 1 : 0) != 0);
            int n = idx;
            usageCount[n] = usageCount[n] + 1;
        }
        return usageCount;
    }

    private String convertArgument(FormatDescription part, CifType argType, String argText, CodeBox code, CodeContext ctxt) {
        if (part.conversion.equals((Object)FormatDescription.Conversion.LITERAL)) {
            return "\"" + Strings.escape((String)part.text) + "\"";
        }
        if (argType instanceof BoolType) {
            if (part.text.contains("B")) {
                return Strings.fmt((String)"(%s) ? \"TRUE\" : \"FALSE\"", (Object[])new Object[]{argText});
            }
            return Strings.fmt((String)"(%s) ? \"true\" : \"false\"", (Object[])new Object[]{argText});
        }
        if (argType instanceof IntType) {
            String fmtPat = part.text.contains("X") ? "X" : (part.text.contains("x") ? "x" : "d");
            code.add("sprintf(scratch, \"%%%s\", %s);", new Object[]{fmtPat, argText});
            return "scratch";
        }
        if (argType instanceof RealType) {
            Object fmtPat;
            if (part.precision == null || part.precision.isEmpty()) {
                fmtPat = "%";
            } else {
                int precision = Integer.parseInt(part.precision);
                if (precision < 0) {
                    precision = 0;
                }
                if (precision > 30) {
                    precision = 30;
                }
                fmtPat = Strings.fmt((String)"%%.%d", (Object[])new Object[]{precision});
            }
            fmtPat = part.text.contains("e") ? (String)fmtPat + "e" : (part.text.contains("E") ? (String)fmtPat + "E" : (part.text.contains("g") ? (String)fmtPat + "g" : (part.text.contains("G") ? (String)fmtPat + "G" : (String)fmtPat + "f")));
            code.add("sprintf(scratch, \"%s\", %s);", new Object[]{fmtPat, argText});
            return "scratch";
        }
        if (argType instanceof StringType) {
            return Strings.fmt((String)"(%s)->data", (Object[])new Object[]{argText});
        }
        if (argType instanceof EnumType) {
            return Strings.fmt((String)"%s[%s]", (Object[])new Object[]{"enum_names", argText});
        }
        Assert.check((argType instanceof ListType || argType instanceof TupleType ? 1 : 0) != 0);
        TypeInfo paramTi = ctxt.typeToTarget(argType);
        code.add("%s(%s, scratch, 0, MAX_STRING_SIZE);", new Object[]{C89TypeInfoHelper.typeGetTypePrintName(paramTi, false), argText});
        return "scratch";
    }

    private boolean argumentNeedsScratchSpace(CifType argType) {
        return argType instanceof IntType || argType instanceof RealType || argType instanceof ListType || argType instanceof TupleType;
    }

    @Override
    public ExprCode getProjectedValue(ExprCode stringCode, ExprCode indexCode, Destination dest, CodeContext ctxt) {
        Object destRef;
        ExprCode result = new ExprCode();
        result.add(stringCode);
        result.add(indexCode);
        if (dest == null) {
            VariableInformation tempVar = ctxt.makeTempVariable(this, "str_tmp");
            destRef = "&" + tempVar.targetRef;
            result.add(Strings.fmt((String)"%s %s;", (Object[])new Object[]{this.getTargetType(), tempVar.targetRef}));
            result.setDataValue(C89DataValue.makeValue(tempVar.targetRef));
        } else {
            destRef = dest.getReference();
        }
        String stringRef = C89DataValue.constructReference(stringCode.getRawDataValue(), (TypeInfo)this, ctxt, result);
        result.add(Strings.fmt((String)"StringTypeProject(%s, %s, %s);", (Object[])new Object[]{destRef, stringRef, indexCode.getData()}));
        return result;
    }

    @Override
    public String getTargetType() {
        return "StringType";
    }

    @Override
    public void generateCode(CodeContext ctxt) {
    }

    @Override
    public void storeValue(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s = %s;", new Object[]{dest.getData(), sourceValue.getData()});
    }

    @Override
    public void declareInit(CodeBox code, DataValue sourceValue, Destination dest) {
        code.add((Box)dest.getCode());
        code.add("%s %s = %s;", new Object[]{this.getTargetType(), dest.getData(), sourceValue.getData()});
    }

    @Override
    public String getBinaryExpressionTemplate(BinaryOperator binOp, CodeContext ctxt) {
        if (binOp.equals((Object)BinaryOperator.EQUAL)) {
            return "StringTypeEquals(${left-ref}, ${right-ref})";
        }
        if (binOp.equals((Object)BinaryOperator.UNEQUAL)) {
            return "!StringTypeEquals(${left-ref}, ${right-ref})";
        }
        throw new RuntimeException("Unexpected binary operator: " + Strings.str((Object)binOp));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof C89StringTypeInfo;
    }

    @Override
    public int hashCode() {
        return C89StringTypeInfo.class.hashCode();
    }
}

