/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.GammaDistribution;
import org.eclipse.escet.cif.simulator.runtime.distributions.RealDistribution;
import org.eclipse.escet.common.java.Strings;

public class ErlangDistribution
extends RealDistribution {
    private final CifRandomGenerator randGen;
    private final int m;
    private final double b;

    public ErlangDistribution(CifRandomGenerator randGen, int m, double b) {
        this.randGen = randGen;
        this.m = m;
        this.b = b;
        if (m <= 0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The shape parameter (the first parameter) is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
        if (b <= 0.0) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The scale parameter (the second parameter) is not positive.";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private ErlangDistribution(ErlangDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.m = distribution.m;
        this.b = distribution.b;
    }

    @Override
    public RealDistribution copy() {
        return new ErlangDistribution(this);
    }

    @Override
    public double sample() {
        return GammaDistribution.sample(this.randGen, this.m, this.b);
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"erlang(%s, %s)", (Object[])new Object[]{CifSimulatorMath.intToStr(this.m), CifSimulatorMath.realToStr(this.b)});
    }
}

